package BABO;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.Line2D.Double;
import java.net.IDN;
import java.util.ArrayList;
import java.util.Random;

import BABO.ranking.RankedBaBo;
import BABO.ranking.Ranker;

public class TileManager {
	private ArrayList<Tile> ivTileList = new ArrayList<Tile>();

	private Point2D ivStartPoint = new Point2D.Double(0, 0);

	private ArrayList<Tile> ivbuildinTileList = new ArrayList<Tile>();
	private ArrayList<Tile> ivopenTileList = new ArrayList<Tile>();

	private ArrayList<Clip> ivClips = new ArrayList<Clip>();

	private Random rand = new Random();

	private boolean isStopped = false;

	int ausgesondertcounter = 0;
	int ausgesondertlevel = 1;

	private boolean isBuilding = true;

	private Ranker ivRanker = null;
	private int fehlendelaschecounter = 0;

	public TileManager() {
		initTiles();
	}

	public void setStartPosition(int x, int y) {
		ivStartPoint = new Point2D.Double(x, y);
		init();
	}

	public void setTiles(ArrayList<Tile> tiles) {
		if (tiles != null) {
			ivTileList = tiles;
			for (int i = 0; i < ivTileList.size(); i++) {
				ivTileList.get(i).setManager(this);
			}
			ivbuildinTileList.clear();
			ivopenTileList = (ArrayList<Tile>) tiles.clone();
		}
	}

	private void initTiles() {// TODO Testmethode
		// ivTileList.add(new Tile(0, 1,4,3,2));
		// ivTileList.add(new Tile(1, 2,3,7,6));
		// ivTileList.add(new Tile(2, 1,2,6,5));
		// ivTileList.add(new Tile(3, 5,6,7,8));
		// ivTileList.add(new Tile(4, 1,5,8,4));
		// ivTileList.add(new Tile(5, 4,8,7,3));
		//		
		// ivTileList.add(new Tile(30, 13,43,33,23));
		// ivTileList.add(new Tile(31, 23,33,73,63));
		// ivTileList.add(new Tile(32, 13,23,63,2));
		// ivTileList.add(new Tile(33, 2,63,73,3));
		// ivTileList.add(new Tile(34, 13,2,3,43));
		// ivTileList.add(new Tile(35, 43,3,73,33));

		// Ecke aus 3 Kstchen X
		// XX
		//		
		// ivTileList.add(new Tile(0, 1,4,3,2));
		// ivTileList.add(new Tile(1, 2,3,7,6));
		// ivTileList.add(new Tile(2, 1,2,6,5));
		// // ivTileList.add(new Tile(3, 5,6,7,8));
		// ivTileList.add(new Tile(4, 1,5,8,4));
		// ivTileList.add(new Tile(5, 4,8,7,3));
		//		
		// // ivTileList.add(new Tile(10, 5,8,7,6));
		// ivTileList.add(new Tile(11, 6,7,71,61));
		// ivTileList.add(new Tile(12, 5,6,61,51));
		// ivTileList.add(new Tile(13, 51,61,71,81));
		// ivTileList.add(new Tile(14, 5,51,81,8));
		// ivTileList.add(new Tile(15, 8,81,71,7));
		//		
		// ivTileList.add(new Tile(20, 6,7,32,22));
		// ivTileList.add(new Tile(21, 22,32,72,62));
		// ivTileList.add(new Tile(22, 6,22,62,61));
		// ivTileList.add(new Tile(23, 61,62,72,71));
		// // ivTileList.add(new Tile(24, 6,61,71,7));
		// // ivTileList.add(new Tile(25, 7,71,72,32));
		//
		// ivTileList.add(new Tile(30, 7,43,33,32));
		// ivTileList.add(new Tile(31, 32,33,73,72));
		// // ivTileList.add(new Tile(32, 7,32,72,71));
		// ivTileList.add(new Tile(33, 71,72,73,83));
		// ivTileList.add(new Tile(34, 7,71,83,43));
		// ivTileList.add(new Tile(35, 43,83,73,33));

		// Komplexes Ding

		// ivTileList.add(new Tile(0, 1,2,3,4));
		// ivTileList.add(new Tile(1, 1,4,8,5));
		// ivTileList.add(new Tile(2, 4,3,7,8));
		// ivTileList.add(new Tile(3, 1,2,3,4));
		// ivTileList.add(new Tile(4, 2,3,7,6));
		// ivTileList.add(new Tile(5, 1,2,6,5));
		//		
		// ivTileList.add(new Tile(6, 5,8,12,9));
		// ivTileList.add(new Tile(7, 8,7,11,12));
		// ivTileList.add(new Tile(8, 6,7,11,10));
		// ivTileList.add(new Tile(9, 5,6,10,9));
		//		
		// ivTileList.add(new Tile(10, 9,12,14,13));
		// ivTileList.add(new Tile(11, 10,11,16,15));
		// ivTileList.add(new Tile(12, 9,10,15,13));
		// ivTileList.add(new Tile(13, 15,16,14,13));
		//		
		// ivTileList.add(new Tile(14, 12,19,18,14));
		// ivTileList.add(new Tile(15, 12,11,20,19));
		// ivTileList.add(new Tile(16, 11,20,17,16));
		// ivTileList.add(new Tile(17, 16,17,18,14));
		//		
		// ivTileList.add(new Tile(18, 19,21,31,18));
		// ivTileList.add(new Tile(19, 18,17,32,31));
		// ivTileList.add(new Tile(20, 20,22,32,17));
		//		
		// // ivTileList.add(new Tile(21, 19,23,26,21));
		// // ivTileList.add(new Tile(22, 19,23,24,10));
		// // ivTileList.add(new Tile(23, 20,24,25,22));
		// // ivTileList.add(new Tile(24, 21,26,25,22));
		// // ivTileList.add(new Tile(25, 23,24,25,26));
		// ivTileList.add(new Tile(25, 20,22,21,19));
		//		
		// ivTileList.add(new Tile(26, 21,28,30,31));
		// ivTileList.add(new Tile(27, 21,22,27,28));
		// ivTileList.add(new Tile(28, 22,27,29,32));
		// ivTileList.add(new Tile(29, 31,32,29,30));
		// ivTileList.add(new Tile(30, 30,28,27,29));

		for (int i = 0; i < ivTileList.size(); i++) {
			ivTileList.get(i).setManager(this);
		}

	}

	public void draw(Graphics g) {
		g.setColor(Color.black);
		for (int i = 0; i < ivTileList.size(); i++) {
			ivTileList.get(i).draw((Graphics2D) g);
		}

//		for (int i = 0; i < ivClips.size(); i++) {
//			ivClips.get(i).draw((Graphics2D) g);
//		}

	}

	int restartcounter = 0;

	private void init() {
		ivopenTileList = (ArrayList<Tile>) ivTileList.clone();
	}

	private ArrayList<Tile> overlapingTiles() {
		ArrayList<Tile> l = new ArrayList<Tile>();
		ArrayList<Tile> list = (ArrayList<Tile>) ivbuildinTileList.clone();

		for (int i = 0; i < list.size(); i++) {
			Tile t = list.get(i);
			for (int j = 0; j < list.size(); j++) {
				Tile t2 = list.get(j);
				if (!t.equals(t2) && t.hassamePoints(t2)) {
					if (!l.contains(t)) {
						l.add(t);
						// l.add(t2);
						list.remove(t);
						list.remove(t2);
					}
				}
			}
		}
		return l;
	}
	
	private Tile getFixTile(Tile t1){
		for (int i = 0; i < ivbuildinTileList.size(); i++) {
			Tile t2 = ivbuildinTileList.get(i);
			if(t2.hassamePoints(t1.getFixID1(), t1.getFixPoint1()) && t2.hassamePoints(t1.getFixID2(), t1.getFixPoint2()))
				return t2;
		}
		return null;
	}
	

	public Double getPositions(int id1, int id2) {
		for (int i = 0; i < ivbuildinTileList.size(); i++) {
			Tile t = ivbuildinTileList.get(i);
			if (t.hasIDs(id1, id2)) {
				if (t.getPoint(id1) == null || t.getPoint(id2) == null)
					return null;
				else
					return new Line2D.Double(t.getPoint(id1), t.getPoint(id2));
			}
		}
		return null;
	}

	public void printTiles() {
		for (int i = 0; i < ivTileList.size(); i++) {
			ivTileList.get(i).print();
		}
	}

	private Tile ivNextTile = null;
	private int lowestopentilecount = -1;
	
	public void update() {

		if (ivopenTileList.size() == 0) {
			isBuilding = false;
		}

		if (isBuilding) {
			int randInt = rand.nextInt(ivopenTileList.size());
			int id = ivNextTile != null ? ivNextTile.getID() : ivopenTileList.get(randInt).getID();
			ivNextTile = null;
			
			if (ivbuildinTileList.size() == 0) {
				Tile t = ivopenTileList.get(randInt);
				t.init(ivStartPoint);
				ivbuildinTileList.add(t);
				ivopenTileList.remove(t);

			} else if (id != -1) {
				Tile t = ivopenTileList.get(randInt);

				ivbuildinTileList.add(t);
				ivopenTileList.remove(t);

				boolean plain = false;
				
				t.init();
				Tile t2 = getFixTile(t);
				
				while (!plain && t2 != null && t.hassamePoints(t2) && t.canRandom()) {
					if(t.hasBreak(t2)){
						t.clear(false);
						t.init();
						t2 = getFixTile(t);
					}else{
						plain = true;
					}
				}
				
				if(!plain)
					t.clear(true);
				
				while (!plain && t.hassamePoints(t2) && t.canRandom()) {
						t.clear(false);
						t.init();
						t2 = getFixTile(t);
				}
				
				
				if(overlapingTiles().size() > 0){
					if(ivopenTileList.size() < lowestopentilecount - 1){
//						System.out.println("hier" + ivopenTileList.size());
						ausgesondertcounter = 0;
						ausgesondertlevel = 0;
					}
				}else{
					lowestopentilecount = ivopenTileList.size() < lowestopentilecount || lowestopentilecount == -1 ? ivopenTileList.size() : lowestopentilecount;
				}
					
				
				while (overlapingTiles().size() > 0 && ivbuildinTileList.size() - 1 >= 0) {
					Tile tile = (Tile) ivbuildinTileList.get(ivbuildinTileList.size() - 1);
					ivopenTileList.add(tile);
					ivbuildinTileList.remove(tile);
					tile.clear(true);

					ivNextTile = tile;
					
					ausgesondertcounter++;// TODO verhalten wenn viel nicht
											// passt...neuer
					// startpunkt etc.
					if (ausgesondertcounter > ivopenTileList.size()) {
						ausgesondertcounter = 0;
						ausgesondertlevel++;
						for (int i = 0; i < ausgesondertlevel; i++) {
							if (ivbuildinTileList.size() - 1 >= 0) {
								Tile tile2 = (Tile) ivbuildinTileList.get(ivbuildinTileList.size() - 1);
								ivopenTileList.add(tile2);
								ivbuildinTileList.remove(tile2);
								tile2.clear(true);
							} else {
								ausgesondertcounter = 0;
								ausgesondertlevel = 0;
							}
						}
//						if(ausgesondertlevel > 20){
//							restart();
//							return;
//						}
					}

				}
			}
		} else {
				for (int i = 0; i < ivbuildinTileList.size(); i++) {
					Tile t = ivbuildinTileList.get(i);
					for (int j = 0; j < ivbuildinTileList.size(); j++) {
						if (j == i)
							continue;

						Tile t2 = ivbuildinTileList.get(j);
						t.setLineStates(t2);
					}
				}

				// Add Clips
				for (int i = 0; i < ivbuildinTileList.size(); i++) {
					Tile t = ivbuildinTileList.get(i);
					ArrayList<IDLineWrapper> lines = t.getSolidLines();
					for (int j = 0; j < lines.size(); j++) {
						if (noClipForIDS(lines.get(j))) {
							Clip c = new Clip(lines.get(j));
							if (isClipOverlapping(c)) {
								c.switchSide();
								if (isClipOverlapping(c)) {
									fehlendelaschecounter++;
								} else {
									ivClips.add(c);
									t.setDotted(lines.get(j).getId1(), lines.get(j).getId2());
								}
							} else {
								ivClips.add(c);
								t.setDotted(lines.get(j).getId1(), lines.get(j).getId2());
							}
						}
					}
				}
				
				ArrayList<IDPoint> pl = new ArrayList<IDPoint>(); 
				
				for (int i = 0; i < ivbuildinTileList.size(); i++) {
					Tile t = ivbuildinTileList.get(i);
					IDPoint[] ps = t.getPoints();
					for (int j = 0; j < ps.length; j++) {
						if(!pl.contains(ps[j]))
							pl.add(ps[j]);
					}
				}
				boolean morethanone = false;
				for (int i = pl.size() - 1; i >= 0; i--) {//because of remove, backwards
					IDPoint idp = pl.get(i);
					morethanone = false;
					for (int j = 0; j < pl.size(); j++) {
						IDPoint idp2 = pl.get(j);
						if(!idp.equals(idp2) && idp.getID() == idp2.getID()){
							morethanone = true;
						}
					}
					if(!morethanone)
						pl.remove(i);
				}
				
				
				
				ivRanker.addRankedBaBo(new RankedBaBo(getClonedTiles(), getClonedClips(), pl, fehlendelaschecounter));
				restart();

		}
	}

	private ArrayList<Tile> getClonedTiles() {
		ArrayList<Tile> ret = new ArrayList<Tile>();
		for (int i = 0; i < ivTileList.size(); i++) {
			Tile t = new Tile(ivTileList.get(i));
			ret.add(t);
		}
		return ret;
	}

	private ArrayList<Clip> getClonedClips() {
		ArrayList<Clip> ret = new ArrayList<Clip>();
		for (int i = 0; i < ivClips.size(); i++) {
			Clip c = new Clip(ivClips.get(i));
			ret.add(c);
		}
		return ret;
	}

	private void restart() {
		isBuilding = true;
		ausgesondertcounter = 0;
		ausgesondertlevel = 1;
		fehlendelaschecounter = 0;
		ivbuildinTileList.clear();
		ivopenTileList = (ArrayList<Tile>) ivTileList.clone();
		for (int k = 0; k < ivopenTileList.size(); k++) {
			ivopenTileList.get(k).clear(false);
		}
		ivClips.clear();
	}

	private boolean isClipOverlapping(Clip c) {
		Polygon polc = c.getRectangle();

		for (int i = 0; i < ivbuildinTileList.size(); i++) {
			Tile t = ivbuildinTileList.get(i);
			Rectangle2D rect = t.getRectangle();

			if (polc.intersects(rect))
				return true;
		}
		return false;
	}

	private boolean noClipForIDS(IDLineWrapper lineWrapper) {
		for (int i = 0; i < ivClips.size(); i++) {
			Clip c = ivClips.get(i);
			if (c.hassameIDs(lineWrapper))
				return false;
		}
		return true;
	}

	public boolean isStopped() {
		return isStopped;
	}

	public void setRanker(Ranker ranker) {
		ivRanker = ranker;
	}

}
