package BABO.ranking;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class PrintAction implements ActionListener {

	private boolean isWithnumbers = false;
	private RankedBaBo ivItem = null;

	PrintAction(boolean withnumbers, RankedBaBo item) {
		isWithnumbers = withnumbers;
		ivItem = item;
	}

	public void actionPerformed(ActionEvent e) {
		PrinterJob pj = PrinterJob.getPrinterJob();
		pj.setPrintable(new Printable() {

			private Image image = isWithnumbers ? ivItem.getImage() : ivItem.getImageNoNr();

			public int print(Graphics g, PageFormat pf, int index) {

				if (index > 0 || image == null) {
					return Printable.NO_SUCH_PAGE;
				}

				((Graphics2D) g).translate(pf.getImageableX(), pf.getImageableY());
				int w = image.getWidth(null);
				int h = image.getHeight(null);
				int iw = (int) pf.getImageableWidth();
				int ih = (int) pf.getImageableHeight();

				// ensure image will fit
				int dw = w;
				int dh = h;
				if (dw > iw) {
					dh = (int) (dh * ((float) iw / (float) dw));
					dw = iw;
				}
				if (dh > ih) {
					dw = (int) (dw * ((float) ih / (float) dh));
					dh = ih;
				}
				// centre on page
				int dx = (iw - dw) / 2;
				int dy = (ih - dh) / 2;

				g.drawImage(image, dx, dy, dx + dw, dy + dh, 0, 0, w, h, null);
				return Printable.PAGE_EXISTS;
			}
		}, new PageFormat());
		try {
			pj.print();
		} catch (PrinterException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
	}

}
