package BABO.ranking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

import BABO.BaBoPanel;

public class RankListRenderer extends DefaultListCellRenderer{

	private static final float cvMaxPicWidth = 400;
	private static final float cvMaxPicHeight = 400;
	
	public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
		JLabel l = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
		
		JPanel p = new JPanel(new BorderLayout());
		
		if(value instanceof RankedBaBo){
			final RankedBaBo r = (RankedBaBo)value;
			
			JLabel textlabel = new JLabel();
			
			textlabel.setText(r.getText());
			p.add(textlabel, BorderLayout.WEST);
			final boolean b = isSelected;
			JPanel imgp = new JPanel(){
				
				public void paint(Graphics g) {
					Image i = null;
					if(b){
						i = r.getImageNoNr();
					}else{
						i = r.getImage();
					}
					Dimension d = calcSize();
					i = BaBoPanel.createResizedCopy(i, d.width, d.height, true);
					g.drawImage(i, 0, 0, this);
				}
				public Dimension getPreferredSize() {
					return calcSize();
				}
				private Dimension calcSize() {
					float width = r.getDims().width;
					float height = r.getDims().height;
					if( width > cvMaxPicWidth || height > cvMaxPicHeight){
						width = width > height ? cvMaxPicWidth : ((width * ((cvMaxPicHeight  * 100) / height)) / 100);
						height = height > width ? cvMaxPicHeight : ((height * ((cvMaxPicWidth  * 100) / width)) / 100);
					}
					return new Dimension((int)width, (int)height);
				}
				
			};
			p.add(imgp, BorderLayout.CENTER);
		}else{
			return new JLabel("FEHLER");
		}
		p.setBackground(l.getBackground());
		p.setForeground(l.getForeground());
		p.setBorder(l.getBorder());
		return p;
	}
}
