package BABO.ranking;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

import BABO.Clip;
import BABO.IDPoint;
import BABO.Tile;

public class RankedBaBo implements Comparable<RankedBaBo>{
	
	private static final int cvMissingClipMultipier = 3;
	
	private int ivRanking = -1;

	private BufferedImage ivImage = null;
	private BufferedImage ivImageWithoutNumbers = null;
	
	private ArrayList<Tile> ivTiles = null;
	
	private ArrayList<Clip> ivClips = null;
	
	private ArrayList<IDPoint> ivPoints = null;

	private int ivImageWidth = -1;
	private int ivImageHeight = -1;

	private int ivStat_Cuts = -1;
	private int ivStat_Breaks = -1;
	private int ivStat_missedClips = -1;
	private int ivStat_Clips = -1;
	private int ivStat_Width = -1;
	private int ivStat_Height = -1;
	
	private int ivStat_RankBeforeEvo = -1;

	private int minx = -1;
	private int miny = -1;
	
	
	public RankedBaBo(ArrayList<Tile> tiles, ArrayList<Clip> clips, ArrayList<IDPoint> pl, int missedclips){
		ivTiles = tiles;
		ivClips = clips;
		ivPoints = pl;
		ivStat_missedClips = missedclips;
		
		fillStats();
		calcRanking();
	}
	
	public RankedBaBo(ArrayList<Tile> tiles, ArrayList<Clip> clips, ArrayList<IDPoint> pl, int missedclips, int startRank) {
		this(tiles, clips, pl, missedclips);
		ivStat_RankBeforeEvo = startRank;
		
	}

	private void fillStats() {
		int xB = -1;
		int xL = -1;
		int yB = -1;
		int yL = -1;

		ivStat_Cuts = 0;
		ivStat_Breaks = 0;
		
		for (int i = 0; i < ivTiles.size(); i++) {
			Tile t = ivTiles.get(i);
			ivStat_Cuts += t.getSolidLines().size();
			ivStat_Breaks += t.getDottedLines().size();

			int xB_Tile = (int)t.getBigX();
			int xL_Tile = (int)t.getLowX();
			int yB_Tile = (int)t.getBigY();
			int yL_Tile = (int)t.getLowY();
			if(xB_Tile > xB)
				xB = xB_Tile;
			if(xL_Tile < xL || xL == -1)
				xL = xL_Tile;
			if(yB_Tile > yB)
				yB = yB_Tile;
			if(yL_Tile < yL || yL == -1)
				yL = yL_Tile;
		}
		
		ivStat_Width = (xB - xL) / Tile.cvWidth;
		ivStat_Height = (yB - yL) / Tile.cvWidth;
		
		minx = xL;
		miny = yL;
		
		ivStat_Clips = ivClips.size();
		
	}

	private void calcRanking() {
		ivRanking = 0;
		ivRanking += (ivStat_Cuts/10);
		ivRanking += (ivStat_Breaks/10);
		ivRanking += (ivStat_Clips/5);
		ivRanking += ivStat_Height;
		ivRanking += ivStat_Width;
		ivRanking += (ivStat_missedClips * cvMissingClipMultipier);
	}

	private void createImage() {
		
		ivImageWidth = (ivStat_Width * Tile.cvWidth) + 30;
		ivImageHeight = (ivStat_Height * Tile.cvWidth) + 30;

		ivImage = new BufferedImage(ivImageWidth, ivImageHeight, BufferedImage.TYPE_INT_RGB);
		ivImageWithoutNumbers = new BufferedImage(ivImageWidth, ivImageHeight, BufferedImage.TYPE_INT_RGB);
		

		Graphics2D g = (Graphics2D)ivImage.getGraphics();
		Graphics2D g2 = (Graphics2D)ivImageWithoutNumbers.getGraphics();

		g.setColor(Color.white);
		g.fillRect(0, 0, ivImageWidth, ivImageHeight);
		g2.setColor(Color.white);
		g2.fillRect(0, 0, ivImageWidth, ivImageHeight);

		g.setColor(Color.black);
		g2.setColor(Color.black);
		
		
		for (int i = 0; i < ivTiles.size(); i++) {
			ivTiles.get(i).translate(-(minx -15), -(miny -15));
			ivTiles.get(i).draw(g);
			ivTiles.get(i).draw(g2);
		}
		
		for (int i = 0; i < ivClips.size(); i++) {
			ivClips.get(i).translate(-(minx -15), -(miny -15));
			ivClips.get(i).draw(g);
			ivClips.get(i).draw(g2);
		}
		
		for (int i = 0; i < ivPoints.size(); i++) {
			ivPoints.get(i).translate(-(minx -15), -(miny -15));
			ivPoints.get(i).draw(g);
		}
	}

	public Dimension getDims(){
		if(ivImage == null)
			createImage();
		return new Dimension(ivImageWidth, ivImageHeight);
	}
	
	
	@Override
	public String toString() {
		return "Ranking: " + ivRanking;
	}
	
	public int compareTo(RankedBaBo o) {
		if(o.ivRanking < ivRanking)
			return 1;
		if(o.ivRanking > ivRanking)
			return -1;
		return 0;
	}

	public String getText() {
		String ret =  "<html>Ranking: " + ivRanking + "<br>"
//		+ "Breite: " + ivStat_Width + " (" + (ivStat_Width) + ")<br>"
//		+ "Hhe: " + ivStat_Height + " (" + (ivStat_Height) + ")<br>"
//		+ "Anzahl Laschen: " + ivStat_Clips + " (" + (ivStat_Clips/5) + ")<br>"
//		+ "Fehlende Laschen: " + ivStat_missedClips + " (" + (ivStat_missedClips * cvMissingClipMultipier) + ")<br>"
//		+ "Schnittkanten (ohne Lasche): " + ivStat_Cuts + " (" + (ivStat_Cuts/10) + ")<br>"
//		+ "Knickkanten: " + ivStat_Breaks + " (" + (ivStat_Breaks/10) + ")";
		

		+ "Width: " + ivStat_Width + " (" + (ivStat_Width) + ")<br>"
		+ "Height: " + ivStat_Height + " (" + (ivStat_Height) + ")<br>"
		+ "Number of glue flips: " + ivStat_Clips + " (" + (ivStat_Clips/5) + ")<br>"
		+ "Missing glue flips: " + ivStat_missedClips + " (" + (ivStat_missedClips * cvMissingClipMultipier) + ")<br>"
		+ "Cuts (without flip): " + ivStat_Cuts + " (" + (ivStat_Cuts/10) + ")<br>"
		+ "Breaks: " + ivStat_Breaks + " (" + (ivStat_Breaks/10) + ")";
		
		
		if(ivStat_RankBeforeEvo != -1)
			ret += "Start Ranking: " + ivStat_RankBeforeEvo + "<br>";
		ret += "</html>";
		return ret;
	}

	public int getRanking(){
		return ivRanking;
	}
	
	public BufferedImage getImage() {
		if(ivImage == null)
			createImage();
		return ivImage;
	}

	public BufferedImage getImageNoNr() {
		if(ivImageWithoutNumbers == null)
			createImage();
		return ivImageWithoutNumbers;
	}
	
	public void cleanup(){
		ivImage = null;
		ivImageWithoutNumbers = null;
		ivTiles = null;
		ivClips = null;
	}
	
	
}
