package BABO.ranking;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

import BABO.BaBoPanel;
import BABO.Tile;

public class Ranker extends JFrame{
	
	private BaBoPanel bbp = null;
	private ArrayList<RankedBaBo> ivRanked = new ArrayList<RankedBaBo>();
	
	private JList ivList = null; 
	private JButton pause = new JButton("pause");
	private JButton resume = new JButton("resume");

	public Ranker(ArrayList<Tile> tiles, Image ivIcon) {
		
		int fps = tiles.size() * tiles.size();
		fps = fps > 2000 ? 2000 : fps;
		
		bbp = new BaBoPanel(this, ((long) 1000.0 / fps) * 1000000L, tiles);
		setIconImage(ivIcon);
		setTitle("BaBo");
		init();
		
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setSize(1000,600);
		setLocationRelativeTo(null);
		setVisible(true);
		
		addWindowListener(new WindowAdapter(){
			public void windowClosing(WindowEvent e) {
				bbp.stopGame();
			}
		});
		
	}
	
	
	

	public void addRankedBaBo(RankedBaBo rankedBaBo) {
		ivRanked.add(rankedBaBo);
		initList(rankedBaBo);
	}
	
	public void init(){
		
		ivList = new JList();
		ivList.setCellRenderer(new RankListRenderer());
		
		ivList.addMouseListener(new MouseAdapter(){
			public void mousePressed(MouseEvent e) {
				popup(e);
			}
			public void mouseReleased(MouseEvent e) {
				popup(e);
			}

			public void popup(MouseEvent e) {
			if(e.isPopupTrigger()){
				JPopupMenu pop = new JPopupMenu();
				JMenuItem printitem = new JMenuItem("Print (+No)");
				JMenuItem printitem2 = new JMenuItem("Print (-No)");

				printitem.addActionListener(new PrintAction(true, (RankedBaBo)ivList.getSelectedValue()));
				printitem2.addActionListener(new PrintAction(false, (RankedBaBo)ivList.getSelectedValue()));

				pop.add(printitem);
				pop.add(printitem2);
				pop.show(ivList, e.getX(), e.getY());
			}
			}
		});
		
		
		
		
		initList(null);
		
		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));

		
		pause.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				bbp.pauseGame();
			}
		});
		
		resume.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				bbp.resumeGame();
			}
		});
		
		bbp.addMouseListener(new MouseAdapter(){
			@Override
			public void mouseClicked(MouseEvent e) {
				if(e.getClickCount() == 2){
					JDialog d = new JDialog();
					bbp.setZoom(-1, -1);
					d.add(bbp);
					d.pack();
					d.setLocationRelativeTo(null);
					d.setVisible(true);
				}
			}
		});
		
		bbp.setZoom(400,400);
		JPanel p2 = new JPanel(new BorderLayout());
		p2.setBorder(BorderFactory.createTitledBorder("Working Area"));
		p2.add(bbp, BorderLayout.CENTER);
		
		p2.setBackground(new JLabel().getBackground());
		p2.setPreferredSize(new Dimension(400,400));
		p2.setMaximumSize(new Dimension(400,400));
		p2.setMinimumSize(new Dimension(400,400));
		
		p.add(p2);
		
		p.add(pause);
		p.add(resume);
		p.add(new JPanel());
		
		setLayout(new BorderLayout());
		add(new JScrollPane(ivList), BorderLayout.CENTER);
		add(p, BorderLayout.EAST);
	}

	private void initList(RankedBaBo rankedBaBo) {
		Collections.sort(ivRanked);
		
		boolean different = false;
		
		if(ivRanked.size() <= 10)
			different = true;
		
		while(ivRanked.size() > 10){
			if(!ivRanked.get(ivRanked.size() - 1).equals(rankedBaBo)){
				different = true;
			}
			RankedBaBo bo = ivRanked.get(ivRanked.size() - 1);
			bo.cleanup();
			ivRanked.remove(bo);
		}
		
		if(different){
			DefaultListModel model = new DefaultListModel();
			for (int i = 0; i < ivRanked.size(); i++) {
				model.addElement(ivRanked.get(i));
			}
			ivList.setModel(model);
			ivList.revalidate();
		}
	}
	
	
	public static void createRanker(ArrayList<TransformGroup> cubes, Image icon){
		HashMap<String, Integer> nodeIDMap = new HashMap<String, Integer>();
		ArrayList<Tile> ret = new ArrayList<Tile>();
		
		int idCounter = 0;
		
		for (int i = 0; i < cubes.size(); i++) {
			TransformGroup trans = cubes.get(i);
			
			Transform3D tg = new Transform3D();
			trans.getTransform(tg); 
			Vector3d translation = new Vector3d();
			tg.get( translation );

			double x = translation.x;
			double y = translation.y;
			double z = translation.z;

			int X_plus = (int)(x + 1);
			int X_minus = (int)(x - 1);
			
			int Y_plus = (int)(y + 1);
			int Y_minus = (int)(y - 1);
			
			int Z_plus = (int)(z + 1);
			int Z_minus = (int)(z - 1);
			
			
			Point3d s1 = new Point3d(X_minus ,  Y_minus ,  Z_minus);
			Point3d s2 = new Point3d(X_minus ,  Y_minus ,  Z_plus);
			Point3d s3 = new Point3d(X_minus ,  Y_plus ,  Z_minus); 
			Point3d s4 = new Point3d(X_minus ,  Y_plus ,  Z_plus); 
			Point3d s5 = new Point3d(X_plus ,  Y_minus ,  Z_minus); 
			Point3d s6 = new Point3d(X_plus ,  Y_minus ,  Z_plus); 
			Point3d s7 = new Point3d(X_plus ,  Y_plus , Z_minus); 
			Point3d s8 = new Point3d(X_plus ,  Y_plus ,  Z_plus); 

			
			if(!nodeIDMap.containsKey(s1.toString()))
				nodeIDMap.put(s1.toString(), idCounter + 0);
			if(!nodeIDMap.containsKey(s2.toString()))
				nodeIDMap.put(s2.toString(), idCounter + 1);
			if(!nodeIDMap.containsKey(s3.toString()))
				nodeIDMap.put(s3.toString(), idCounter + 2);
			if(!nodeIDMap.containsKey(s4.toString()))
				nodeIDMap.put(s4.toString(), idCounter + 3);
			if(!nodeIDMap.containsKey(s5.toString()))
				nodeIDMap.put(s5.toString(), idCounter + 4);
			if(!nodeIDMap.containsKey(s6.toString()))
				nodeIDMap.put(s6.toString(), idCounter + 5);
			if(!nodeIDMap.containsKey(s7.toString()))
				nodeIDMap.put(s7.toString(), idCounter + 6);
			if(!nodeIDMap.containsKey(s8.toString()))
				nodeIDMap.put(s8.toString(), idCounter + 7);
			
			int s1id = nodeIDMap.get(s1.toString());
			int s2id = nodeIDMap.get(s2.toString());
			int s3id = nodeIDMap.get(s3.toString());
			int s4id = nodeIDMap.get(s4.toString());
			int s5id = nodeIDMap.get(s5.toString());
			int s6id = nodeIDMap.get(s6.toString());
			int s7id = nodeIDMap.get(s7.toString());
			int s8id = nodeIDMap.get(s8.toString());
			
			Tile checkTile = new Tile(idCounter + 0, s1id, s1, s2id, s2, s4id, s4, s3id, s3);
			boolean add = true;
			for (int j = 0; j < ret.size() && add; j++) {
				if(ret.get(j).hassameIDs(checkTile)){
					ret.remove(j);
					add = false;
				}
			}
			if(add)
				ret.add(checkTile);
			

			checkTile = new Tile(idCounter + 1, s1id, s1, s3id, s3, s7id, s7, s5id, s5);
			add = true;
			for (int j = 0; j < ret.size() && add; j++) {
				if(ret.get(j).hassameIDs(checkTile)){
					ret.remove(j);
					add = false;
				}
			}
			if(add)
				ret.add(checkTile);
			

			checkTile = new Tile(idCounter + 2, s1id, s1, s5id, s5, s6id, s6, s2id, s2);
			add = true;
			for (int j = 0; j < ret.size() && add; j++) {
				if(ret.get(j).hassameIDs(checkTile)){
					ret.remove(j);
					add = false;
				}
			}
			if(add)
				ret.add(checkTile);
			

			checkTile = new Tile(idCounter + 3, s6id, s6, s2id, s2, s4id, s4, s8id, s8);
			add = true;
			for (int j = 0; j < ret.size() && add; j++) {
				if(ret.get(j).hassameIDs(checkTile)){
					ret.remove(j);
					add = false;
				}
			}
			if(add)
				ret.add(checkTile);
			//

			checkTile = new Tile(idCounter + 4, s6id, s6, s8id, s8, s7id, s7, s5id, s5);
			add = true;
			for (int j = 0; j < ret.size() && add; j++) {
				if(ret.get(j).hassameIDs(checkTile)){
					ret.remove(j);
					add = false;
				}
			}
			if(add)
				ret.add(checkTile);
			

			checkTile = new Tile(idCounter + 5, s4id, s4, s3id, s3, s7id, s7, s8id, s8);
			add = true;
			for (int j = 0; j < ret.size() && add; j++) {
				if(ret.get(j).hassameIDs(checkTile)){
					ret.remove(j);
					add = false;
				}
			}
			if(add)
				ret.add(checkTile);
			
			
			idCounter += 8;
		}
		
		new Ranker(ret, icon);
		
		
		
	}
	
	
	
}
