import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;

import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Vector3d;

import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;

public class CubeKeyNavigatorBehavior extends KeyNavigatorBehavior {

	private WakeupCondition keyCriterion;
	private TransformGroup trans = null;
	private Welt ivWelt = null;

	public CubeKeyNavigatorBehavior(Welt welt, TransformGroup transcube1) {
		super(transcube1);
		trans = transcube1;
		ivWelt = welt;
	}

	public void initialize() {
		WakeupCriterion[] keyEvents = new WakeupCriterion[1];

		keyEvents[0] = new WakeupOnAWTEvent(KeyEvent.KEY_RELEASED);
//		keyEvents[1] = new WakeupOnAWTEvent(KeyEvent.KEY_PRESSED);
		keyCriterion = new WakeupOr(keyEvents);
		wakeupOn(keyCriterion);
	}

	public void processStimulus(Enumeration criteria) {
		if(ivWelt.isChoosenCube(trans)){
		
			WakeupCriterion genericEvt;
			while (criteria.hasMoreElements()) {
				genericEvt = (WakeupCriterion) criteria.nextElement();
				if (genericEvt instanceof WakeupOnAWTEvent) {
					
					AWTEvent[] events = ((WakeupOnAWTEvent)genericEvt).getAWTEvent();
					for (int i = events.length - 1; i >= 0; i--) {
						if (events[i] instanceof KeyEvent){
							processKeyEvent((KeyEvent)events[i]);
							wakeupOn(keyCriterion);
							return;
						}
					}
				}
			}
		}
		wakeupOn(keyCriterion);
	}

	private void processKeyEvent(KeyEvent ke) {
		int keycode = ke.getKeyCode();

//		System.out.println("Keycode: " + keycode);
		
		
		double xplus = 0;
		double yplus = 0;
		double zplus = 0;
		
		
		if(keycode == KeyEvent.VK_RIGHT){
			xplus += 2;
		}else if(keycode == KeyEvent.VK_LEFT){
			xplus -= 2;
		}else if(keycode == KeyEvent.VK_UP){
			yplus += 2;
		}else if(keycode == KeyEvent.VK_DOWN){
			yplus -= 2;
		}else if(keycode == KeyEvent.VK_PAGE_UP){
			zplus += 2;
		}else if(keycode == KeyEvent.VK_PAGE_DOWN){
			zplus -= 2;
		}else{
			return;
		}

		Transform3D tg = new Transform3D();
		trans.getTransform(tg); 
		Vector3d translation = new Vector3d();
		tg.get( translation );

		//TODO Grenzen feststellen
		xplus = translation.x + xplus < 1 ? 1 : translation.x + xplus;
		yplus = translation.y + yplus < 1 ? 1 : translation.y + yplus;
		zplus = translation.z + zplus < 1 ? 1 : translation.z + zplus;
		
		Transform3D transformcam = new Transform3D();
		transformcam.setTranslation(new Vector3d(xplus, yplus, zplus));
		
		trans.setTransform(transformcam);
		
	}

}
