import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.TransformGroup;

import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.behaviors.PickMouseBehavior;


public class CubePickingBehavior extends PickMouseBehavior{
	
	private Welt ivWelt = null;
	
	public CubePickingBehavior(Welt w, Canvas3D can, BranchGroup bg, Bounds bounds) {
		super(can, bg, bounds);
		setSchedulingBounds(bounds);
		ivWelt = w;
	}

	@Override
	public void updateScene(int x, int y) {
//		System.out.println("update");
		TransformGroup picktg = null;
		pickCanvas.setShapeLocation(x, y);
		PickResult[] res = pickCanvas.pickAllSorted();
		
		if(res != null && res.length > 0){
			picktg = (TransformGroup)res[res.length - 1].getNode(PickResult.TRANSFORM_GROUP);
		}
		
		if(picktg != null){
			ivWelt.setChoosen((TransformGroup)picktg);
		}else{
			ivWelt.setChoosen(null);
		}
		
	}

}
