import javax.media.j3d.BranchGroup;
import javax.media.j3d.Locale;
import javax.media.j3d.VirtualUniverse;

import com.sun.j3d.utils.universe.ViewingPlatform;

class InnerModel {
	private VirtualUniverse universe = null;
	private Locale locale = null;
	private BranchGroup scene = null;

	public InnerModel() {
		universe = new VirtualUniverse();
		locale = new Locale(universe);
	}

	public void setScene(BranchGroup scene) {
		if (this.scene != null)
			locale.removeBranchGraph(this.scene);

		this.scene = scene;
		locale.addBranchGraph(this.scene);
	}

	public void addViewingPlatform(ViewingPlatform viewingPlatform) {
		locale.addBranchGraph(viewingPlatform);
	}
}