import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

import javax.imageio.ImageIO;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Group;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.View;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

import BABO.ranking.Ranker;

import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;

public class Welt extends JFrame {
	private static final long serialVersionUID = -70169558863685996L;

	static final int GEN_NORMALS = Primitive.GENERATE_NORMALS;

	static final int cvX_Axis = 0;
	static final int cvY_Axis = 1;
	static final int cvZ_Axis = 2;

	private Image ivIcon = null;

	private Canvas3D canvas3d = null;
	private SimpleUniverse universe = null;
	private ViewingPlatform ivCamera = null;
	private ArrayList<TransformGroup> ivCubeTGList = new ArrayList<TransformGroup>();

	private BranchGroup ivRootBG = new BranchGroup();
	private TransformGroup ivRootTG = new TransformGroup();

	private ArrayList<TransformGroup> ivChoosenCubes = new ArrayList<TransformGroup>();

	InnerModel model = new InnerModel();

	InnerView mainView = new InnerView(true);
	InnerView sideView_Top = new InnerView(false);
	InnerView sideView_Side = new InnerView(false);
	InnerView sideView_Ground = new InnerView(false);

	public Welt() {
		super();

		this.setTitle("Kubus");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setSize(1000, 800);

		try {
			URL url = getClass().getResource("Icon_64.png");
			if(url != null){
				ivIcon = ImageIO.read(url);
			}else{
				ivIcon = Toolkit.getDefaultToolkit().getImage("Icon_64.png");
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		setIconImage(ivIcon);

		init();
		pack();
		setVisible(true);
	}

	private void init() {

		setViewingPlatforms(sideView_Top, sideView_Side, sideView_Ground);

		canvas3d = mainView.getCanvas3D();
		mainView.getViewer().getView().setBackClipDistance(1000);
		ivRootBG = createSceneGraph();

		mainView.setModel(model);
		sideView_Top.setModel(model);
		sideView_Side.setModel(model);
		sideView_Ground.setModel(model);

		model.setScene(ivRootBG);

		// BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0,
		// 0.0), 100.0);
		// OrbitBehavior orbit = new OrbitBehavior(mainView.getCanvas3D(),
		// OrbitBehavior.REVERSE_ALL);
		// orbit.setSchedulingBounds(bounds);
		// mainView.getViewingPlatform().setViewPlatformBehavior(orbit);

		// // rotieren mit der linken Maustaste
		// MouseRotate behavior = new MouseRotate(ivRootTG);
		// behavior.setSchedulingBounds(worldBounds);
		// ivRootTG.addChild(behavior);
		//
		// // zoomen mit der mitleren Maustaste
		// MouseZoom mouseBeh2 = new MouseZoom(ivRootTG);
		// mouseBeh2.setSchedulingBounds(worldBounds);
		// ivRootTG.addChild(mouseBeh2);

		// verschieben mit der rechten Maustaste
		// MouseTranslate mouseBeh3 = new
		// MouseTranslate(sideView_Top.getViewingPlatform().getViewPlatformTransform());
		// mouseBeh3.setSchedulingBounds(bounds);
		// sideView_Top.getViewingPlatform().getViewPlatformTransform().addChild(mouseBeh3);
		//		

		int w = this.getSize().width;// - 200;
		int h = this.getSize().height;

		int sideviewwidth = 200;

		this.setLayout(new BorderLayout());

		JLayeredPane WVLayer = new JLayeredPane();
		JViewport WVPort = new JViewport();

		WVLayer.setLayout(null);
		WVLayer.setLocation(0, 0);
		WVLayer.setPreferredSize(new Dimension(w, h));
		// WVLayer.setBackground(Color.magenta);

		Canvas3D mc = mainView.getCanvas3D();
		mc.setLocation(0, 0);
		mc.setSize(w, h);
		WVLayer.add(mc);
		WVLayer.setLayer(mc, JLayeredPane.DEFAULT_LAYER + 1);

		Canvas3D scg = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
		scg.setLocation(w - 220, 50);
		scg.setSize(210, 210);
		WVLayer.add(scg);
		WVLayer.setLayer(scg, JLayeredPane.DEFAULT_LAYER + 2);

		Canvas3D scg2 = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
		scg2.setLocation(w - 220, 255);
		scg2.setSize(210, 210);
		WVLayer.add(scg2);
		WVLayer.setLayer(scg2, JLayeredPane.DEFAULT_LAYER + 2);

		Canvas3D scg3 = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
		scg3.setLocation(w - 220, 460);
		scg3.setSize(210, 210);
		WVLayer.add(scg3);
		WVLayer.setLayer(scg3, JLayeredPane.DEFAULT_LAYER + 2);

		Canvas3D scg4 = getButtonCanvas();
		;
		scg4.setLocation(10, h - 120);
		scg4.setSize(85, 85);
		WVLayer.add(scg4);
		WVLayer.setLayer(scg4, JLayeredPane.DEFAULT_LAYER + 2);

		Canvas3D sc = sideView_Top.getCanvas3D();
		sc.setLocation(w - 215, 55);
		sc.setSize(sideviewwidth, sideviewwidth);
		WVLayer.add(sc);
		WVLayer.setLayer(sc, JLayeredPane.DEFAULT_LAYER + 3);

		Canvas3D sc2 = sideView_Side.getCanvas3D();
		sc2.setLocation(w - 215, 260);
		sc2.setSize(sideviewwidth, sideviewwidth);
		WVLayer.add(sc2);
		WVLayer.setLayer(sc2, JLayeredPane.DEFAULT_LAYER + 3);

		Canvas3D sc3 = sideView_Ground.getCanvas3D();
		sc3.setLocation(w - 215, 465);
		sc3.setSize(sideviewwidth, sideviewwidth);
		WVLayer.add(sc3);
		WVLayer.setLayer(sc3, JLayeredPane.DEFAULT_LAYER + 3);

		this.add(WVLayer, BorderLayout.CENTER);
//		this.add(getSidePanel(), BorderLayout.EAST);

		ivCamera = mainView.getViewingPlatform();

		mainView.getCanvas3D().addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				if (e.getKeyCode() == KeyEvent.VK_ENTER) {
					ivRootTG.addChild(addCube(1, 1, 1));
				} else if (e.getKeyCode() == KeyEvent.VK_NUMPAD3) {
					changeCamPos(1, 0, 0, true);
				} else if (e.getKeyCode() == KeyEvent.VK_NUMPAD2) {
					changeCamPos(-1, 0, 0, true);
				} else if (e.getKeyCode() == KeyEvent.VK_NUMPAD7) {
					changeCamPos(0, 1, 0, true);
				} else if (e.getKeyCode() == KeyEvent.VK_NUMPAD4) {
					changeCamPos(0, -1, 0, true);
				} else if (e.getKeyCode() == KeyEvent.VK_NUMPAD1) {
					changeCamPos(0, 0, 1, true);
				} else if (e.getKeyCode() == KeyEvent.VK_NUMPAD5) {
					changeCamPos(0, 0, -1, true);
				} else if (e.getKeyCode() == KeyEvent.VK_BACK_SPACE) {
					deleteChoosenCubes();
				} else if (e.getKeyCode() == KeyEvent.VK_2) {
					Ranker.createRanker(ivCubeTGList, ivIcon);
				} else if (e.getKeyCode() == KeyEvent.VK_3) {
					zoomParallel(0, 0.1);
				} else if (e.getKeyCode() == KeyEvent.VK_4) {
					zoomParallel(0, -0.1);
				} else if (e.getKeyCode() == KeyEvent.VK_5) {
					zoomParallel(1, 0.1);
				} else if (e.getKeyCode() == KeyEvent.VK_6) {
					zoomParallel(1, -0.1);
				} else if (e.getKeyCode() == KeyEvent.VK_7) {
					zoomParallel(2, 0.1);
				} else if (e.getKeyCode() == KeyEvent.VK_8) {
					zoomParallel(2, -0.1);
				}
			}
		});

		changeCamPos(5, 5, 30, false);

		createMenu();

	}

	private void createMenu() {
		JPopupMenu.setDefaultLightWeightPopupEnabled(false);// heavyweight, to
																												// overlap the canvas

		JMenuBar bar = new JMenuBar();
		JMenu dat = new JMenu("Datei");
		JMenuItem loadItem = new JMenuItem("load");
		JMenuItem saveItem = new JMenuItem("save");

		loadItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser fc = new JFileChooser(new File("./"));
				fc.setMultiSelectionEnabled(false);
				fc.showOpenDialog(Welt.this);
				File f = fc.getSelectedFile();
				if (f.getName().endsWith(".kub")) {
					deleteAllCubes();
					Properties p = new Properties();

					FileInputStream fstream = null;
					try {
						fstream = new FileInputStream(f);
					} catch (FileNotFoundException ex) {// TODO exceptionhandling
					}
					p = new Properties();
					if (fstream != null) {
						try {
							p.load(fstream);
						} catch (IOException ex) {
						}
					}
					Iterator i = p.keySet().iterator();
					while (i.hasNext()) {
						String s = i.next().toString();
						StringTokenizer tok = new StringTokenizer(p.getProperty(s), ";");
						while (tok.hasMoreElements()) {
							int x = Integer.parseInt(tok.nextElement().toString());
							int y = Integer.parseInt(tok.nextElement().toString());
							int z = Integer.parseInt(tok.nextElement().toString());
							ivRootTG.addChild(addCube(x, y, z));
						}
					}
				}
			}
		});

		saveItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser fc = new JFileChooser(new File("./"));
				fc.setMultiSelectionEnabled(false);
				fc.showSaveDialog(Welt.this);
				File f = fc.getSelectedFile();
				if (!f.getName().endsWith(".kub")) {
					f = new File(f.getAbsolutePath() + ".kub");
				}

				Properties p = new Properties();

				int idcounter = 0;
				for (int j = 0; j < ivCubeTGList.size(); j++) {
					idcounter++;
					TransformGroup trans = ivCubeTGList.get(j);

					Transform3D tg = new Transform3D();
					trans.getTransform(tg);
					Vector3d translation = new Vector3d();
					tg.get(translation);
					p.put(idcounter + "", (int) translation.x + ";" + (int) translation.y + ";" + (int) translation.z);
				}

				FileOutputStream fos = null;
				try {
					fos = new FileOutputStream(f);
				} catch (FileNotFoundException ex) {// TODO exceptionhandling
				}
				try {
					p.store(fos, "");
				} catch (IOException ex) {
				}
			}
		});

		dat.add(loadItem);
		dat.add(saveItem);
		bar.add(dat);
		setJMenuBar(bar);
	}

//	private Component getSidePanel() {
//		JPanel p = new JPanel();
//		p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
//
//		p.add(new JPanel());
//
//		p.add(new JPanel() {
//			BufferedImage i = null;
//			{
//				try {
//					i = ImageIO.read(new File("./NavBowl.png"));
//				} catch (IOException e) {
//					e.printStackTrace();
//				}
//			}
//
//			@Override
//			public Dimension getPreferredSize() {
//				return new Dimension(i.getWidth(), i.getHeight());
//			}
//
//			@Override
//			public Dimension getMaximumSize() {
//				return new Dimension(i.getWidth(), i.getHeight());
//			}
//
//			@Override
//			public void paint(Graphics g) {
//				super.paint(g);
//				g.drawImage(i, 0, 0, this);
//			}
//		});
//
//		JSlider slide_CamMove_X = new JSlider(-40, 40, 0);
//		JSlider slide_CamMove_Y = new JSlider(-40, 40, 0);
//		JSlider slide_CamMove_Z = new JSlider(-40, 40, 0);
//
//		slide_CamMove_X.addChangeListener(new ChangeListener() {
//			public void stateChanged(ChangeEvent arg0) {
//				int newval = (((JSlider) arg0.getSource()).getValue());
//				setCamPos(cvX_Axis, newval);
//			}
//
//		});
//		slide_CamMove_Y.addChangeListener(new ChangeListener() {
//			public void stateChanged(ChangeEvent arg0) {
//				int newval = (((JSlider) arg0.getSource()).getValue());
//				setCamPos(cvY_Axis, newval);
//			}
//		});
//		slide_CamMove_Z.addChangeListener(new ChangeListener() {
//			public void stateChanged(ChangeEvent arg0) {
//				int newval = (((JSlider) arg0.getSource()).getValue());
//				setCamPos(cvZ_Axis, newval);
//			}
//		});
//
//		JSlider slide_CamRotation_X = new JSlider(-90, 90, 0);
//		JSlider slide_CamRotation_Y = new JSlider(-90, 90, 0);
//		JSlider slide_CamRotation_Z = new JSlider(-90, 90, 0);
//
//		slide_CamRotation_X.addChangeListener(new ChangeListener() {
//			public void stateChanged(ChangeEvent arg0) {
//				int newval = (((JSlider) arg0.getSource()).getValue());
//				setRotation(cvX_Axis, newval);
//			}
//
//		});
//		slide_CamRotation_Y.addChangeListener(new ChangeListener() {
//			public void stateChanged(ChangeEvent arg0) {
//				int newval = (((JSlider) arg0.getSource()).getValue());
//				setRotation(cvY_Axis, newval);
//			}
//		});
//		slide_CamRotation_Z.addChangeListener(new ChangeListener() {
//			public void stateChanged(ChangeEvent arg0) {
//				int newval = (((JSlider) arg0.getSource()).getValue());
//				setRotation(cvZ_Axis, newval);
//			}
//		});
//
//		p.add(new JLabel("Position"));
//		p.add(new JLabel("X-Achse"));
//		p.add(slide_CamMove_X);
//		p.add(new JLabel("Y-Achse"));
//		p.add(slide_CamMove_Y);
//		p.add(new JLabel("Z-Achse"));
//		p.add(slide_CamMove_Z);
//
//		p.add(new JLabel("Rotation"));
//		p.add(new JLabel("X-Achse"));
//		p.add(slide_CamRotation_X);
//		p.add(new JLabel("Y-Achse"));
//		p.add(slide_CamRotation_Y);
//		p.add(new JLabel("Z-Achse"));
//		p.add(slide_CamRotation_Z);
//
//		return p;
//	}

	private void setCamPos(int axis, int newval) {
		TransformGroup viewtg = ivCamera.getViewPlatformTransform();

		Transform3D tg = new Transform3D();
		viewtg.getTransform(tg);
		Vector3d translation = new Vector3d();
		tg.get(translation);
		Quat4d rotation = new Quat4d();
		tg.get(rotation);

		Transform3D transformcam = new Transform3D();
		transformcam.setTranslation(translation);

		if (axis == cvX_Axis)
			translation.setX(newval);
		if (axis == cvY_Axis)
			translation.setY(newval);
		if (axis == cvZ_Axis)
			translation.setZ(newval);

//		System.out.println(newval);

		// rotation.x = 0 ; //TODO
		// rotation.y = 0 ;
		// rotation.z = 0 ;
		//		
		//		
		//		
		// rotation.normalize();

		transformcam.setRotation(rotation);
		transformcam.setTranslation(translation);
		viewtg.setTransform(transformcam);
	}

	private void setRotation(int axis, int newval) {

		TransformGroup viewtg = ivCamera.getViewPlatformTransform();

		Transform3D tg = new Transform3D();
		viewtg.getTransform(tg);
		Vector3d translation = new Vector3d();
		tg.get(translation);
		Quat4d rotation = new Quat4d();
		tg.get(rotation);

		Transform3D transformcam = new Transform3D();
		transformcam.setTranslation(translation);

		if (axis == cvX_Axis)
			rotation.setX(Math.toRadians(newval));
		if (axis == cvY_Axis)
			rotation.setY(Math.toRadians(newval));
		if (axis == cvZ_Axis)
			rotation.setZ(Math.toRadians(newval));

		rotation.normalize();
		transformcam.setRotation(rotation);

		viewtg.setTransform(transformcam);
	}

	private Canvas3D getButtonCanvas() {

		Canvas3D scg4 = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
		SimpleUniverse u = new SimpleUniverse(scg4);
		BranchGroup bg = new BranchGroup();

		bg.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
		bg.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
		bg.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
		bg.setCapability(BranchGroup.ALLOW_DETACH);

		TransformGroup tg = new TransformGroup();
		Font3D font3D = new Font3D(new Font("Helvetica", Font.PLAIN, 1), new FontExtrusion());
		Text3D textGeom = new Text3D(font3D, new String("GEN"));
		textGeom.setAlignment(Text3D.ALIGN_CENTER);
		Shape3D textShape = new Shape3D();
		textShape.setGeometry(textGeom);
		tg.addChild(textShape);
		bg.addChild(tg);
		BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0);
		Background back = new Background(new Color3f(0.9f, 0.9f, 0.9f));
		back.setApplicationBounds(bounds);
		bg.addChild(back);
		OrbitBehavior orbit = new OrbitBehavior(scg4, OrbitBehavior.REVERSE_ALL);
		orbit.setSchedulingBounds(bounds);
		u.getViewingPlatform().setViewPlatformBehavior(orbit);
		u.addBranchGraph(bg);

		Transform3D transformcam = new Transform3D();
		transformcam.rotZ(0.5);
		transformcam.setTranslation(new Vector3d(0, 0.3, 3.5));
		u.getViewingPlatform().setNominalViewingTransform();
		u.getViewingPlatform().getViewPlatformTransform().setTransform(transformcam);

		scg4.addMouseListener(new MouseAdapter() {
			public void mouseReleased(MouseEvent e) {
				Ranker.createRanker(ivCubeTGList, ivIcon);
			}
		});

		return scg4;

	}

	private void zoomParallel(int side, double zoom) {
		Transform3D tg = new Transform3D();

		if (side == 0)
			sideView_Top.getViewingPlatform().getViewPlatformTransform().getTransform(tg);
		else if (side == 1)
			sideView_Side.getViewingPlatform().getViewPlatformTransform().getTransform(tg);
		else if (side == 2)
			sideView_Ground.getViewingPlatform().getViewPlatformTransform().getTransform(tg);

		double d = tg.getScale();
		Vector3d translation = new Vector3d();
		tg.get(translation);
		Quat4d rotation = new Quat4d();// TODO
		tg.get(rotation);

		Transform3D transformcam = new Transform3D();
		transformcam.setScale(d + zoom <= 0 ? 0.1 : d + zoom > 11.2 ? 11.2 : d + zoom);
		transformcam.setTranslation(translation);
		transformcam.setRotation(rotation);

		if (side == 0)
			sideView_Top.getViewingPlatform().getViewPlatformTransform().setTransform(transformcam);
		else if (side == 1)
			sideView_Side.getViewingPlatform().getViewPlatformTransform().setTransform(transformcam);
		else if (side == 2)
			sideView_Ground.getViewingPlatform().getViewPlatformTransform().setTransform(transformcam);

//		System.out.println(transformcam.getScale());

	}

	public void setViewingPlatforms(InnerView view2, InnerView view3, InnerView view4) {
		// Top
		ViewingPlatform viewingPlatform2 = view2.getViewingPlatform();
		view2.getCanvas3D().getView().setProjectionPolicy(View.PARALLEL_PROJECTION);
		Transform3D t3d = new Transform3D();
		viewingPlatform2.getViewPlatformTransform().getTransform(t3d);
		t3d.rotX(Math.toRadians(90.0));
		t3d.setTranslation(new Vector3d(10.0, -5.0, 10.0));
		t3d.setScale(11.0);
		viewingPlatform2.getViewPlatformTransform().setTransform(t3d);

		// side
		ViewingPlatform viewingPlatform3 = view3.getViewingPlatform();
		view3.getCanvas3D().getView().setProjectionPolicy(View.PARALLEL_PROJECTION);
		t3d = new Transform3D();
		viewingPlatform3.getViewPlatformTransform().getTransform(t3d);
		t3d.rotY(Math.toRadians(270.0));
		t3d.setTranslation(new Vector3d(-5.0, 10.0, 10.0));
		t3d.setScale(11.0);

		viewingPlatform3.getViewPlatformTransform().setTransform(t3d);

		// ground
		ViewingPlatform viewingPlatform4 = view4.getViewingPlatform();
		view4.getCanvas3D().getView().setProjectionPolicy(View.PARALLEL_PROJECTION);
		t3d = new Transform3D();
		viewingPlatform4.getViewPlatformTransform().getTransform(t3d);
		t3d.rotY(Math.toRadians(180.0));
		t3d.setTranslation(new Vector3d(10.0, 10.0, -5.0));
		t3d.setScale(11.0);
		viewingPlatform4.getViewPlatformTransform().setTransform(t3d);
	}

	private BranchGroup createSceneGraph() {
		BranchGroup root = new BranchGroup();

		ivRootTG = new TransformGroup();

		ivRootTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		ivRootTG.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		ivRootTG.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);

		ivRootTG.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
		ivRootTG.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
		ivRootTG.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
		ivRootTG.setCapability(BranchGroup.ALLOW_DETACH);

		ivRootTG.addChild(addLines());
		ivRootTG.addChild(addLight());
		ivRootTG.addChild(addCube(1, 1, 1));
		root.addChild(ivRootTG);

		BoundingSphere worldBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0);
		CubePickingBehavior pickbe = new CubePickingBehavior(this, canvas3d, root, worldBounds);
		root.addChild(pickbe);

		root.compile();

		return root;
	}

	private void changeCamPos(double xdif, double ydif, double zdif, boolean relative) {
		TransformGroup viewTG = ivCamera.getViewPlatformTransform();

		Transform3D tg = new Transform3D();
		viewTG.getTransform(tg);
		Vector3d translation = new Vector3d();
		tg.get(translation);
		Quat4d rotation = new Quat4d();// TODO
		tg.get(rotation);

		Transform3D transformcam = new Transform3D();
		if (relative)
			transformcam.setTranslation(new Vector3d(translation.x + xdif, translation.y + ydif, translation.z + zdif));
		else
			transformcam.setTranslation(new Vector3d(xdif, ydif, zdif));

		ivCamera.setNominalViewingTransform();
		viewTG.setTransform(transformcam);
	}

	private BranchGroup addLight() {
		BranchGroup branchgroup = new BranchGroup();
		AmbientLight lightA = new AmbientLight();
		lightA.setInfluencingBounds(new BoundingSphere());
		branchgroup.addChild(lightA);

		DirectionalLight lightD1 = new DirectionalLight();
		lightD1.setInfluencingBounds(new BoundingSphere());
		branchgroup.addChild(lightD1);
		return branchgroup;
	}

	private Group addLines() {
		Group lineGroup = new Group();

		Appearance app = new Appearance();
		ColoringAttributes ca = new ColoringAttributes(new Color3f(1.0f, 1.0f, 1.0f), ColoringAttributes.SHADE_FLAT);
		app.setColoringAttributes(ca);

		// X-Achse
		Point3f[] plaPtsx = new Point3f[2];
		plaPtsx[0] = new Point3f(0.0f, 0.0f, 0.0f);
		plaPtsx[1] = new Point3f(10.0f, 0.0f, 0.0f);
		LineArray plax = new LineArray(2, LineArray.COORDINATES);
		plax.setCoordinates(0, plaPtsx);
		Shape3D plShapex = new Shape3D(plax, app);
		lineGroup.addChild(plShapex);

		Font3D font3D = new Font3D(new Font("Arial", Font.PLAIN, 1), new FontExtrusion());
		Text3D textGeomX = new Text3D(font3D, new String("X"));
		textGeomX.setAlignment(Text3D.ALIGN_CENTER);
		Shape3D textShapeX = new Shape3D();
		textShapeX.setGeometry(textGeomX);

		TransformGroup tgX = new TransformGroup();
		tgX.addChild(textShapeX);
		Transform3D transX = new Transform3D();
		transX.setScale(0.5);
		transX.setTranslation(new Vector3f(10.0f, -0.5f, -0.5f));
		tgX.setTransform(transX);
		lineGroup.addChild(tgX);

		// Y-Achse
		Point3f[] plaPtsy = new Point3f[2];
		plaPtsy[0] = new Point3f(0.0f, 0.0f, 0.0f);
		plaPtsy[1] = new Point3f(0.0f, 10.0f, 0.0f);
		LineArray play = new LineArray(2, LineArray.COORDINATES);
		play.setCoordinates(0, plaPtsy);
		Shape3D plShapey = new Shape3D(play, app);
		lineGroup.addChild(plShapey);

		Text3D textGeomY = new Text3D(font3D, new String("Y"));
		textGeomY.setAlignment(Text3D.ALIGN_CENTER);
		Shape3D textShapeY = new Shape3D();
		textShapeY.setGeometry(textGeomY);

		TransformGroup tgY = new TransformGroup();
		tgY.addChild(textShapeY);
		Transform3D transY = new Transform3D();
		transY.setScale(0.5);
		transY.setTranslation(new Vector3f(-0.5f, 10.0f, -0.5f));
		tgY.setTransform(transY);
		lineGroup.addChild(tgY);

		// Z-Achse
		Point3f[] plaPtsz = new Point3f[2];
		plaPtsz[0] = new Point3f(0.0f, 0.0f, 0.0f);
		plaPtsz[1] = new Point3f(0.0f, 0.0f, 10.0f);
		LineArray plaz = new LineArray(2, LineArray.COORDINATES);
		plaz.setCoordinates(0, plaPtsz);
		Shape3D plShapez = new Shape3D(plaz, app);
		lineGroup.addChild(plShapez);

		Text3D textGeomZ = new Text3D(font3D, new String("Z"));
		textGeomZ.setAlignment(Text3D.ALIGN_CENTER);
		Shape3D textShapeZ = new Shape3D();
		textShapeZ.setGeometry(textGeomZ);

		TransformGroup tgZ = new TransformGroup();
		tgZ.addChild(textShapeZ);
		Transform3D transZ = new Transform3D();
		transZ.setScale(0.5);
		transZ.setTranslation(new Vector3f(-0.5f, -0.5f, 10.0f));
		tgZ.setTransform(transZ);
		lineGroup.addChild(tgZ);

		return lineGroup;
	}

	private BranchGroup addCube(double x, double y, double z) {

		BaBoBox box = new BaBoBox(this, 1, 1, 1, 1, new Appearance());

		setBoxMaterial(box, false);

		box.setCapability(Box.ENABLE_APPEARANCE_MODIFY);
		box.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		box.setCapability(Shape3D.ALLOW_APPEARANCE_OVERRIDE_WRITE);
		box.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
		box.setCapability(Shape3D.ALLOW_APPEARANCE_OVERRIDE_READ);

		int c = 0;
		while (box.getShape(c) != null) {
			box.getShape(c).setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
			box.getShape(c).setCapability(Shape3D.ALLOW_APPEARANCE_OVERRIDE_WRITE);
			c++;
		}

		Transform3D transform3d = new Transform3D();
		transform3d.setTranslation(new Vector3d(x, y, z));
		TransformGroup transcube1 = new TransformGroup(transform3d);
		transcube1.addChild(box);

		transcube1.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		transcube1.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		transcube1.setCapability(TransformGroup.ALLOW_PICKABLE_READ);
		transcube1.setCapability(TransformGroup.ALLOW_PICKABLE_WRITE);
		transcube1.setCapability(TransformGroup.ENABLE_PICK_REPORTING);
		transcube1.setPickable(true);

		BoundingSphere sph = new BoundingSphere();

		KeyNavigatorBehavior b = new CubeKeyNavigatorBehavior(this, transcube1);
		b.setSchedulingBounds(sph);
		b.setEnable(true);
		transcube1.addChild(b);

		ivCubeTGList.add(transcube1);

		transcube1.setUserData(box);

		BranchGroup bg = new BranchGroup();

		bg.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
		bg.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
		bg.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
		bg.setCapability(BranchGroup.ALLOW_DETACH);

		bg.addChild(transcube1);
		setChoosen(transcube1);
		return bg;
	}

	public boolean isChoosenCube(TransformGroup trans) {
		return ivChoosenCubes.contains(trans);
	}

	public void setChoosen(TransformGroup tg) {

		for (int i = 0; i < ivChoosenCubes.size(); i++) {
			setBoxMaterial((BaBoBox) ivChoosenCubes.get(i).getUserData(), false);
		}

		ivChoosenCubes = new ArrayList<TransformGroup>();
		if (tg != null) {
			ivChoosenCubes.add(tg);
			setBoxMaterial((BaBoBox) tg.getUserData(), true);
		}
	}

	private void deleteChoosenCubes() {
		for (int i = 0; i < ivChoosenCubes.size(); i++) {
			TransformGroup tg = ivChoosenCubes.get(i);
			ivRootTG.removeChild((BranchGroup) tg.getParent());
			ivCubeTGList.remove(tg);
		}
		ivChoosenCubes.clear();
	}

	private void deleteAllCubes() {
		for (int i = ivCubeTGList.size() - 1; i >= 0; i--) {
			TransformGroup tg = ivCubeTGList.get(i);
			ivRootTG.removeChild((BranchGroup) tg.getParent());
			ivCubeTGList.remove(tg);
		}
		ivChoosenCubes.clear();
	}

	private void setBoxMaterial(BaBoBox box, boolean choosen) {

		Material redMat = new Material(new Color3f(1.0f, 0.0f, 0.0f), new Color3f(1.0f, 0.0f, 0.0f), new Color3f(1.0f, 0.0f, 0.0f), new Color3f(1.0f, 0.0f, 0.0f), 0.5f);
		Material greenMat = new Material(new Color3f(0.0f, 1.0f, 0.0f), new Color3f(0.0f, 1.0f, 0.0f), new Color3f(0.0f, 1.0f, 0.0f), new Color3f(0.0f, 1.0f, 0.0f), 0.5f);
		Material blueMat = new Material(new Color3f(0.0f, 0.0f, 1.0f), new Color3f(0.0f, 0.0f, 1.0f), new Color3f(0.0f, 0.0f, 1.0f), new Color3f(0.0f, 0.0f, 1.0f), 0.5f);

		Appearance redApp = new Appearance();
		redApp.setMaterial(redMat);
		Appearance greenApp = new Appearance();
		greenApp.setMaterial(greenMat);
		Appearance blueApp = new Appearance();
		blueApp.setMaterial(blueMat);

		PolygonAttributes polyAttribs = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE, 5);
		redApp.setPolygonAttributes(polyAttribs);
		greenApp.setPolygonAttributes(polyAttribs);
		blueApp.setPolygonAttributes(polyAttribs);

		RenderingAttributes ra = new RenderingAttributes();
		ra.setDepthBufferEnable(true);
		ra.setDepthTestFunction(RenderingAttributes.LESS);
		ra.setAlphaTestFunction(RenderingAttributes.ALWAYS);
		blueApp.setRenderingAttributes(ra);

		if (choosen) {
			TransparencyAttributes transp_attr = new TransparencyAttributes(TransparencyAttributes.NICEST, 0.3f);
			redApp.setTransparencyAttributes(transp_attr);
			greenApp.setTransparencyAttributes(transp_attr);
			blueApp.setTransparencyAttributes(transp_attr);
		}

		int c = 0;
		while (box != null && box.getShape(c) != null) {
			if (c == 0 || c == 1)
				box.getShape(c).setAppearance(redApp);
			else if (c == 2 || c == 3)
				box.getShape(c).setAppearance(greenApp);
			else if (c == 4 || c == 5)
				box.getShape(c).setAppearance(blueApp);
			c++;
		}

	}
	
	public static void main(String args[]) {
		Welt beispiel = new Welt();
	}
	

}