/*
 Eye of Ionytrix v2
 
 Creates a rotating eye pattern (for certain values of eye) for a circular 8 LED array.
 
 The circuit:
 * LEDs connected from digital pins 5-8 & 9-12 to ground.
 
 Created Aug 2010
 By JeremyRuhland (Hailbop)
 
 Ionytrix (Io) belongs to FaroreNightclaw
 
 Really this is nearly identical to the blink tutorial:
 http://arduino.cc/en/Tutorial/Blink
 
 based on an original by H. Barragan for the Wiring i/o board
 
 This code is CC BY-SA (2010).
 
 Notice: It is useful to not hold me liable for any mental or physical alteration
         experienced as a result of staring into the eye of Ionytrix. @_@ 

         Resistance is futile, you will be assimilated. It will feel so nice.
 
*/

int ledPin1 =  5;    // LED connected to digital pin 5                 (*)ledPin1
int ledPin2 =  6;    // LED connected to digital pin 6
int ledPin3 =  7;    // LED connected to digital pin 7         (*)ledPin8   (*)ledPin2
int ledPin4 =  8;    // LED connected to digital pin 8
int ledPin5 =  9;    // LED connected to digital pin 9      (*)ledPin7           (*)ledPin3
int ledPin6 =  10;   // LED connected to digital pin 10
int ledPin7 =  11;   // LED connected to digital pin 11        (*)ledPin6   (*)ledPin4
int ledPin8 =  12;   // LED connected to digital pin 12
                     //                                                (*)ledPin5
// Set the pause time between changes in eye state (millsec):
int holdTime = 150;

void setup()   {                
// initialize the digital pins as outputs:
  pinMode(ledPin1, OUTPUT);     
  pinMode(ledPin2, OUTPUT);
  pinMode(ledPin3, OUTPUT);
  pinMode(ledPin4, OUTPUT);
  pinMode(ledPin5, OUTPUT);
  pinMode(ledPin6, OUTPUT);
  pinMode(ledPin7, OUTPUT);
  pinMode(ledPin8, OUTPUT);
}

void loop()     // eye blinking script, runs forever
{
  digitalWrite(ledPin1, HIGH);
  delay(holdTime);
  digitalWrite(ledPin1, LOW);
  digitalWrite(ledPin2, HIGH);
  delay(holdTime);
  digitalWrite(ledPin2, LOW);
  digitalWrite(ledPin3, HIGH);
  delay(holdTime);
  digitalWrite(ledPin3, LOW);
  digitalWrite(ledPin4, HIGH);
  delay(holdTime);
  digitalWrite(ledPin4, LOW);
  digitalWrite(ledPin5, HIGH);
  delay(holdTime);
  digitalWrite(ledPin5, LOW);
  digitalWrite(ledPin6, HIGH);
  delay(holdTime);
  digitalWrite(ledPin6, LOW);
  digitalWrite(ledPin7, HIGH);
  delay(holdTime);
  digitalWrite(ledPin7, LOW);
  digitalWrite(ledPin8, HIGH);
  delay(holdTime);
  digitalWrite(ledPin8, LOW);
}
