
pcb_width = 34.5;
pcb_length = 63.66;
pcb_height = 2;
slisse = 1;

pcb_bottom_margin = 2.5;
wall_width_thick = 3.5;
wall_width = wall_width_thick-slisse;
box_height = 10;

module box() {
  union() {
    cube([pcb_width + 2*wall_width, pcb_length + 2*wall_width, wall_width]);

    cube([wall_width_thick, pcb_length + 2*wall_width, box_height]);

    cube([pcb_width + 2*wall_width, wall_width_thick, box_height]);

    %translate([0, pcb_length+wall_width, 0])
      cube([pcb_width + 2*wall_width,wall_width,box_height]);

    translate([pcb_width + wall_width - slisse,0,0])
      cube([wall_width_thick, pcb_length + 2*wall_width, box_height]);
  }
}

module pcb() {
  translate([wall_width, wall_width, wall_width + pcb_bottom_margin])
    cube([pcb_width,pcb_length + wall_width + 0.1,pcb_height]);
}



module holes() {
  translate([wall_width + pcb_width/2, wall_width_thick + 0.1, pcb_width/2+wall_width])
    rotate(a=90,v=[1,0,0])
      cylinder(r=pcb_width/2, h=wall_width_thick + 0.2);

  translate([-0.1, wall_width + pcb_length/2, pcb_length/2 + wall_width])
    rotate(a=90,v=[0,1,0])
      cylinder(r=pcb_length/2, h=wall_width_thick + 0.2);

  translate([pcb_width + wall_width - slisse - 0.1, wall_width + pcb_length/2, pcb_length/2 + wall_width])
    rotate(a=90,v=[0,1,0])
      cylinder(r=pcb_length/2, h=wall_width_thick + 0.2);

 * translate([pcb_width/2 + wall_width, wall_width + pcb_length/2, -0.1])
    rotate(a=0,v=[0,1,0])
      cylinder(r=min(pcb_length,pcb_width)/2 - wall_width/2, h=wall_width_thick + 0.2);
   
  inner_margin = 8;
  translate([inner_margin +wall_width, inner_margin+wall_width, -0.1])
    cube([pcb_width-inner_margin*2,pcb_length -inner_margin*2,wall_width + 0.2]);
}

difference() {
  box();
  pcb();
  holes();
}

* color([1,0,0])
  translate([pcb_width/2 + wall_width, wall_width + pcb_length/2, -0.1])
    rotate(a=0,v=[0,1,0])
      cylinder(r=min(pcb_length,pcb_width)/2 - wall_width/2, h=wall_width_thick + 0.2);

