module zipperhandle(length, width, height, loopwidth, bevel) {
  difference() {
    union() {
      difference() {
        cube([length-width, width, height], center=true);
        translate([0,0,height-bevel]) cube([length-width, width-loopwidth*2, bevel], center=true);
        translate([0,0,-height+bevel]) cube([length-width, width-loopwidth*2, bevel], center=true);
      }
      difference() {
        translate([-(length-width)/2,0,-height/2])
          cylinder(h=height, r=width/2);
        cube([length-width, width, height], center=true);
        translate([-(length-width)/2,0,-height/2])
          cylinder(h=height, r=width/2-loopwidth);
      }
      translate([-(length-width)/2,0,-height/2+bevel/2])
        cylinder(h=height-bevel, r=width/2-loopwidth);
      translate([(length-width)/2,0,-height/2])
        cylinder(h=height, r=width/2);
    }
    translate([(length-width)/2,0,-height/2])
      cylinder(h=height, r=width/2-loopwidth);    
  }
}

//zipperhandle(40,10, 3, 1.5, 1);