// LABEL PEELER //
drum_dia = 17;
w = 39;
d = 80;
h = 83;
thickness_y = 5;

difference()
{
  ensemble();
  slot();
  translate([8,-thickness_y,52]) rotate([0,-20,0]) 
    cube([11,w,10]);
}
intersection()
{
  difference()
  {
    translate([drum_dia,w-thickness_y,40]) rotate([90,0,0]) 
      cylinder(r=drum_dia-2,h=w-thickness_y);
    translate([drum_dia,w-thickness_y,40]) rotate([90,0,0]) 
      cylinder(r=drum_dia-5,h=w);
  }
  body();
}
// add a guide
rotate([0,7,0]) translate([23,0,h-27]) 
  cube([d-30,w,1]);


module ensemble()
{
union()
{
  difference()
  {
  body();
  translate([drum_dia,w-thickness_y,40]) rotate([90,0,0]) 
    cylinder(r=drum_dia,h=w);
  
  cutout();
  }
  difference()
  {
intersection()
{
  body();
  translate([drum_dia,w,40]) rotate([90,0,0]) 
    cylinder(r=drum_dia+thickness_y-1,h=w);
 }
 translate([drum_dia,w-thickness_y,40]) rotate([90,0,0]) 
    cylinder(r=drum_dia,h=w-thickness_y+1);
  
  }
  foot(d,w,3);

}

}

module cutout()
{
 scale([0.9,1.2,0.9]) translate([thickness_y,-0.1,thickness_y])
  body();
}

module body()
{
intersection()
{
cube([d,w,h-20]);
rotate([0,15,0]) cube([d,w,h]);
}
}

module slot()
{
rotate([0,5,0]) translate([8,thickness_y,h-21]) cube([40,w-thickness_y*2,1]);
translate([w+30,thickness_y,h-36]) cube([30,w-thickness_y*2,6]);
}

module foot(l,w,h)
{
  translate([-1,0,0]) cube([l+3,w,h]);
}