// Printed parts for SphereBot
// Eberhard Rensch, http://pleasantsoftware.com/developer/3d
//
// I modified the original Libs.scad library. Else the rendering of teardrop objects takes
// forever (due to a bug in OpenScad, I guess).
// Therefore I recommend to use the Libs.scad library from http://www.thingiverse.com/thing:7656
// Copy the Libs.scad file in the same directory as this file.
//
// For reference and credit:
// Get the original Libs.scad by Randy Young here: http://www.thingiverse.com/thing:6021

include <Libs.scad>
libEcho=false;
displayMode=0; // 0=printer, 1=screen (resolution)

// Configurable Parameters
stepperMotorAxisRadius = 2.5; // Standard NEMA17 stepper motors have a 5mm axis
rodRadius = 3.5; // This is the radius of the rods, holding the x-axis plate
penRadius = 4.5; // This is the radius of the pens, you'd like to use
penAxleRadius = 1; // This is the radius of the axle holding the pen retainer
// End Configuration

module eggCup(axleRadius=3)
{
	translate([0,0,14]) difference() {
		cylinder(h=28, r=6, center=true);
		translate([0,0,-15+6]) cylinder(h=12, r=axleRadius, center=true);
		translate([0,0,22]) sphere(r=10);
	}
}

module penRetainer()
{
	translate([0,0,3.5]) union() {
		difference() {
			cube([10, 50, 7], center = true);
			translate([0,22,0]) cylinder(h=8, r=penRadius+2.5, center=true);
			translate([0,-23+penAxleRadius,0]) teardrop(penAxleRadius, 12); 
		}
		translate([0,22,0]) difference()
		{
			union() {
				tube(penRadius+2.5, 2.5, 7, true);
				translate([0, penRadius*2, 0]) cube([7, 8, 7], center = true);
			}
			translate([0, penRadius*2, 0]) union() {
				cube([3, 20, 8], center = true);
				teardrop(1.7, 10); 
			}
		}

	}
}

module xaxisarmbase()
{
	translate([0,0,2.5]) union() {
		difference() {
			translate([0, 0, 8.5]) cylinder(h = 12, r=8, center = true);
			translate([0, 0, 9]) cylinder(h = 13, r=stepperMotorAxisRadius, center = true);
		} 
		difference() { 
			cube([30, 40, 5], center = true);
			translate([0, -15, 0]) rotate([180,0,0]) hexBolt("M4",12);			
			translate([0, 15, 0]) rotate([180,0,0]) hexBolt("M4",12);
		}
	}
}

module xaxispress()
{
	translate([0,0,2.5])  difference() {
		union() {
			cube([30, 40, 5], center = true); 
			translate([0,0,4]) cube([10, 40, 4], center = true);
		}
		translate([0,-15,2]) cylinder(h=10, r=2, center=true);
		translate([0,15,2]) cylinder(h=10, r=2, center=true);
	}
}

module retainerBlock()
{
	translate([0,0,(rodRadius*2+3)/2]) difference() {
		cube([10, 20, rodRadius*2+3], center = true);
		translate([0,0,1.5]) rotate([0,90,0]) teardrop(rodRadius, 12, 0);
		translate([0,-7,0]) cylinder(h=rodRadius*2+4, r=1.5, center=true);
		translate([0,7,0]) cylinder(h=rodRadius*2+4, r=1.5, center=true);
	}
}

translate ([13,0,0]) xaxispress();
translate ([-20,0,0]) xaxisarmbase();
translate ([-30,35,0]) retainerBlock();
translate ([-10,35,0]) retainerBlock();
translate ([10,35,0]) retainerBlock();
translate ([30,35,0]) retainerBlock();
translate ([0,-30,0]) rotate([0,0,90]) penRetainer();
translate ([36,-10,0]) eggCup(stepperMotorAxisRadius);
translate ([36,10,0]) eggCup(3);