/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.ListBox;
import controlP5.Textlabel;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import processing.core.PApplet;
import processing.serial.Serial;

public class SphereBotSender
extends PApplet {
    Serial serial;
    ControlP5 controlP5;
    Button buttonChoose;
    Button buttonAgain;
    Button buttonAbort;
    ListBox commListbox;
    Textlabel txtlblWhichcom;
    Textlabel version;
    Textlabel statusline;
    boolean init_com = false;
    boolean sendData = false;
    int currentLineIndex = 0;
    String[] linesToSend;
    boolean waitForResponse = true;
    StringBuffer inBuffer = new StringBuffer();
    int green_ = this.color(30, 120, 30);
    int red_ = this.color(120, 30, 30);
    int bkgcolor = this.color(80, 80, 80);

    public void setup() {
        this.size(400, 300);
        this.smooth();
        this.frameRate(30.0f);
        this.controlP5 = new ControlP5((PApplet)this);
        this.commListbox = this.controlP5.addListBox("portComList", 5, 49, 110, 180);
        this.commListbox.captionLabel().set("PORT COM");
        this.commListbox.setColorBackground(this.red_);
        int n = 0;
        while (n < Serial.list().length) {
            this.commListbox.addItem(this.shortifyPortName(Serial.list()[n], 20), n);
            ++n;
        }
        this.txtlblWhichcom = this.controlP5.addTextlabel("txtlblWhichcom", "No Port Selected", 7, 28);
        this.version = this.controlP5.addTextlabel("version", "v0.1", 5, 285);
        this.statusline = this.controlP5.addTextlabel("statusline", "", 150, 70);
        this.buttonChoose = this.controlP5.addButton("SEND", 1.0f, 150, 39, 30, 19);
        this.buttonAgain = this.controlP5.addButton("AGAIN", 1.0f, 190, 39, 30, 19);
        this.buttonAbort = this.controlP5.addButton("ABORT", 1.0f, 230, 39, 30, 19);
        this.buttonChoose.setColorBackground(this.red_);
        this.buttonAgain.setColorBackground(this.red_);
        this.buttonAbort.setColorBackground(this.red_);
    }

    public void draw() {
        this.background(this.bkgcolor);
        if (this.sendData && this.linesToSend != null) {
            if (this.waitForResponse) {
                while (this.serial.available() > 0) {
                    char c = this.serial.readChar();
                    if (c == '\n') {
                        if (this.inBuffer.toString().startsWith("ok:")) {
                            this.waitForResponse = false;
                            ++this.currentLineIndex;
                        } else {
                            this.statusline.setValue(this.inBuffer.toString());
                            this.sendData = false;
                            this.buttonChoose.setColorBackground(this.green_);
                            this.buttonAgain.setColorBackground(this.green_);
                            this.buttonAbort.setColorBackground(this.red_);
                        }
                        this.inBuffer.setLength(0);
                        break;
                    }
                    this.inBuffer.append(c);
                }
            } else if (this.currentLineIndex < this.linesToSend.length) {
                String string = this.linesToSend[this.currentLineIndex];
                this.statusline.setValue("Line " + this.currentLineIndex + ": " + string);
                this.serial.write(string);
                this.serial.write(13);
                this.waitForResponse = true;
            } else {
                this.sendData = false;
                this.statusline.setValue("Send complete");
                this.buttonChoose.setColorBackground(this.green_);
                this.buttonAgain.setColorBackground(this.green_);
                this.buttonAbort.setColorBackground(this.red_);
            }
        }
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.isGroup() && controlEvent.name() == "portComList") {
            this.InitSerial(controlEvent.group().value());
        }
    }

    public void SEND() {
        if (this.init_com && !this.sendData) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().endsWith(".gcode");
                }

                public String getDescription() {
                    return "GCode Files";
                }
            });
            int n = jFileChooser.showOpenDialog((Component)((Object)this));
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.linesToSend = SphereBotSender.loadStrings((File)file);
                this.currentLineIndex = 0;
                this.waitForResponse = false;
                this.sendData = true;
                this.buttonChoose.setColorBackground(this.red_);
                this.buttonAgain.setColorBackground(this.red_);
                this.buttonAbort.setColorBackground(this.green_);
            }
        }
    }

    public void AGAIN() {
        if (this.init_com && this.linesToSend != null) {
            this.currentLineIndex = 0;
            this.waitForResponse = false;
            this.sendData = true;
            this.buttonChoose.setColorBackground(this.red_);
            this.buttonAgain.setColorBackground(this.red_);
            this.buttonAbort.setColorBackground(this.green_);
        }
    }

    public void ABORT() {
        if (this.init_com && this.sendData) {
            this.sendData = false;
            this.serial.write("M18");
            this.serial.write(13);
            this.statusline.setValue("Aborted");
            this.buttonChoose.setColorBackground(this.green_);
            this.buttonAgain.setColorBackground(this.green_);
            this.buttonAbort.setColorBackground(this.red_);
        }
    }

    public String shortifyPortName(String string, int n) {
        String string2 = string;
        if (string2.startsWith("/dev/")) {
            string2 = string2.substring(5);
        }
        if (string.length() > n) {
            string2 = String.valueOf(string2.substring(0, (n - 1) / 2)) + "~" + string2.substring(string2.length() - (n - (n - 1) / 2));
        }
        return string2;
    }

    public void InitSerial(float f) {
        String string = Serial.list()[PApplet.parseInt((float)f)];
        this.txtlblWhichcom.setValue("COM = " + this.shortifyPortName(string, 16));
        this.serial = new Serial((PApplet)this, string, 115200);
        this.init_com = true;
        this.buttonChoose.setColorBackground(this.green_);
        this.commListbox.setColorBackground(this.green_);
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "SphereBotSender"});
    }
}

