/*
 * Decompiled with CFR 0.152.
 */
package processing.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import processing.core.PApplet;

public class Serial
implements SerialPortEventListener {
    PApplet parent;
    Method serialEventMethod;
    public SerialPort port;
    public int rate;
    public int parity;
    public int databits;
    public int stopbits;
    public InputStream input;
    public OutputStream output;
    byte[] buffer = new byte[32768];
    int bufferIndex;
    int bufferLast;
    int bufferSize = 1;
    boolean bufferUntil;
    int bufferUntilByte;
    static String dname = "COM1";
    static int drate = 9600;
    static char dparity = (char)78;
    static int ddatabits = 8;
    static float dstopbits = 1.0f;

    public void setProperties(Properties props) {
        dname = props.getProperty("serial.port", dname);
        drate = Integer.parseInt(props.getProperty("serial.rate", "9600"));
        dparity = props.getProperty("serial.parity", "N").charAt(0);
        ddatabits = Integer.parseInt(props.getProperty("serial.databits", "8"));
        dstopbits = new Float(props.getProperty("serial.stopbits", "1")).floatValue();
    }

    public Serial(PApplet parent) {
        this(parent, dname, drate, dparity, ddatabits, dstopbits);
    }

    public Serial(PApplet parent, int irate) {
        this(parent, dname, irate, dparity, ddatabits, dstopbits);
    }

    public Serial(PApplet parent, String iname, int irate) {
        this(parent, iname, irate, dparity, ddatabits, dstopbits);
    }

    public Serial(PApplet parent, String iname) {
        this(parent, iname, drate, dparity, ddatabits, dstopbits);
    }

    public Serial(PApplet parent, String iname, int irate, char iparity, int idatabits, float istopbits) {
        this.parent = parent;
        this.rate = irate;
        this.parity = 0;
        if (iparity == 'E') {
            this.parity = 2;
        }
        if (iparity == 'O') {
            this.parity = 1;
        }
        this.databits = idatabits;
        this.stopbits = 1;
        if (istopbits == 1.5f) {
            this.stopbits = 3;
        }
        if (istopbits == 2.0f) {
            this.stopbits = 2;
        }
        try {
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != 1 || !portId.getName().equals(iname)) continue;
                this.port = (SerialPort)portId.open("serial madness", 2000);
                this.input = this.port.getInputStream();
                this.output = this.port.getOutputStream();
                this.port.setSerialPortParams(this.rate, this.databits, this.stopbits, this.parity);
                this.port.addEventListener((SerialPortEventListener)this);
                this.port.notifyOnDataAvailable(true);
            }
        }
        catch (Exception e) {
            Serial.errorMessage("<init>", e);
            this.port = null;
            this.input = null;
            this.output = null;
        }
        parent.registerDispose((Object)this);
        try {
            this.serialEventMethod = parent.getClass().getMethod("serialEvent", Serial.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        this.dispose();
    }

    public void dispose() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.input = null;
        this.output = null;
        try {
            if (this.port != null) {
                this.port.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.port = null;
    }

    public void setDTR(boolean state) {
        this.port.setDTR(state);
    }

    /*
     * Exception decompiling
     */
    public synchronized void serialEvent(SerialPortEvent serialEvent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void buffer(int count) {
        this.bufferUntil = false;
        this.bufferSize = count;
    }

    public void bufferUntil(int what) {
        this.bufferUntil = true;
        this.bufferUntilByte = what;
    }

    public int available() {
        return this.bufferLast - this.bufferIndex;
    }

    public void clear() {
        this.bufferLast = 0;
        this.bufferIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        if (this.bufferIndex == this.bufferLast) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int outgoing = this.buffer[this.bufferIndex++] & 0xFF;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return outgoing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int last() {
        if (this.bufferIndex == this.bufferLast) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            byte outgoing = this.buffer[this.bufferLast - 1];
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return outgoing;
        }
    }

    public char readChar() {
        if (this.bufferIndex == this.bufferLast) {
            return '\uffff';
        }
        return (char)this.read();
    }

    public char lastChar() {
        if (this.bufferIndex == this.bufferLast) {
            return '\uffff';
        }
        return (char)this.last();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int length = this.bufferLast - this.bufferIndex;
            byte[] outgoing = new byte[length];
            System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return outgoing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] outgoing) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int length = this.bufferLast - this.bufferIndex;
            if (length > outgoing.length) {
                length = outgoing.length;
            }
            System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
            this.bufferIndex += length;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytesUntil(int interesting) {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte what = (byte)interesting;
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int found;
            block8: {
                found = -1;
                int k = this.bufferIndex;
                while (k < this.bufferLast) {
                    if (this.buffer[k] == what) {
                        found = k;
                        break;
                    }
                    ++k;
                }
                if (found != -1) break block8;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            int length = found - this.bufferIndex + 1;
            byte[] outgoing = new byte[length];
            System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
            this.bufferIndex += length;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return outgoing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytesUntil(int interesting, byte[] outgoing) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte what = (byte)interesting;
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int length;
            block10: {
                int found;
                block9: {
                    found = -1;
                    int k = this.bufferIndex;
                    while (k < this.bufferLast) {
                        if (this.buffer[k] == what) {
                            found = k;
                            break;
                        }
                        ++k;
                    }
                    if (found != -1) break block9;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return 0;
                }
                length = found - this.bufferIndex + 1;
                if (length <= outgoing.length) break block10;
                System.err.println("readBytesUntil() byte buffer is too small for the " + length + " bytes up to and including char " + interesting);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return -1;
            }
            System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
            this.bufferIndex += length;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return length;
        }
    }

    public String readString() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        return new String(this.readBytes());
    }

    public String readStringUntil(int interesting) {
        byte[] b = this.readBytesUntil(interesting);
        if (b == null) {
            return null;
        }
        return new String(b);
    }

    public void write(int what) {
        try {
            this.output.write(what & 0xFF);
            this.output.flush();
        }
        catch (Exception e) {
            Serial.errorMessage("write", e);
        }
    }

    public void write(byte[] bytes) {
        try {
            this.output.write(bytes);
            this.output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(String what) {
        this.write(what.getBytes());
    }

    public static String[] list() {
        Vector<String> list = new Vector<String>();
        try {
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != 1) continue;
                String name = portId.getName();
                list.addElement(name);
            }
        }
        catch (UnsatisfiedLinkError e) {
            Serial.errorMessage("ports", e);
        }
        catch (Exception e) {
            Serial.errorMessage("ports", e);
        }
        Object[] outgoing = new String[list.size()];
        list.copyInto(outgoing);
        return outgoing;
    }

    public static void errorMessage(String where, Throwable e) {
        e.printStackTrace();
        throw new RuntimeException("Error inside Serial." + where + "()");
    }
}

