include <Spring.scad>

module torus(outerRadius, innerRadius)
{
  r=(outerRadius-innerRadius)/2;
  rotate_extrude() translate([innerRadius+r,0,0]) circle(r);	
}

module radius(radius,length,axis)
  {
  if(axis=="X")
    {
	rotate(90,[1,0,0]) rotate(90,[0,1,0])
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius, $fn=60);
            }
	}
  else if(axis=="Y")
    {
	rotate(270,[0,1,0]) rotate(270,[1,0,0])
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius, $fn=60);
            }
	}
  else
      {
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius, $fn=60);
            }
	  }
  }
  
module xsupport_bearing_build_support_framework(diameter,height,vanes)
  {
  union()
	{
	//Debug overall volume
    //%cylinder(r=(diameter/2),h=height);

	// 1.5mm base ring 2mm gap, 0.75mm thick
	difference()
      {	
      cylinder(r=(diameter-4)/2,h=height-0.75);
      translate([0,0,-0.1]) cylinder(r=(diameter-4-3)/2,h=height-0.55);
	  }
/*
	difference()
      {	
      cylinder(r=(diameter-1)/4,h=height-0.75);
      translate([0,0,-0.1]) cylinder(r=(diameter-6)/4,h=height-0.55);
	  }

*/
	  
    //cylinder(r=1.5,h=height-0.75);

	  
	for(i=[0:vanes])
	  {
	  //base, for some reason skeinforge will not print a disc
	  rotate((360*i)/vanes,[0,0,1]) translate([0,-1.7,0]) cube([(diameter-4)/2,3.4,1]);


	  //Vane 0.5mm
	  rotate((360*i)/vanes,[0,0,1]) translate([0,-0.25,0]) cube([(diameter-4)/2,0.5,height]);
      //Top triangle point
	  rotate((360*i)/vanes,[0,0,1]) translate([(diameter-4)/2-0.1,0,height]) rotate(-90,[1,0,0]) right_triangle(2.1,height-0.75,0.5);
	  }
	}
  }  
  
  
module gearbox_mounting_holes(depth)
 {
  translate([14,0,0])  cylinder(r=3/2,h=depth);
  translate([-14,0,0] )cylinder(r=3/2,h=depth);
  translate([0,14,0])  cylinder(r=3/2,h=depth);
  translate([0,-14,0]) cylinder(r=3/2,h=depth);
  }

module motor_outline()
  {
  //hub
  cylinder(r=22/2,h=2);
  //gearbox
  difference()
    {
    //cylindrical body
    translate([0,0,2]) cylinder(r=36/2,h=30);
    //Remove gearbox mount holes, 3mm dia on a 28mm circle
    gearbox_mounting_holes(20);
    }
  //stepper
  difference()
    {
    translate([0,0,2+30+39/2]) cube([42,42,39], center = true);
    difference()
      {
      cylinder(r=60/2,h=80);
      cylinder(r=54/2,h=80);
      }
    }
  //shaft
  translate([0,0,-18])   cylinder(r=4,h=18);
  }

module drive_gear()
  {
  difference()
    {
    cylinder(r=12.6/2,h=11);
    translate([0,0,11-7.5])  torus(20/2,10.5/2);
    }
  }

  module MK5_Interface_Plate()
  {
  difference()
    {
    //Blank Plexi, 5.2mm thinck
    cube([5.2,75,45.68]);
    //remove filament hole
    //the 20 is a guess, visually checked. The rest come from the MBI DWG
    translate([-0.1,75/2,20])  rotate(90,[0,1,0]) cylinder(r=3.95,h=5.4);

    //Remove the 4 main_body() mounting holes
    translate([-0.1,75/2 - 15 ,15.75])  rotate(90,[0,1,0]) cylinder(r=3/2,h=5.4);
    translate([-0.1,75/2 + 15 ,15.75])  rotate(90,[0,1,0]) cylinder(r=3/2,h=5.4);
    translate([-0.1,75/2 - 15 ,29.93])  rotate(90,[0,1,0]) cylinder(r=3/2,h=5.4);
    translate([-0.1,75/2 + 15 ,29.93])  rotate(90,[0,1,0]) cylinder(r=3/2,h=5.4);

    //Remove the 4 MK5 extruder mounting holes
    translate([-0.1,75/2 - 17.3727 ,9])  rotate(90,[0,1,0]) cylinder(r=3/2,h=5.4);
    translate([-0.1,75/2 + 17.3727 ,9])  rotate(90,[0,1,0]) cylinder(r=3/2,h=5.4);
    translate([-0.1,75/2 - 17.3727 ,36.68])  rotate(90,[0,1,0]) cylinder(r=3/2,h=5.4);
    translate([-0.1,75/2 + 17.3727 ,36.68])  rotate(90,[0,1,0]) cylinder(r=3/2,h=5.4);
    }

  //MK5 mounting bolt heads
  translate([5.2,75/2 - 17.3727 ,9])  rotate(90,[0,1,0]) cylinder(r=5.5/2,h=3);
  translate([5.2,75/2 + 17.3727 ,9])  rotate(90,[0,1,0]) cylinder(r=5.5/2,h=3);
  translate([5.2,75/2 - 17.3727 ,36.68])  rotate(90,[0,1,0]) cylinder(r=5.5/2,h=3);
  translate([5.2,75/2 + 17.3727 ,36.68])  rotate(90,[0,1,0]) cylinder(r=5.5/2,h=3);
  }

module support_bearing()
  {
  difference()
    {
    cylinder(r=22/2,h=7);
    translate([0,0,-0.05]) cylinder(r=8/2,h=7.1);
    }
  }

module idler_bearing()
  {
  difference()
    {
    //outer 17x6
    cylinder(r=17/2,h=6);
    //hole 6mm
    translate([0,0,-0.05]) cylinder(r=6/2,h=6.1);
    }
  }

module idler_wheel_bevel()
  {
  difference()
    {
    cylinder(h = 1.25, r = 17/2+7.2+0.05);
    translate([0,0,-0.05]) cylinder(h = 1.35, r1 = 17/2+7.2+0.2, r2 = 19/2);
    }
  }

//cool looking machinable wheel, not so good for printing :(
module idler_wheel()
  {
  difference()
    {
    //outside is diameter of bearing plus 7.2
    cylinder(r=17/2+7.2,h=6);
    //hole, diameter of bearing +0.1
    translate([0,0,-1]) cylinder(r=17/2+0.0,h=8);
    //Groove for filament
    translate([0,0,3])  torus(17/2+7.2-1.25+3,17/2+7.2-1.25);
     //top bevel
    translate([0,0,1.24]) rotate(180,[0,1,0]) idler_wheel_bevel(); 
    //bottom  bevel
    translate([0,0,6-1.24])  idler_wheel_bevel(); 
    }
  }

//Printable version :)
//Good to "paint" tire portion with thin super glue to bond fibers together
module idler_wheel_printable()
  {
  difference()
    {
    //outside is diameter of bearing plus 7.2
    cylinder(r=17/2+6.8,h=6);
    //hole, diameter of bearing +0.1
    translate([0,0,-1]) cylinder(r=17/2+0.0,h=8);
    //Groove for filament
    translate([0,0,3])  torus(17/2+7.2-1.25+3,17/2+7.2-1.25);
    }
  }

//Smaller Diameter Printable version :)
module smaller_idler_wheel_printable()
  {
  difference()
    {
    //outside is diameter of bearing plus 4
    cylinder(r=17/2+4,h=6);
    //hole, diameter of bearing +0.1
    translate([0,0,-1]) cylinder(r=17/2+0.0,h=8);
    //Groove for filament
    translate([0,0,3])  torus(17/2+4.4-1.25+3,17/2+4.4-1.25);
    }
  }

//=======================================================================================  
module idler_frame()
  {
  difference()
    {
	union()
	  {
      difference()
	    {
	    //Main idler frame
        translate([-14+2.37+0.32,-8.1,-6.5]) rotate(8.5,[0,0,1]) cube([41.65,12,19]);
		//Knock bump off below engagement divot, fillet added on later
        translate([-13.25,3.05,-6.6]) rotate(21,[0,0,1]) cube([7,7,19.2]);
		//Knock bump off above lever divot, fillet added on later
        translate([23,4.8,-6.6]) rotate(-8,[0,0,1]) cube([7,7,19.2]);
        //Knock bump off above rest for over-center lever
        translate([17.75,4.5,-6.6]) rotate(15.45+7+2,[0,0,1]) cube([7,10,19.2]);
		}
      //Fillet below engagement divot, for looks
      translate([-12,3.294,-6.5]) cylinder(r=2/2,h=19);
      //Fillet above lever divot, for looks
      translate([27.225,3.67,-6.5]) cylinder(r=3.6/2,h=19);
      //Add rest for over-center lever
      translate([11.64,1,-6.5]) rotate(15.45+7+2,[0,0,1]) cube([7,18,19]);
      translate([-4.7,4.4,-6.5]) rotate(-20,[0,0,1]) cube([12,16,19]);
      //Fillet
      translate([5.844,17.88,-6.5]) cylinder(r=5.3,h=19);
	  }
    //Remove hole for support shaft
    translate([0,0,-8]) cylinder(r=6/2,h=30);
    //Pivot egagement divot
    translate([-8.1,6,-6.6]) cylinder(r=7.5/2,h=19.2);
    //Lever egagement divot
    translate([21.7,6.1,-6.6]) cylinder(r=8.5/2,h=19.2);
	//remove upper left radius
    translate([29.9,-1.95,-6.6]) rotate(90+8.5,[0,0,1]) radius(6,19.2,"Z");
	//remove lower left radius
    translate([-11.33,-8.1,-6.6]) rotate(8.5,[0,0,1]) radius(8,19.2,"Z");
    //Remove slot for idler.
    translate([0,0,-0.5]) cylinder(r=16.5,h=7);
    }
  difference()
    {
	union()
	  {
      //Add in washers
      translate([0,0,-0.6]) cylinder(r=9.5/2,h=0.6);
      translate([0,0,6]) cylinder(r=9.5/2,h=0.6);
	  }
    //Remove hole for support shaft
    translate([0,0,-8]) cylinder(r=6/2,h=30);
	}
  }  
//=======================================================================================  
module sample_filament()
  {
  translate([-35.2,-31.1,-28.5])  //MK5_Interface_Plate translation
	{
    translate([-5,75/2,20])  rotate(90,[0,1,0]) cylinder(r=3/2,h=80);
    }
 }
//=======================================================================================  
module overcenter_lever()
  {
  lever_angle=40;
  difference()
    {
    union()
	  {
	  //main body of cylinder
	  translate([0,+10,0]) rotate(90,[1,0,0]) cylinder(r=15.5/2,h=19); 
      //Pivot hump thing
      translate([-14,10,0]) rotate(90,[1,0,0]) cylinder(r=8/2,h=19); 
      //I used to know math, haha. Add in the tangents.
      mirror([0,1,0]) translate([-14+1.1,-10,-3.82]) rotate(-15.45,[0,1,0]) cube([14,19,8]);
      mirror([0,0,1]) mirror([0,1,0]) translate([-14+1.1,-10,-3.82]) rotate(-15.45,[0,1,0]) cube([14,19,8]);
      rotate(lever_angle,[0,1,0])
	    {
        //Add in the lever.
        translate([-(15.5)/2,-(18)/2,0]) cube([15.5,19,40]);
        //Roundness on top of the lever
        translate([-0.27,-9,39.75]) rotate(-90,[1,0,0]) cylinder(r=3.31, h=19);
		}
      }
    //remove the axel hole
	translate([0,-12.5/2-7.5-0.5,0]) rotate(-90,[1,0,0]) cylinder(r=9.75/2, h=13+16);
    rotate(lever_angle,[0,1,0])
      {
      //Add some taper sexiness to the handle (no math, bleh)
      translate([-14.705,-(28)/2,3.19]) rotate(+6.34,[0,1,0]) cube([7,28,40]);
      translate([+7.75,-(28)/2,1.5]) rotate(-7,[0,1,0]) cube([7,28,46]);
	  }
	}
  }
//=======================================================================================    
module overcenter_tension_axel_keeper()
  {
  difference()
    {
    //Add keeper stop ring
    translate([0,0,-9.5-10]) cylinder(r=16/2, h=10);
    //remove hole in keeper    
    translate([0,0,-14.5]) cylinder(r=9.5/2, h=11, center=true);
	//Remove the flat
    translate([-3.35-5,0,-16.35]) cube([13,20,6.5], center=true); 
    //remove 6-32 ++ hole (~4.5mm)
    translate([0,0,-16.35]) rotate(90,[0,1,0]) cylinder(r=4.5/2, h=10);
	//Make the hole U shaped
	translate([0,-2.25,-16.35-8]) cube([13,4.5,8]); 
    }
  }
//=======================================================================================    
module overcenter_tension_axel()
  {
  difference()
    {
	union()
	  {
	  //Main body of axel
      cylinder(r=9/2, h=39, center=true);
	  //Add stop ring
      translate([0,0,+10.5]) cylinder(r=16/2, h=2.6);
	  }

	//Remove the flat
    translate([-3.35,0,-16.35]) cube([3,9,6.5], center=true); 
    translate([-3.35,0,+16.35]) cube([3,9,6.5], center=true); 
    //remove 6-32 hole (~3.5mm)
    translate([-4.6,0,-16.35]) rotate(90,[0,1,0]) cylinder(r=3.5/2, h=9.2);
    translate([-4.6,0,+16.35]) rotate(90,[0,1,0]) cylinder(r=3.5/2, h=9.2);
    }
  }
//=======================================================================================    
module body_tension_axel()
  {
  difference()
    {
    //Main body of axel
    cylinder(r=9/2, h=41, center=true);
	
	//Remove the flat
    translate([-4,0,-16.35]) cube([4,8,9], center=true); 
    translate([-4,0,+16.35]) cube([4,8,9], center=true); 
    //remove 6-32 hole (~3.5mm)
    translate([-4.1,0,-16.35]) rotate(90,[0,1,0]) cylinder(r=3.5/2, h=9.2);
    translate([-4.1,0,+16.35]) rotate(90,[0,1,0]) cylinder(r=3.5/2, h=9.2);
    }
  translate([0,0,-16.35])
	  {
	  difference()
	    {
		union()
		  {
          //Plug inside spring
          rotate(-90,[0,1,0]) cylinder(r=5.25/2, h=3.52);
	      //aligining bevel
          translate([-3.48,0,0]) rotate(-90,[0,1,0]) cylinder(h=1.02,r1=5.25/2,r2=4.5/2);	
		  }
		difference()
		  {
		  translate([-5,-5,-6/2]) cube([5,10,6]);
          translate([0,0,-5.5/2]) cylinder(r=9/2, h=5.5);
		  }
        //remove 6-32 hole (~3.5mm) in plug inside spring (oops)
        translate([-5.1,0,0]) rotate(90,[0,1,0]) cylinder(r=3.5/2, h=10.2);
  	    }
	  }
  translate([0,0,+16.35])
	  {
	  difference()
	    {
		union()
		  {
          //Plug inside spring
          rotate(-90,[0,1,0]) cylinder(r=5.25/2, h=3.02);
	      //aligining bevel
          translate([-2.98,0,0]) rotate(-90,[0,1,0]) cylinder(h=1.02,r1=5.25/2,r2=4.5/2);	
		  }
		difference()
		  {
		  translate([-5,-5,-6/2]) cube([5,10,6]);
          translate([0,0,-5.5/2]) cylinder(r=9/2, h=5.5);
		  }
        //remove 6-32 hole (~3.5mm) in plug inside spring (oops)
        translate([-5.1,0,0]) rotate(90,[0,1,0]) cylinder(r=3.5/2, h=10.2);
        }
	  }
  }
//=======================================================================================    
//6-32 x 4" completely threaded round head screw from small toggle bolt
module tension_adjusting_bolt()
  {
  cylinder(r=3.4/2,h=4*25.4);

  rad=3.125;
  difference()
    {
	//round head
    translate([0,0,-3+rad]) sphere(r=rad);
	translate([-5,-5,0]) cube([10,10,10]);
	//slot
	translate([0,0,-2.5]) rotate(30,[0,0,1]) cube([7,1,3],center=true);
	}
  }  
//=======================================================================================    
//6-32 x 4" completely threaded round head screw from small toggle bolt
module six_thirtytwo_wingnut()
  {
  rotate(42,[0,0,1])
  difference()
    {
	union()
	  {
	  //nut
	  cylinder(h=1.02,r=8/2);
	  translate([0,0,1]) cylinder(h=2.18,r1=8/2,r2=5.5/2);
	  //wing
	  translate([0,2.5/2,8.25]) rotate(90,[1,0,0]) cylinder(h=2.5,r=18/2);
	  }
	//remove 3.5mm hole
    translate([0,0,-1]) cylinder(r=3.5/2,h=6);
	difference()
	  {
	  //Remove inner wing
      translate([0,3/2,6.3]) rotate(90,[1,0,0]) cylinder(h=3,r=7.5/2);
      //Cut off bottom of inner removing wing
	  translate([-3,-1.5,-3+3.18]) cube([6,3,3]);
	  }
    difference()
	  {
	  translate([0,3/2,8.25]) rotate(90,[1,0,0]) cylinder(h=3,r=19/2);
	  //Clip wings
      translate([0,3/2,-6.3]) rotate(90,[1,0,0]) cylinder(h=3,r=26/2);
	  }
    //Cut off bottom of outer wing
	translate([-5,-5,-5]) cube([10,10,5]);
	}
  }  
//=======================================================================================    
module spring_centering_washer()
  {
    difference()
      {
      union()
	    {
        //base washer
        cylinder(r=9/2, h=2);
	    //Plug inside spring
        translate([0,0,1.98]) cylinder(r=5.25/2, h=3.02);
	    //aligining bevel
        translate([0,0,4.98]) cylinder(h=2.02,r1=5.25/2,r2=4.5/2);
        }
	  //remove 3.5mm / #6 hole
      translate([0,0,-0.1]) cylinder(r=3.5/2, h=9.2);
	  }
  }  
//=======================================================================================    
module main_body()
  {
  tightenit=0;
  difference()
    {
    union()
	  {
	  //main rectagular bulk
      translate([-30,-17.5,-20]) cube([57,32,22]);
      //Larger base plate to interface with MK5 bridge	
      translate([-30,-17.5,-20]) cube([6,60,28.5]);
      //Thicker on the back to capture nuts
      translate([-30+5.9,-17.5,1.9]) cube([10.1,60,6.6]);
      //Second base for hook
      translate([-30+5.9,14.4,-20]) cube([10.1,28.1,22]);
	  //Add fillet for looks
      translate([-30+6+10,14.5,-20+0.1]) radius(4,22-0.2,"Z");
      //Third base for hook
      translate([-30+6+9.9,22+6-4.75+4.75-tightenit,-20]) cube([9.5,5+4.75+4.75+tightenit,22]);
      //Add hinge pivot bump
      translate([-30+6+9.9+9.5-7/2,22+6-tightenit,-20]) cylinder(r=7/2,h=22);
	  //Add block below hinge hook, to later remove with a fillet
      //cube is visually positioned to line up tangents
	  translate([-30+6+9.9,22+6-4.75+3.8-tightenit,-20]) rotate(6,[0,0,1]) cube([3,3,22]);
	  }
    //Remove clearance for motor hub
    cylinder(r=22/2+0.1,h=2.1);
    //Remove support bearing + 0.1 tolerance
    translate([0,0,-(11+1+7+1+0.05)])     cylinder(r=22/2+0.1,h=7.1);
    //Remove clearance around drive pulley
    translate([0,0,-(20.5)]) cylinder(r=14.5/2,h=23);
    //Remove clearance around idler wheel
    translate([0,22,-(7.5+1+8/2)])     cylinder(r=17/2+7.2 + 1.44,h=8);
    //Remove clearance around motor body in thick back plate
    translate([0,0,2.002]) cylinder(r=(36+1)/2,h=6.7);
    //Remove fillet below hinge hook for looks and strength
  	//cylinder is visually positioned to line up tangents
    translate([-30+6+10+1.25,27.05-tightenit,-20.1]) cylinder(r=1.25,h=22.2);
	
	//Remove radius for looks
    translate([-4.5,42.5,-20.1])  rotate(180,[0,0,1]) radius(4,22.2,"Z");
    //Remove holes for the gearbox mounting, 3mm dia on a 28mm circle
    rotate(45,[0,0,1])
	  {
      //The 3mm holes for the gearbox mount
      translate([14,0,-21])  cylinder(r=3/2,h=24);
      translate([-14,0,-21]) cylinder(r=3/2,h=24);
      translate([0,14,-21])  cylinder(r=3/2,h=24);
      translate([0,-14,-21]) cylinder(r=3/2,h=24);
	  //Minimal (6 dia x 3.4 depth) clearance for the heads inside the idler well
      translate([14,0,-4.6]) cylinder(r=6/2,h=3.5);
      translate([0,14,-4.6]) cylinder(r=6/2,h=3.5);
      }

    //Extra bolt hole at top so the halves do not have to be glued
    translate([20,9.8994949,-21])  cylinder(r=3/2,h=24);
    translate([20,9.8994949,-1]) cylinder(r=6/2,h=3.1);
	//Hexagon trick from Giles Bathgate lib triangle solver http://nayuki.eigenstate.org/trianglesolver.html
	//5.6mm across flats : ((5.6)/2) / sin(60) = 3.2331615074619044
	translate([20,9.8994949,-20.1]) linear_extrude(height=7) circle(r=3.2331615074619044,$fn=6);

    //Extra bolt hole at top so the halves do not have to be glued
    translate([-19,37,-21]) cylinder(r=3/2,h=30);
    translate([-19,37,5.5]) cylinder(r=6/2,h=3.1);
    //Hexagon trick from Giles Bathgate lib triangle solver http://nayuki.eigenstate.org/trianglesolver.html
    //5.6mm across flats : ((5.6)/2) / sin(60) = 3.2331615074619044
    translate([-19,37,-20.1]) linear_extrude(height=4) circle(r=3.2331615074619044,$fn=6);

    //Remove main_body to MK5 plate holes and nut clearances
    translate([-30,-31.1,-28.5]) //MK5_Interface_Plate translation + x fudge
	  {
      //Remove the 4 main_body() mounting holes
      translate([-0.1,75/2 - 15 ,15.75])  rotate(90,[0,1,0]) cylinder(r=3/2,h=6.2+7);
      translate([-0.1,75/2 + 15 ,15.75])  rotate(90,[0,1,0]) cylinder(r=3/2,h=6.2+7);
      translate([-0.1,75/2 - 15 ,29.93])  rotate(90,[0,1,0]) cylinder(r=3/2,h=6.2+7);
      translate([-0.1,75/2 + 15 ,29.93])  rotate(90,[0,1,0]) cylinder(r=3/2,h=6.2+7);

      //Remove "nut slot" clearance for the the 4 main_body() mounting hole nuts
	  //A 3mm nut measures 5.41 across flats, 6.19 across points 2.28 tall
	  //Use 5.6 x 3 
      translate([6,75/2 - 15 -5.6/2,15.75-10.3+5.6/2]) cube([3,5.6,10.3]);
      translate([6,75/2 + 15 -5.6/2,15.75-10.3+5.6/2]) cube([3,5.6,10.3]);
      translate([6,75/2 - 15 -5.6/2,29.93-5.6/2-0.2])  cube([3,5.6,10.3]);
      translate([6,75/2 + 15 -5.6/2,29.93-5.6/2-0.2])  cube([3,5.6,10.3]);
      }

	//Remove Clearance for MK5 extruder mounting bolt heads
    translate([-35.2,-31.1,-28.5]) //MK5_Interface_Plate translation
      {
	  translate([5.1,75/2 - 17.3727 ,9])  rotate(90,[0,1,0]) cylinder(r=7.5/2,h=4.2);
      translate([5.1,75/2 + 17.3727 ,9])  rotate(90,[0,1,0]) cylinder(r=7.5/2,h=4.2);
      translate([5.1,75/2 - 17.3727 ,36.68])  rotate(90,[0,1,0]) cylinder(r=7.5/2,h=4.2);
      translate([5.1,75/2 + 17.3727 ,36.68])  rotate(90,[0,1,0]) cylinder(r=7.5/2,h=4.2);
      }

    // Remove filament bore
	translate([-35.2,-31.1,-28.5])  //MK5_Interface_Plate translation
	  {
      translate([-0.1,75/2,20])  rotate(90,[0,1,0]) cylinder(r=4/2,h=70);
	  //Manual threading guide cone
      translate([57,75/2,20])  rotate(90,[0,1,0]) cylinder(h=6,r1=3/2,r2=9/2);
	  //Threading guide cone below drive pulley (kind of a reach, that one)
      translate([25.5,75/2,20])  rotate(90,[0,1,0]) cylinder(h=6,r1=3/2,r2=8/2);
      }
    //Remove hole for tension axel
	translate([19.5,-11.5,-21]) cylinder(r=9.75/2,h=24);
    }
  }
//=======================================================================================  
module baxsie_pusher()  //Full assembly for visualization
  {
  //Main Body
  color([0,1,0,0.2])  main_body(); 

  //Kysan 42BYGH243-14 geared stepper motor
  color([0.25,0.50,0.25,0.25]) rotate(45,[0,0,1]) motor_outline();

  //The top plate of the MK5 style bridge that we need to mount to.
  //color([0.75,0.75,0.25,0.75]) translate([-35.2,-31.1,-28.5]) MK5_Interface_Plate();

  //3mm sample filament
  color([1,0,1,1]) sample_filament();

  //drive pulley
  //color([1,0,0,0.5]) translate([0,0,-(11+1)]) drive_gear();

  //drive shaft support bearing
  color([0,0,1,0.5]) translate([0,0,-(11+1+7+1)]) support_bearing();

  //larger filament idler wheel that can be printed.
  color([0,1,0.5,0.8]) translate([0,22,-(7.5+1+6/2)])  idler_wheel_printable(); 
  //idler bearing
  color([0,0,1,0.5]) translate([0,22,-(7.5+1+6/2)])  idler_bearing(); 
  //idler wheel frame ~ nominal operating
  color([0,1,0,0.3]) translate([0,22,-(7.5+1+6/2)]) idler_frame(); 
  // ~ max closed position
  //color([0,0,1,0.4]) translate([-1.0,22-1.,-(7.5+1+6/2)])  rotate(-8.5,[0,0,1])  %idler_frame(); 
  // ~ max open position
  //color([0,0,1,0.4]) translate([0.8,22+1.3,-(7.5+1+6/2)])  rotate(8.5,[0,0,1])  %idler_frame(); 


  //Overcenter tensioning lever
  color([1,0.25,0.5,0.3]) translate([19.5,22+14+6,-9]) rotate(90,[1,0,0]) rotate(97+2,[0,1,0]) overcenter_lever();
  // ~ open position
  //  translate([33.5,22+13.45,-9]) rotate(90,[1,0,0]) rotate(15,[0,1,0]) %overcenter_lever();
 
  //Axel through overcenter tensioning lever
  color([0,1,1,0.8]) translate([19.5,22+14+6,-9]) rotate(-90,[0,0,1])
    {
    overcenter_tension_axel();
    overcenter_tension_axel_keeper();
    }

  //Axel through body with cutouts for springs
  color([0,1,1,0.8]) translate([19.5,-11.5,-9]) rotate(90,[0,0,1]) body_tension_axel();

  //6-32 x4" completely threaded round head screw from small toggle bolt
  translate([19.5,22+14+6+1.85,-9-16.35]) rotate(90,[1,0,0]) tension_adjusting_bolt();
  //Tension Spring (un-compressed), washer and wingnuts
  //old spring: translate([20,-12-2.35,-9-16.35]) rotate(90,[1,0,0]) %spring(OD=8, WD=1.17, H=37, P=2.84);
  //CSC Century Spring Corp SC-419 21/64 x 1+5/16 x 0.062 (8.33 dia, 33.3375 tall, 1.5748 wire)
  //with flat ground ends
  translate([19.5,-12-1.5,-9-16.35]) rotate(90,[1,0,0]) %spring(OD=8.334375, WD=1.5748, H=33.3375, P=3.34);
  color([0,1,0,0.8]) translate([19.5,-12-1.5-33.3375-2,-9-16.35]) rotate(-90,[1,0,0]) spring_centering_washer();
  translate([19.5,-12-1.5-33.3375-2,-9-16.35]) rotate(90,[1,0,0]) six_thirtytwo_wingnut();

  //6-32 x4" completely threaded round head screw from small toggle bolt//
  translate([19.5,22+14+6+1.85,-9+16.35]) rotate(90,[1,0,0]) tension_adjusting_bolt();
  //Tension Spring (un-compressed), washer and wingnuts
  //old spring:  translate([20,-12-2.35,-9+16.35]) rotate(90,[1,0,0]) %spring(OD=8, WD=1.17, H=37, P=2.84);
  //CSC Century Spring Corp SC-419 21/64 x 1+5/16 x 0.062 (8.33 dia, 33.3375 tall, 1.5748 wire)
  //with flat ground ends
  translate([19.5,-12-1.5,-9+16.35]) rotate(90,[1,0,0]) %spring(OD=8.334375, WD=1.5748, H=33.3375, P=3.34);
  color([0,1,0,0.8]) translate([19.5,-12-1.5-33.3375-2,-9+16.35]) rotate(-90,[1,0,0]) spring_centering_washer();
  translate([19.5,-12-1.5-33.3375-2,-9+16.35]) rotate(90,[1,0,0]) six_thirtytwo_wingnut();
  }
//=======================================================================================  
