//=======================================================================================  
//usable capture range is  length-3.5
module bolt_3mm_socket_head_bolt_with_nut(length,center=false)
  {
  if(center) translate([0,0,-(length-3.5)/2])
    {
    bolt_3mm_socket_head_bolt(length);
    //1mm threads showing
    translate([0,0,length-2.5/2-1]) nut_3mm_x_5p5_x_2p5();
    }
  else
    {
    bolt_3mm_socket_head_bolt(length);
    //1mm threads showing
    translate([0,0,length-2.5/2-1]) nut_3mm_x_5p5_x_2p5();
    }
  }
//=======================================================================================  
module capsule(length,radius)
  {
  cylinder(r=radius,h=length-radius,center=true);
  translate([0,0,-(length-radius)/2]) sphere(r=radius);
  translate([0,0,+(length-radius)/2]) sphere(r=radius);
  }
//=======================================================================================  
//usable capture range is  length-3.97
module bolt_3mm_socket_head_bolt_with_washer_and_nut(length,center=false)
  {
  if(center) translate([0,0,-(length-3.97)/2])
    {
    translate([0,0,-0.47]) bolt_3mm_socket_head_bolt(length);
    translate([0,0,-0.47/2]) washer_3mm_0p47_thick();
    //1mm threads showing
    translate([0,0,length-2.5/2-1-0.47]) nut_3mm_x_5p5_x_2p5();
    }
  else
    {
    translate([0,0,-0.47]) bolt_3mm_socket_head_bolt(length);
    translate([0,0,-0.47/2]) washer_3mm_0p47_thick();
    //1mm threads showing
    translate([0,0,length-2.5/2-1-0.47]) nut_3mm_x_5p5_x_2p5();
    }
  }
//=======================================================================================  
module bolt_3mm_socket_head_bolt(length)
  {
  difference()
    {
    union()
      {
      //bolt
      translate([0,0,-0.1]) cylinder(r=3/2,h=length+0.1);
      //bolt's head
      translate([0,0,-3]) cylinder(r=5.5/2,h=3,$fn=18);
      }
    //bolt's hex socket
    translate([0,0,-3.1]) cylinder(r=(2.5/2)/sin(60),h=1.6,$fn=6);
    }
  }
//=======================================================================================  
module nut_3mm_x_5p5_x_2p5()
  {
  difference()
    {
    cylinder(r=(5.5/2)/sin(60),h=2.5,center=true,$fn=6);
    cylinder(r=3/2,h=2.5+0.2,center=true);
    }
  }
//=======================================================================================  
module washer_3mm_0p47_thick()
  {
  difference()
    {
    cylinder(r=6.76/2,h=0.47,center=true);
    cylinder(r=3.25/2,h=0.47+0.2,center=true);
    }
  }
//=======================================================================================  
//usable capture range is  length-4.22
module bolt_3mm_socket_head_bolt_with_washers_and_nut(length,center=false)
  {
  if(center) translate([0,0,-(length-4.22)/2])
    {
    translate([0,0,-0.47]) bolt_3mm_socket_head_bolt(length);
    translate([0,0,-0.47/2]) washer_3mm_0p47_thick();
    translate([0,0,length-2.5/2-1-3/2-0.47/2]) washer_3mm_0p47_thick();
    //1mm threads showing
    translate([0,0,length-2.5/2-1-0.47]) nut_3mm_x_5p5_x_2p5();
    }
  else
    {
    translate([0,0,-0.47]) bolt_3mm_socket_head_bolt(length);
    translate([0,0,-0.47/2]) washer_3mm_0p47_thick();
    translate([0,0,length-2.5/2-1-3/2-0.47/2]) washer_3mm_0p47_thick();
    //1mm threads showing
    translate([0,0,length-2.5/2-1-0.47]) nut_3mm_x_5p5_x_2p5();
    }
  }
  
  
  
  module radius(radius,length,axis)
  {
  if(axis=="X")
    {
	rotate(90,[1,0,0]) rotate(90,[0,1,0])
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius, $fn=60);
            }
	}
  else if(axis=="Y")
    {
	rotate(270,[0,1,0]) rotate(270,[1,0,0])
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius, $fn=60);
            }
	}
  else
      {
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius, $fn=60);
            }
	  }
  }



//DXF import
/*
translate([0,0,-2.5])
  %linear_extrude(file = "rod-cover.dxf",
                 layer = "0",
                 height = 5,
                 center = true,
                 convexity = 10,
                 twist = 0,
                 $fn=36);
*/

                 
//=======================================================================================  
module capsule(length,radius)
  {
  cylinder(r=radius,h=length-radius,center=true);
  translate([0,0,-(length-radius)/2]) sphere(r=radius);
  translate([0,0,+(length-radius)/2]) sphere(r=radius);
  }
//=======================================================================================  
module X_Guide_Rod_Clamps()
  {                 
  //Debug clamping hardware
  //usable capture range is  length-4.22
  //translate([-5,0,17])  rotate(90,[1,0,0]) %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=18,center=true, $fn=60);
  //translate([+5,0,17])  rotate(90,[1,0,0]) %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=18,center=true, $fn=60);

  //Debug mounting hardware
  translate([+10,+10,-5])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=14);
  translate([+10,-10,-5])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=14);
  translate([-10,+10,-5])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=14);
  translate([-10,-10,-5])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=14);
  
  //sample rod
  translate([0,0,-5])  %cylinder(r=(0.25*25.4)/2,h=30);
                 
  difference()
    {
    union()
      {
      translate([0,0,6.9])
        linear_extrude(height = 14.5, center = false, convexity = 6, twist = 0)
          difference()
            {
            //clamping block
            square([19,18-4.22],center=true);
            //tightening slot
            square([19.2,2],center=true);
            //Center hole. 0.25" 
            circle(r=(0.25*25.4+0.2)/2);
            }
      //base
      translate([0,0,3.5])
        linear_extrude(height = 7, center = true, convexity = 6, twist = 0)
          difference()
            {                 
            square([40,40],center=true);
            //mounting holes
            translate([+10,+10]) circle(r=3/2);
            translate([+10,-10]) circle(r=3/2);
            translate([-10,+10]) circle(r=3/2);
            translate([-10,-10]) circle(r=3/2);
            //Center hole. 0.25" 
            circle(r=(0.25*25.4+0.2)/2);
            }
      }
    //radius at bottom of slot
    translate([0,0,7]) rotate(90,[0,1,0]) capsule(length=20,radius=2/2);

    //clamping bolt holes
    translate([-5,0,17])  rotate(90,[1,0,0]) #cylinder(r=3/2,h=15,center=true);
    translate([+5,0,17])  rotate(90,[1,0,0]) #cylinder(r=3/2,h=15,center=true);
  
    //Locking recesses for mounting bolt nuts  
    translate([+10,+10,7-2.5])   #cylinder(r=(5.7/2)/sin(60),h=2.6,center=false,$fn=6);
    translate([+10,-10,7-2.5])   #cylinder(r=(5.7/2)/sin(60),h=2.6,center=false,$fn=6);
    translate([-10,+10,7-2.5])   #cylinder(r=(5.7/2)/sin(60),h=2.6,center=false,$fn=6);
    translate([-10,-10,7-2.5])   #cylinder(r=(5.7/2)/sin(60),h=2.6,center=false,$fn=6);
  
    //knock corners off to match MBI part
    translate([+20,+20,0]) rotate(180,[0,0,1]) radius(10,7,"Z");
    translate([+20,-20,0]) rotate( 90,[0,0,1]) radius(10,7,"Z");
    translate([-20,+20,0]) rotate(-90,[0,0,1]) radius(10,7,"Z");
    translate([-20,-20,0]) radius(10,7,"Z");
    }
  }
//=======================================================================================  
module Z_Drive_Screw_Coupler(cross_blade_thick)
  {
  //debug screw head clearance cylinder
  //translate([0,0,zoffset]) %cylinder(r=11.5,h=30);
  difference()
    {
    //top half of main body of coupler
    translate([0,0,21.5-6]) cylinder(r=10,h=38-(21.5-6));

    rotate(45,[0,0,1])
      {
      //remove all but drive cog, assuming cross_blade_thick rubber cross
      translate([+cross_blade_thick-(11+cross_blade_thick)/2,+cross_blade_thick-(11+cross_blade_thick)/2,18])
        cube([11+cross_blade_thick,11+cross_blade_thick,7],center=true);
      translate([-cross_blade_thick+(11+cross_blade_thick)/2,-cross_blade_thick+(11+cross_blade_thick)/2,18])
        cube([11+cross_blade_thick,11+cross_blade_thick,7],center=true);
      //Make it so the inside corner of the rubber can be a little rounded
      translate([+cross_blade_thick,-cross_blade_thick,15.5])
        rotate(-90,[0,0,1]) radius(2,6-0.1,"Z");
      translate([-cross_blade_thick,+cross_blade_thick,15.5])
        rotate(+90,[0,0,1]) radius(2,6-0.1,"Z");
      }    
    
    //hole for drive screw (8mm threads are slightly less than 8mm)
    translate([0,0,8+16]) cylinder(r=4,h=14.5);
    //Remove slot for upper clamp
    translate([-22/2,-2/2,8+16]) cube([22,2,14.5]);
    //radius in bottom
    translate([-22/2,0,8+16]) rotate(90,[0,1,0]) cylinder(r=2/2,h=22);
    //Remove holes for upper clamping bolts
    translate([+6,5,8+25]) rotate(90,[1,0,0]) cylinder(r=3/2,h=11);
    translate([-6,5,8+25]) rotate(90,[1,0,0]) cylinder(r=3/2,h=11);
    //Remove holes for nuts of upper clamping bolts
    translate([-6,-4.1-6,8+25]) rotate(-90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=6,$fn=6);
    translate([+6,+4.1,8+25]) rotate(-90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=6,$fn=6);
    //Remove holes for heads of upper clamping bolts
    translate([+6,-4.4,8+25]) rotate(+90,[1,0,0]) cylinder(r=(5.7/2),h=6);
    translate([-6,+4.4,8+25]) rotate(-90,[1,0,0]) cylinder(r=(5.7/2),h=6);
   }
  
  
  //Debug Hardware
  //usable capture range is  length-3.5
  translate([-6,4.4,8+25]) rotate(90,[1,0,0])
    %bolt_3mm_socket_head_bolt_with_nut(length=12);
  translate([+6,-4.4,8+25]) rotate(-90,[1,0,0])
    %bolt_3mm_socket_head_bolt_with_nut(length=12);
  }
//=======================================================================================  
module Z_Motor_Coupler(cross_blade_thick)
  {
  //debug screw head clearance cylinder
  //translate([0,0,zoffset]) %cylinder(r=11.5,h=30);
  difference()
    {
    //bottom half of main body of coupler
    cylinder(r=10,h=14.5+6);

    rotate(45,[0,0,1])
      {
      //remove all but drive cog, assuming cross_blade_thick rubber cross
      translate([+cross_blade_thick-(11+cross_blade_thick)/2,+cross_blade_thick-(11+cross_blade_thick)/2,18])
        cube([11+cross_blade_thick,11+cross_blade_thick,7],center=true);
      translate([-cross_blade_thick+(11+cross_blade_thick)/2,-cross_blade_thick+(11+cross_blade_thick)/2,18])
        cube([11+cross_blade_thick,11+cross_blade_thick,7],center=true);
      //Make it so the inside corner of the rubber can be a little rounded
      translate([+cross_blade_thick,-cross_blade_thick,14.6])
        rotate(-90,[0,0,1]) radius(2,6-0.1,"Z");
      translate([-cross_blade_thick,+cross_blade_thick,14.6])
        rotate(+90,[0,0,1]) radius(2,6-0.1,"Z");
      }        
    
    //hole for motor shaft
    translate([0,0,-0.5]) cylinder(r=2.5+0.1,h=13);
    //Remove slot for lower clamp
    translate([-22/2,-1.5/2,-0.5]) cube([22,1.5,13]);
   
    //radius in top
    translate([-22/2,0,12.5]) rotate(90,[0,1,0]) cylinder(r=1.5/2,h=22);
    //Remove holes for lower clamping bolts
    translate([+4.5,5,6]) rotate(90,[1,0,0]) cylinder(r=3/2,h=11);
    translate([-4.5,5,6]) rotate(90,[1,0,0]) cylinder(r=3/2,h=11);
    //Remove holes for nuts of lower clamping bolts
    translate([+4.5,-4.1,6]) rotate(+90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=6,$fn=6);
    translate([-4.5,+4.1,6]) rotate(-90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=6,$fn=6);
    //Remove holes for heads of lower clamping bolts
    translate([-4.5,-4.4-6,6]) rotate(-90,[1,0,0]) cylinder(r=(5.7/2),h=6);
    translate([+4.5,+4.4,6]) rotate(-90,[1,0,0]) cylinder(r=(5.7/2),h=6);
    }
  
  //Debug Hardware
  //usable capture range is  length-3.5
  translate([+4.5,4.4,6]) rotate(90,[1,0,0])
    %bolt_3mm_socket_head_bolt_with_nut(length=12);
  translate([-4.5,-4.4,6]) rotate(-90,[1,0,0])
    %bolt_3mm_socket_head_bolt_with_nut(length=12);
  }
//=======================================================================================  
module X_Drive_Coupling_Rubber_Star(cross_blade_thick)
  {
  translate([0,0,18]) cube([20,5,7],center=true);
  translate([0,0,18]) cube([5,20,7],center=true);
  //Make the corners rounderful
  translate([+cross_blade_thick,+cross_blade_thick,18-(7-0.2)/2])
    radius(2,7-0.2,"Z");
  translate([+cross_blade_thick,-cross_blade_thick,18-(7-0.2)/2])
    rotate(-90,[0,0,1]) radius(2,7-0.2,"Z");  
  translate([-cross_blade_thick,+cross_blade_thick,18-(7-0.2)/2])
    rotate(90,[0,0,1]) radius(2,7-0.2,"Z");
  translate([-cross_blade_thick,-cross_blade_thick,18-(7-0.2)/2])
    rotate(180,[0,0,1]) radius(2,7-0.2,"Z");  
  }
//=======================================================================================  

  
//X_Guide_Rod_Clamps();

//cross_blade_thick=2.5;


//color([1,0,0],1) rotate(+45,[0,0,1]) Z_Drive_Screw_Coupler(cross_blade_thick);
//color([0,1,0,0.3]) X_Drive_Coupling_Rubber_Star(cross_blade_thick);
//color([0,0,1],1) rotate(-45,[0,0,1]) Z_Motor_Coupler(cross_blade_thick);

module Z_guide_rod_clamp_12mm()
  {
  //Debug mounting hardware
  translate([+10,+10,0])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=16);
  translate([+10,-10,0])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=16);
  translate([-10,+10,0])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=16);
  translate([-10,-10,0])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=16);

  //Debug clamping hardware
  //usable capture range is  length-4.22
  translate([-8,0,25])  rotate(90,[1,0,0]) %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=22,center=true, $fn=60);
  translate([+8,0,25])  rotate(90,[1,0,0]) %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=22,center=true, $fn=60);

  difference()
    {
    union()
      {
      //inserts into the top wood panel
      cylinder(r=11,h=5.1);
      //big block for bolts
      translate([0,0,5+(16-3.97-5)/2]) cube([36,36,16-3.97-5],center=true);
      //clamping positive parts
      translate([0,0,9.9]) cylinder(r=10,h=19.1);
      translate([0,0,9.9+19.1/2]) cube([22,22-4.22,19.1],center=true);
      }
    //remove guide rod hole
    translate([0,0,-0.5]) cylinder(r=12.2/2,h=30);
    
    //remove mounting holes
    translate([+10,+10,4.5]) cylinder(r=3/2,h=8);
    translate([+10,-10,4.5]) cylinder(r=3/2,h=8);
    translate([-10,+10,4.5]) cylinder(r=3/2,h=8);
    translate([-10,-10,4.5]) cylinder(r=3/2,h=8);
    
    //printable clearance above nuts
    translate([+10,+10,12.04])   cylinder(r=4,h=5);
    translate([+10,+10,12+5.03]) cylinder(r1=4,r2=1,h=5.3);
    translate([+10,-10,12.04])   cylinder(r=4,h=5);
    translate([+10,-10,12+5.03]) cylinder(r1=4,r2=1,h=5.3);
    translate([-10,+10,12.04])   cylinder(r=4,h=5);
    translate([-10,+10,12+5.03]) cylinder(r1=4,r2=1,h=5.3);
    translate([-10,-10,12.04])   cylinder(r=4,h=5);
    translate([-10,-10,12+5.03]) cylinder(r1=4,r2=1,h=5.3);
    
    //knock the corners off for looks
    translate([+18,+18,4.9]) rotate(-180,[0,0,1]) radius(8,16-3.97-5+0.2,"Z");    
    translate([+18,-18,4.9]) rotate(  90,[0,0,1]) radius(8,16-3.97-5+0.2,"Z");    
    translate([-18,+18,4.9]) rotate( -90,[0,0,1]) radius(8,16-3.97-5+0.2,"Z");    
    translate([-18,-18,4.9]) rotate(   0,[0,0,1]) radius(8,16-3.97-5+0.2,"Z");    

    //remove clamping gap
    translate([0,0,16-3.97+18/2]) cube([22.2,3,18],center=true);
    //radius at bottom of clamping gap
    translate([0,0,16-3.97]) rotate(90,[0,1,0])   
      capsule(length=22.2,radius=3/2,$fn=60);

    //Remove holes for clamping hardware
    translate([-8,0,25])  rotate(90,[1,0,0]) cylinder(r=3/2,h=22,center=true, $fn=60);
    translate([+8,0,25])  rotate(90,[1,0,0]) cylinder(r=3/2,h=22,center=true, $fn=60);
    }
  }

  
  Z_guide_rod_clamp_12mm();