include <BaxsieStruder.scad>
ftrue=false; //quick way to turn true into false
facets3mmhole=24;
facets3mmcapsule=18;
facetsSmallRadii=24;
//=======================================================================================  
module capsule(length,radius)
  {
  cylinder(r=radius,h=length-radius,center=true);
  translate([0,0,-(length-radius)/2]) sphere(r=radius);
  translate([0,0,+(length-radius)/2]) sphere(r=radius);
  }
//=======================================================================================
module Z_Stage_Alignment_Pins()
  {
  //Alignment pins to align Plate 1 and Plate 2
  translate([48.25-16.5/2,115,-10]) rotate(90,[0,1,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([48.25-16.5/2,115,-40]) rotate(90,[0,1,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([48.25-16.5/2,105,-12]) rotate(90,[0,1,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([48.25-16.5/2,105,-40]) rotate(90,[0,1,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  //Alignment pins to align Plate 1 and Plate 3
  translate([ 3,109.25-16.5/2, -7]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([ 3,109.25-16.5/2,-25]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([33,109.25-16.5/2, -7]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([33,109.25-16.5/2,-35]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  //Alignment pins to align Plate 2 and Plate 3
  translate([46,109.25-16.5/2, -7]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([46,109.25-16.5/2,-45]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([79,109.25-16.5/2, -7]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([79,109.25-16.5/2,-45]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  //Alignment pins to align Plate 3 and Plate 4
  translate([55,    50-16.5/2,+10]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([15,    50-16.5/2,+10]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([55,    50-16.5/2,-18]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([10,    50-16.5/2,-18]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  }
//=======================================================================================
module Z_Stage_Verify_From_STL()
  {
  color([0.5,0.5,0.5,1])
    Z_Stage_Alignment_Pins();

  rotate(-180,[1,0,0])
    translate([-1,-94,+2])
      color([1,0,0,0.6])
        import_stl("check/plate1_fn360_bare.stl", convexity = 5);

  rotate(-180,[1,0,0])
    translate([+70,-130,+2])
      color([0,1,0,0.6])
        import_stl("check/plate2_fn360_bare.stl", convexity = 5);

  rotate(-90,[0,1,0])
    rotate(-18.65,[1,0,0])
      translate([-20,+81,-47.6466])
        color([1,0,1,0.6])
          import_stl("check/plate3_fn360.stl", convexity = 5);

  rotate(-180,[0,1,0])
    rotate(-25,[0,0,1])
      translate([-28,0,-17])
        color([0,0,1,0.6])
          import_stl("check/plate4_fn360.stl", convexity = 5);
  }
//=======================================================================================
Z_Stage_Verify_From_STL();
//=======================================================================================
