module right_triangle(side1,side2,height)
  {
  translate([0,0,-height/2]) linear_extrude(height=height) polygon(points=[[0,0],[0,side2],[side1,0]],paths=[[0,1,2]]);
  }

module support_bearing_build_support_framework(diameter,height,vanes)
  {
  union()
	{
	//Debug overall volume
    //%cylinder(r=(diameter/2),h=height);

	// 1.5mm base ring 2mm gap, 0.75mm thick
	difference()
      {	
      cylinder(r=(diameter-4)/2,h=height-0.75);
      translate([0,0,-0.1]) cylinder(r=(diameter-4-3)/2,h=height-0.55);
	  }

//	difference()
      //{	
      //cylinder(r=(diameter-1)/4,h=height-0.75);
      //translate([0,0,-0.1]) cylinder(r=(diameter-6)/4,h=height-0.55);
	  //}


	  
    //cylinder(r=1.5,h=height-0.75);

	  
	for(i=[0:vanes])
	  {
	  //Vane 0.5mm
	  rotate((360*i)/vanes,[0,0,1]) translate([0,-0.25,0]) cube([(diameter-4)/2,0.5,height]);
      //Top triangle point
	  rotate((360*i)/vanes,[0,0,1]) translate([(diameter-4)/2-0.1,0,height]) rotate(-90,[1,0,0]) right_triangle(2.1,height-0.75,0.5);
	  }
	}
  }

//$fn=180;  //prod build
//color([1,0,1,1]) support_bearing_build_support_framework(22,7,7);
//color([1,0,1,1]) translate([17,0,0]) support_bearing_build_support_framework(15,7,7);
//color([1,0,1,1]) translate([34,0,0]) support_bearing_build_support_framework(9,7,7);
//color([0,0,1,1]) translate([0,17,0]) support_bearing_build_support_framework(6,3.5,9);
