module 3dradius(radius,length,axis)
  {
  if(axis=="X")
    {
	rotate(90,[1,0,0]) rotate(90,[0,1,0])
      difference()
        {
      translate([-0.1,-0.1,-0.1])cube([radius+0.1,radius+0.1,length+0.2]);
	  translate([radius,radius,-0.2]) cylinder(r=radius,h=length+0.4);
	    }
	}
  else if(axis=="Y")
    {
	rotate(270,[0,1,0]) rotate(270,[1,0,0])
      difference()
        {
      translate([-0.1,-0.1,-0.1])cube([radius+0.1,radius+0.1,length+0.2]);
	  translate([radius,radius,-0.2]) cylinder(r=radius,h=length+0.4);
	    }
	}
  else
    difference()
      {
      translate([-0.1,-0.1,-0.1])cube([radius+0.1,radius+0.1,length+0.2]);
	  translate([radius,radius,-0.2]) cylinder(r=radius,h=length+0.4);
	  }
  }  


module 2dradius(radius,length,axis)
  {
  if(axis=="X")
    {
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius, $fn=60);
            }
	}
  else if(axis=="Y")
    {
	rotate(270,[0,1,0]) rotate(270,[1,0,0])
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius, $fn=60);
            }
	}
  else
      {
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius, $fn=60);
            }
	  }
  }