//Search for 
// VISUALIZATION SECTION
//and
// BUILD SECTION 
//to get to the good stuff!
//
// Load in OpenScad and press F4 to see what is going on.
// Be patient. It is a complex part and will take a while
// to render.
//=======================================================================================
//
// Use http://notepad-plus-plus.org/ to edit, set language to "JavaScript"
//
// Use http://www.openscad.org/ to render.
//  Set View -> Hide Editor
//  Set Design -> Automatic Reload and Compile
// then when you save in Notepad++ OpenSCAD will refresh.
//
// Set one of the the conditionals in the BUILD SECTION, then
// use F6 in OpenSCAD (wait for it) then use Design -> Export as STL
// to get Makerbottable STL parts, ready to bring into RepG
//
//=======================================================================================
// 0v0 2011/04/19
// Fix list:
//   Make all nuts flat parallel to build planes. (done, just a matter of rotation order)
//   Put support in lift nut? How to get rid of rotational slop there? Printed spring? Ball of some kind? Rubber?
//   Need to fix support under tab of stepper motor mount. Slope it up to curve (done, just backed it off)
//   Need to address screw legnth into steppers/thickness of stepper motor mount plate (done, thicker base)
//   Need to add clearance for MBI bolt on top mount (done)
//   Need to recess bearing adjustment bolt heads -- rub on wood (done, now 25mm bolts)
//   Need to look at ventialtion:
//     a) positive vacuum of fumes from extuder == future?
//     b) passive heat off extruder past MK5 plate (done, put a cone in there)
//   Stiffen lower drill guide bottom version horizontal hole arms (done)
//   Try to reduce plastic usage on lower drill guide bottom version (done)
//=======================================================================================
include <BaxsieStruder.scad>
ftrue=false; //quick way to turn true into false
//Small features rendered with smaller number of facets.
facets3mmhole=24;
facets3mmcapsule=18;
facetsSmallRadii=24;
//=======================================================================================
//The DXF downloaded on 2010/03/28 from:
//  http://svn.makerbot.com/trunk/cupcake/lasercut-parts/z-body/
//Cleaned up and extruded to 5mm using SolidWorks
module CupCakeWood()
  {
  /* Front  */ //translate([-145,-110,-355]) rotate(90,[1,0,0]) color([0,1,0,0.5]) import_stl("CupCake/makerbot_front_13.STL", convexity = 5);
  /* Back   */ //translate([-145,115,-263]) rotate(90,[1,0,0]) color([1,0,0,0.75]) import_stl("CupCake/makerbot_back_13.STL", convexity = 5);
  /* Left   */ translate([-140,+120,-360]) rotate(90,[1,0,0]) rotate(-90,[0,1,0]) color([0,0,1,0.5]) import_stl("CupCake/makerbot_left_13.STL", convexity = 5);
  /* Right  */ //translate([140,-120,-360]) rotate(90,[1,0,0]) rotate(90,[0,1,0]) color([0,0,1,0.75]) import_stl("CupCake/makerbot_right_13.STL", convexity = 5);
  /* Top    */ translate([-145,-120,0]) color([1,1,0,0.75]) import_stl("CupCake/makerbot_top_13.STL", convexity = 5);
  /* Middle */ translate([-145,-115,-263]) color([1,1,0,0.50]) import_stl("CupCake/makerbot_middle_13.STL", convexity = 5);
  /* Bottom */ //translate([-145,-120,-355]) color([1,1,0,0.25]) import_stl("CupCake/makerbot_bottom_13.STL", convexity = 5);
  /* Power  */ //translate([-145,115,-355]) rotate(90,[1,0,0]) color([1,0,0,0.75]) import_stl("CupCake/makerbot_power_13.STL", convexity = 5);

  //build_platform_with_range_of_motion();  
  
  //Rod cover by stepper  
  //translate([-140-5-5/2,+35,-235.5]) rotate(90,[0,1,0])
  //  linear_extrude(file = "CupCake/rod-cover.dxf",
  //                 layer = "0",
  //                 height = 5,
  //                 center = true,
  //                 convexity = 10,
  //                 twist = 0,
  //                 $fn=36);

  //MakerBot Z Stage
  //translate([-136,-74.93,-100]) color([0.7,0.7,0.8,0.50]) import_stl("CupCake/makerbot_zstage_13.STL", convexity = 5);
  }
//=======================================================================================
module Z_Stage_Verify_From_STL()
  {
  color([0.5,0.5,0.5,1])
    Z_Stage_Alignment_Pins();

  rotate(-180,[1,0,0])
    translate([-1,-94,+2])
      color([1,0,0,0.6])
        import_stl("check/plate1_fn360_bare.stl", convexity = 5);

  rotate(-180,[1,0,0])
    translate([+70,-130,+2])
      color([0,1,0,0.6])
        import_stl("check/plate2_fn360_bare.stl", convexity = 5);

  rotate(-90,[0,1,0])
    rotate(-18.65,[1,0,0])
      translate([-20,+81,-47.6466])
        color([1,0,1,0.6])
          import_stl("check/plate3_fn360.stl", convexity = 5);

  rotate(-180,[0,1,0])
    rotate(-25,[0,0,1])
      translate([-28,0,-17])
        color([0,0,1,0.6])
          import_stl("check/plate4_fn360.stl", convexity = 5);
  }  
//=======================================================================================  
module radius(radius,length,axis)
  {
  if(axis=="X")
    {
	rotate(90,[1,0,0]) rotate(90,[0,1,0])
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius);
            }
	}
  else if(axis=="Y")
    {
	rotate(270,[0,1,0]) rotate(270,[1,0,0])
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius);
            }
	}
  else
      {
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius);
            }
	  }
  }
//=======================================================================================  
module right_triangle(side1,side2,height)
  {
  translate([0,0,-height/2]) linear_extrude(height=height) polygon(points=[[0,0],[0,side2],[side1,0]],paths=[[0,1,2]]);
  }
//=======================================================================================  
module isosceles_triangle(base,length,height)
  {
  rotate(90,[1,0,0]) linear_extrude(height=length) polygon(points=[[-base/2,0],[+base/2,0],[0,height]],paths=[[0,1,2]]);
  }
//=======================================================================================  
module outer_cylinder_build_support_framework(innerdiameter,outerdiameter,height,vanes)
  {
  //Debug overall volume
  //%difference()
  //  {
  //  translate([0,0,height/2]) cylinder(r=(outerdiameter/2),h=height,center=true);
  //  translate([0,0,height/2]) cylinder(r=(innerdiameter/2),h=height+0.2,center=true);
  //  }

  intersection()
    {
    for(i=[0:vanes])
      rotate((360*i)/vanes,[0,0,1])
	    {
        //Fat 3mm base for build surface adhesion (fine to overlap these)
        translate([innerdiameter/2+2,-7/2,0])
          cube([(outerdiameter-innerdiameter)/2-2,7,height/4]);

        //Main 1mm vane
        translate([innerdiameter/2+2,-1/2,0])
          cube([(outerdiameter-innerdiameter)/2-2,1,(7*height)/8]);
        //Main 1mm inner triangle point
        translate([innerdiameter/2+2.1,0,(7*height)/8])
          rotate(180,[0,0,1])
            rotate(-90,[1,0,0])
              right_triangle(2*7/8,(5*height)/8,1);

        //Skinny 0.5mm contact point
        translate([innerdiameter/2+2,-0.5/2,0])
          cube([(outerdiameter-innerdiameter)/2-2,0.5,height]);
        //Top 0.5 inner triangle point
        translate([innerdiameter/2+2.1,0,height])
          rotate(180,[0,0,1])
            rotate(-90,[1,0,0])
              right_triangle(2.1,(3*height)/4,0.5);
	    }
    difference()
      {
      translate([0,0,height/2]) cylinder(r=(outerdiameter/2),h=height,center=true);
      translate([0,0,height/2]) cylinder(r=(innerdiameter/2),h=height+0.2,center=true);
      }
	}
  }
//=======================================================================================  
module capsule(length,radius)
  {
  cylinder(r=radius,h=length-radius,center=true);
  translate([0,0,-(length-radius)/2]) sphere(r=radius);
  translate([0,0,+(length-radius)/2]) sphere(r=radius);
  }
//=======================================================================================  
module oval_extrusion(x_length,y_thickness,z_height)
  {
  linear_extrude(height = z_height, center = true, convexity = 2, twist = 0)
    union()
      {
      square([x_length-y_thickness,y_thickness],center=true);
      translate([+(x_length-y_thickness)/2,0,0]) circle(r=y_thickness/2,center=true);
      translate([-(x_length-y_thickness)/2,0,0]) circle(r=y_thickness/2,center=true);
      }
  }
//=======================================================================================  
module build_platform_with_range_of_motion()
  {
  translate([0,0,-273+10+6+83.5])
    color([1,0,1,0.85])
      {
      translate([-103,-103,-1]) cube([100,100,1]);
      translate([-103,+3,-1]) cube([100,100,1]);
      translate([+3,-103,-1]) cube([100,100,1]);
      translate([+3,+3,-1]) cube([100,100,1]);
      //110 high build volume
      color([0.5,0.5,0.5,0.2]) translate([-50,-50,-1.1]) %cube([100,100,1.1+110]);    
      }
  }
//=======================================================================================  
module MK5_Base_Plate()
  {
  //MK5 base plate --exact from from DXF
  translate([-27.161,220,2.6])
    rotate(-90,[0,0,1])
    color([1,0,0,0.5])
    linear_extrude(file = "MK5/layout-acrylic.dxf",
                   layer = "5 Interface Spacer Mount",
                   height = 5.2,
                   center = true,
                   convexity = 10,
                   twist = 0,
                   $fn=36);
  }
//=======================================================================================  
module pusher_and_extruder()
  {
  //MiseryPusher
  translate([8.5,6.4,35.2]) rotate(180,[1,0,0])  rotate(90,[0,1,0]) baxsie_pusher(); //Full assembly for visualization   

  MK5_Base_Plate();

  //MK5 Hot End envelope     
  union()
    {            
    //screws & plate
    translate([0,0,-35/2])    color([1,0,0.5,0.5]) cube([33.7,41,35],center = true);
    //tube
    translate([0,0,-66])      color([1,0,0.5,0.5]) cylinder(r=4,h=66);
    //heater, wrapped
    translate([0,0,-66+25/2]) color([1,0,0.5,0.5]) cube([40,50,25],center = true);
    //hex
    translate([0,0,-66-10])   color([1,0,0.5,0.5]) cylinder(r=14.8/2,h=10,$fn=6);
    //cone
    translate([0,0,-66-10-4]) color([1,0,0.5,0.5]) cylinder(r2=13.1/2,r1=0.5,h=4);
    }
  }
//=======================================================================================  
//build platform for debug
//color([0.5,0.5,0.5,0.1]) translate([-50,-50,-1.01]) %cube([100,100,1]);
//======================================================================================= 
// 12mm Linear Motion Shaft 13" Hardened Rod
// Part Number: kit1002
// Our Low Price: $4.95 on 2011/05/25
// http://www.vxb.com/page/bearings/PROD/12mmLinearMotionSystems/kit1002
module guide_rod_12mm_x_13in()
  {
  color([0.25,0.25,0.25,0.5])
    cylinder(r=12/2,h=328.6125); //12 + 15/16
  //debug cross-hairs to verify centers  
  //translate([0,0,(328.6125+0.01)/2]) %cube([40,0.01,328.6125+0.2],center=true);
  //translate([0,0,(328.6125+0.01)/2]) %cube([0.01,40,328.6125+0.2],center=true);
  }
//=======================================================================================  
module linear_ball_bearing_12mm_x_21mm_x_30mm()
  {
  color([0,0,1,0.75])
    difference()
      {
      cylinder(r=21/2,h=30,center=true);
      cylinder(r=12/2,h=31,center=true);
      }
  }
//=======================================================================================  
module bolt_3mm_socket_head_bolt(length)
  {
  difference()
    {
    union()
      {
      //bolt
      translate([0,0,-0.1]) cylinder(r=3/2,h=length+0.1);
      //bolt's head
      translate([0,0,-3]) cylinder(r=5.5/2,h=3,$fn=18);
      }
    //bolt's hex socket
    translate([0,0,-3.1]) cylinder(r=(2.5/2)/sin(60),h=1.6,$fn=6);
    }
  }
//=======================================================================================  
module nut_3mm_x_5p5_x_2p5()
  {
  difference()
    {
    cylinder(r=(5.5/2)/sin(60),h=2.5,center=true,$fn=6);
    cylinder(r=3/2,h=2.5+0.2,center=true);
    }
  }
//=======================================================================================  
module washer_3mm_0p47_thick()
  {
  difference()
    {
    cylinder(r=6.76/2,h=0.47,center=true);
    cylinder(r=3.25/2,h=0.47+0.2,center=true);
    }
  }
//=======================================================================================  
module bearing_623_3mm_x_10mm_x_4mm()
  {
  difference()
    {
    cylinder(r=10/2,h=4,center=true);
    cylinder(r=3/2,h=4.2,center=true);
    }
  }
//=======================================================================================  
module bearing_608_8mm_x_22mm_x_7mm()
  {
  difference()
    {
    cylinder(r=22/2,h=7,center=true);
    cylinder(r=8/2,h=7.2,center=true);
    }
  }
//=======================================================================================  
//usable capture range is  length-7.97
module bearing_623_with_3mm_socket_head_bolt_and_washer(length)
  {
  bolt_3mm_socket_head_bolt(length);
  translate([0,0,4/2]) bearing_623_3mm_x_10mm_x_4mm();
  translate([0,0,4+0.47/2]) washer_3mm_0p47_thick();
  //1mm threads showing
  translate([0,0,length-2.5/2-1]) nut_3mm_x_5p5_x_2p5();
  }
//=======================================================================================  
module bearing_623_with_washers()
  {
  translate([0,0,+2+0.47/2]) washer_3mm_0p47_thick();
  bearing_623_3mm_x_10mm_x_4mm();
  translate([0,0,-2-0.47/2]) washer_3mm_0p47_thick();
  }
//=======================================================================================  
//usable capture range is  length-4.22
module bolt_3mm_socket_head_bolt_with_washers_and_nut(length,center=false)
  {
  if(center) translate([0,0,-(length-4.22)/2])
    {
    translate([0,0,-0.47]) bolt_3mm_socket_head_bolt(length);
    translate([0,0,-0.47/2]) washer_3mm_0p47_thick();
    translate([0,0,length-2.5/2-1-3/2-0.47/2]) washer_3mm_0p47_thick();
    //1mm threads showing
    translate([0,0,length-2.5/2-1-0.47]) nut_3mm_x_5p5_x_2p5();
    }
  else
    {
    translate([0,0,-0.47]) bolt_3mm_socket_head_bolt(length);
    translate([0,0,-0.47/2]) washer_3mm_0p47_thick();
    translate([0,0,length-2.5/2-1-3/2-0.47/2]) washer_3mm_0p47_thick();
    //1mm threads showing
    translate([0,0,length-2.5/2-1-0.47]) nut_3mm_x_5p5_x_2p5();
    }
  }
//=======================================================================================  
//usable capture range is  length-3.97
module bolt_3mm_socket_head_bolt_with_washer_and_nut(length,center=false)
  {
  if(center) translate([0,0,-(length-3.97)/2])
    {
    translate([0,0,-0.47]) bolt_3mm_socket_head_bolt(length);
    translate([0,0,-0.47/2]) washer_3mm_0p47_thick();
    //1mm threads showing
    translate([0,0,length-2.5/2-1-0.47]) nut_3mm_x_5p5_x_2p5();
    }
  else
    {
    translate([0,0,-0.47]) bolt_3mm_socket_head_bolt(length);
    translate([0,0,-0.47/2]) washer_3mm_0p47_thick();
    //1mm threads showing
    translate([0,0,length-2.5/2-1-0.47]) nut_3mm_x_5p5_x_2p5();
    }
  }
//=======================================================================================  
//usable capture range is  length-3.5
module bolt_3mm_socket_head_bolt_with_nut(length,center=false)
  {
  if(center) translate([0,0,-(length-3.5)/2])
    {
    bolt_3mm_socket_head_bolt(length);
    //1mm threads showing
    translate([0,0,length-2.5/2-1]) nut_3mm_x_5p5_x_2p5();
    }
  else
    {
    bolt_3mm_socket_head_bolt(length);
    //1mm threads showing
    translate([0,0,length-2.5/2-1]) nut_3mm_x_5p5_x_2p5();
    }
  }
//=======================================================================================  
module X_Guide_Rod_Clamp_8mm()
  {                 
  //Debug clamping hardware
  //usable capture range is  length-4.22
  translate([-5,0,17])  rotate(90,[1,0,0]) %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=18,center=true, $fn=60);
  translate([+5,0,17])  rotate(90,[1,0,0]) %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=18,center=true, $fn=60);

  //Debug mounting hardware
  translate([+10,+10,-5])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=14);
  translate([+10,-10,-5])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=14);
  translate([-10,+10,-5])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=14);
  translate([-10,-10,-5])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=14);
  
  //sample rod
  translate([0,0,-5])  %cylinder(r=(0.25*25.4)/2,h=30);
                 
  difference()
    {
    union()
      {
      translate([0,0,6.9])
        linear_extrude(height = 14.5, center = false, convexity = 6, twist = 0)
          difference()
            {
            //clamping block
            square([19,18-4.22],center=true);
            //tightening slot
            square([19.2,2],center=true);
            //Center hole. 0.25" 
            circle(r=(0.25*25.4+0.2)/2);
            }
      //base
      translate([0,0,3.5])
        linear_extrude(height = 7, center = true, convexity = 6, twist = 0)
          difference()
            {                 
            square([40,40],center=true);
            //mounting holes
            translate([+10,+10]) circle(r=3/2,$fn=facets3mmhole);
            translate([+10,-10]) circle(r=3/2,$fn=facets3mmhole);
            translate([-10,+10]) circle(r=3/2,$fn=facets3mmhole);
            translate([-10,-10]) circle(r=3/2,$fn=facets3mmhole);
            //Center hole. 0.25" 
            circle(r=(0.25*25.4+0.2)/2);
            }
      }
    //radius at bottom of slot
    translate([0,0,7]) rotate(90,[0,1,0]) capsule(length=20,radius=2/2,$fn=facets3mmhole);

    //clamping bolt holes
    translate([-5,0,17])  rotate(90,[1,0,0]) cylinder(r=3/2,h=15,center=true,$fn=facets3mmhole);
    translate([+5,0,17])  rotate(90,[1,0,0]) cylinder(r=3/2,h=15,center=true,$fn=facets3mmhole);
  
    //Locking recesses for mounting bolt nuts  
    translate([+10,+10,7-2.5])   cylinder(r=(5.7/2)/sin(60),h=2.6,center=false,$fn=6);
    translate([+10,-10,7-2.5])   cylinder(r=(5.7/2)/sin(60),h=2.6,center=false,$fn=6);
    translate([-10,+10,7-2.5])   cylinder(r=(5.7/2)/sin(60),h=2.6,center=false,$fn=6);
    translate([-10,-10,7-2.5])   cylinder(r=(5.7/2)/sin(60),h=2.6,center=false,$fn=6);
  
    //knock corners off to match MBI part
    translate([+20,+20,0]) rotate(180,[0,0,1]) radius(10,7,"Z");
    translate([+20,-20,0]) rotate( 90,[0,0,1]) radius(10,7,"Z");
    translate([-20,+20,0]) rotate(-90,[0,0,1]) radius(10,7,"Z");
    translate([-20,-20,0]) radius(10,7,"Z");
    }
  }
//=======================================================================================  
module triple_bearing_set()
  {
  /* for 120 deg add rotate(-15,[0,0,1]) */
  translate([12/2+10/2,2,0]) rotate(90,[1,0,0]) bearing_623_with_3mm_socket_head_bolt_and_washer(length=22);
  /* for 120 deg add rotate(+15,[0,0,1]) */
  translate([2,12/2+10/2,0]) rotate(-90,[0,1,0]) bearing_623_with_3mm_socket_head_bolt_and_washer(length=22);
  
  //Back bearing
  rotate(225,[0,0,1]) translate([12/2+10/2,0,0]) rotate(-90,[1,0,0]) bolt_3mm_socket_head_bolt_with_washer_and_nut(length=30,center=true);
  rotate(225,[0,0,1]) translate([12/2+10/2,0,0]) rotate(90,[1,0,0]) bearing_623_with_washers();

  //Adjustment bolt
  rotate(225,[0,0,1]) translate([-12/2-3,2,-10]) rotate(-90,[1,0,0]) bolt_3mm_socket_head_bolt_with_nut(length=25,center=true);
  }
//=======================================================================================  
module double_bearing_set()
  {
  translate([-2,+12/2+10/2,0]) rotate(+90,[0,1,0]) bearing_623_with_3mm_socket_head_bolt_and_washer(length=22);
  translate([-2,-12/2-10/2,0]) rotate(+90,[0,1,0]) bearing_623_with_3mm_socket_head_bolt_and_washer(length=22);
  //Adjustment bolt
  rotate(180,[0,0,1]) translate([-12/2-3,0,-4]) rotate(-90,[1,0,0]) bolt_3mm_socket_head_bolt_with_washers_and_nut(length=35,center=true);
  }
//=======================================================================================  
//Remove from the Z stage after slicing.
//Use 14mm lengths of filament inserted into these holes to align the
//modules during gluing
module Z_Stage_Alignment_Pins()
  {
  //Alignment pins to align Plate 1 and Plate 2
  translate([48.25-16.5/2,115,-10]) rotate(90,[0,1,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([48.25-16.5/2,115,-40]) rotate(90,[0,1,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([48.25-16.5/2,105,-12]) rotate(90,[0,1,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([48.25-16.5/2,105,-40]) rotate(90,[0,1,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  //Alignment pins to align Plate 1 and Plate 3
  translate([ 3,109.25-16.5/2, -7]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([ 3,109.25-16.5/2,-25]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([33,109.25-16.5/2, -7]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([33,109.25-16.5/2,-35]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  //Alignment pins to align Plate 2 and Plate 3
  translate([46,109.25-16.5/2, -7]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([46,109.25-16.5/2,-45]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([79,109.25-16.5/2, -7]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([79,109.25-16.5/2,-45]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  //Alignment pins to align Plate 3 and Plate 4
  translate([55,    50-16.5/2,+10]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([15,    50-16.5/2,+10]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([55,    50-16.5/2,-18]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  translate([10,    50-16.5/2,-18]) rotate(90,[1,0,0]) capsule(15,3/2,$fn=facets3mmcapsule);
  }
//=======================================================================================  
//Sorry this code is such a mess.
module Z_Stage()
  {
  //Main support triple bearing sets, +90,-90,45
  translate([+85,120,-2])
    {
    difference()
      {
      union()
        {
        //Bearing mounting blocks
        translate([-4/2-0.47-(22-7.97)/2-1.25,12/2+10/2-5,-8-40/2]) cube([22-7.97+2.5,20,8+40+8],center=true);
        translate([12/2+10/2-5,-4/2-0.47-(22-7.97)/2-1.25,-8-40/2]) cube([20,22-7.97+2.5,8+40+8],center=true);
       
        //adjustment bolt mounting blocks
        rotate(45,[0,0,1])
          {
          //head side
          translate([12/2+10/2-2,+(30-3.5)/4+0.5,-8-40/2])       cube([14,(30-3.5)/2-1,28],center=true);
          //nut side
          translate([12/2+10/2-2,-(30-3.5)/4-0.5 -1.25,-8-40/2]) cube([14,(30-3.5)/2-1 +2.5,28],center=true);
          //back bearing mounting block
          translate([-12/2-10/2-5,0,-8-40/2]) cube([20,30-3.97,8+40+8],center=true);
          }
        }
      //Remove 1mm clearance cylinder around rod  
      translate([0,0,-8-40/2]) cylinder(r=14/2,h=8.1+40+8.1,center=true);

      //Remove holes front bearing bolts
      translate([+11,-22/2, -8]) rotate(90,[1,0,0]) cylinder(r=3/2,h=22,center=true,$fn=facets3mmhole);
      translate([+11,-22/2,-48]) rotate(90,[1,0,0]) cylinder(r=3/2,h=22,center=true,$fn=facets3mmhole);
      translate([-22/2,+11, -8]) rotate(90,[0,1,0]) cylinder(r=3/2,h=22,center=true,$fn=facets3mmhole);
      translate([-22/2,+11,-48]) rotate(90,[0,1,0]) cylinder(r=3/2,h=22,center=true,$fn=facets3mmhole);
      //Remove hex recesses for front bearing nuts
      translate([+11,-22+7.97-2.5-8/2, -8]) rotate(90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=8,center=true,$fn=6);
      translate([+11,-22+7.97-2.5-8/2,-48]) rotate(90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=8,center=true,$fn=6);
      translate([-22+7.97-2.5-8/2,+11, -8]) rotate(90,[0,0,1]) rotate(90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=8,center=true,$fn=6);
      translate([-22+7.97-2.5-8/2,+11,-48]) rotate(90,[0,0,1]) rotate(90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=8,center=true,$fn=6);

      //bevel bottom (duplicated below)
      translate([-85,-120,+2])
        {
        translate([20,73,-62.])
          rotate(59.8,[1,0,0])
            rotate(90,[0,1,0])
              oval_extrusion(120,35.1,160);
        //Remove huge bevel under arm to main bearing block
        //(duplicated below)
        translate([22.6,73,-59.35])
          rotate(22.18,[0,1,0])
            rotate(0,[0,0,1])
              rotate(90,[1,0,0])
                oval_extrusion(140,35.1,160);
        }
     
      //Remove radius
      translate([12/2+10/2+5,-19 ,-(8+40+8)]) rotate(90,[0,0,1]) radius(2,8+40+8,"Z",$fn=facetsSmallRadii);
      translate([-19,12/2+10/2+5,-(8+40+8)]) rotate(-90,[0,0,1]) radius(2,8+40+8,"Z",$fn=facetsSmallRadii);

      rotate(45,[0,0,1])
        {
        //Remove adjustment bolt nut recesses
        translate([9,-15.25,-8-40/2+10]) rotate(90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=5,center=true,$fn=6);
        translate([9,-15.25,-8-40/2-10]) rotate(90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=5,center=true,$fn=6);
        //Remove adjustment bolt holes
        translate([9,0,-8-40/2-10]) rotate(90,[1,0,0]) cylinder(r=3/2,h=30,center=true,$fn=facets3mmhole);
        translate([9,0,-8-40/2+10]) rotate(90,[1,0,0]) cylinder(r=3/2,h=30,center=true,$fn=facets3mmhole);
        //Remove radius
        translate([12/2+10/2+5,-15.75 ,-8-40/2-28/2]) rotate(90,[0,0,1]) radius(4,28,"Z");
        //Remove adjustment bolt head recesses
        translate([9,+15.25-2,-8-40/2+10]) rotate(90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=9,center=true);
        translate([9,+15.25-2,-8-40/2-10]) rotate(90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=9,center=true);
        //Remove radius
        //translate([12/2+10/2+5,15.75 -2.5,-8-40/2-28/2]) rotate(180,[0,0,1]) radius(4,28,"Z");
        //Remove fillet so it does not rub on the wood
        translate([12/2+10/2+5,15.75 -2.5,-8-40/2-28/2]) rotate(180-45,[0,0,1]) translate([-5,-0.317,0]) cube([9.7,5,28]);
       
        //Remove back bearing axel bolt hole
        translate([-11,0, -8]) rotate(90,[1,0,0]) cylinder(r=3/2,h=30,center=true,$fn=facets3mmhole);
        translate([-11,0,-48]) rotate(90,[1,0,0]) cylinder(r=3/2,h=30,center=true,$fn=facets3mmhole);
        //Remove back bearing axel bolt head recesses
        translate([-11,+((30-3.97)/2)+8/2, -8]) rotate(90,[1,0,0]) cylinder(r=7.7/2,h=8,center=true);
        translate([-11,+((30-3.97)/2)+8/2,-48]) rotate(90,[1,0,0]) cylinder(r=7.7/2,h=8,center=true);
        //Remove back bearing axel bolt nut recesses
        translate([-11,-((30-3.97)/2)-8/2, -8]) rotate(90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=8,center=true,$fn=6);
        translate([-11,-((30-3.97)/2)-8/2,-48]) rotate(90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=8,center=true,$fn=6);
        //remove clearance for back bearings
        translate([-11,0,-8-40/2]) cube([12,4+0.47+0.47,8+40+8+0.2],center=true);
        }
      } //end of difference()
    } //end of translate()

  //Anti-rotation double bearing set
  translate([-45,120,-2])
    {
    difference()
      {
      union()
        {
        //Bearing mounting blocks
        translate([+4/2+0.47+(22-7.97)/2+1.25,2.5+14/2,-(8+8+4)/2]) cube([22-7.97+2.5,14,8+8+4],center=true);
        translate([+4/2+0.47+(22-7.97)/2+1.25,-2.5-14/2,-(8+8+4)/2]) cube([22-7.97+2.5,14,8+8+4],center=true);
       
        //Add in a radius for the tapered edges to be tangent to
        translate([19,+0,-26]) cylinder(r=16.5,h=26);
        }
      //Remove 1mm clearance cylinder around rod  
      translate([0,0,-8-4/2]) cylinder(r=14/2,h=8.1+4+8.1,center=true);
      //Remove radius at end of adjustment gap
      translate([19,0,-(8+8+4+4.1)]) rotate(0,[1,0,0]) cylinder(r=2.5,h=8+8+4+4.2);
      //Remove adjustment gap
      translate([4,-4.98/2,-(8+8+4+0.1)]) cube([15,4.98,8+8+4+0.2]);
     
      //Remove back bearing axel bolt hole
      translate([+9,0, -12]) rotate(90,[1,0,0]) cylinder(r=3/2,h=30,center=true,$fn=facets3mmhole);
      //Remove back bearing axel bolt head recesses
      translate([+9,+((30-3.97)/2)+8/2, -12]) rotate(90,[1,0,0]) cylinder(r=7.7/2,h=8,center=true);
      //Remove back bearing axel bolt nut recesses
      translate([+9,-((30-3.97)/2)-8/2, -12]) rotate(90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=8,center=true,$fn=6);

      //Remove holes front bearing bolts
      translate([+14,+11, -8]) rotate(90,[0,1,0]) cylinder(r=3/2,h=24,center=true,$fn=facets3mmhole);
      translate([+14,-11, -8]) rotate(90,[0,1,0]) cylinder(r=3/2,h=24,center=true,$fn=facets3mmhole);
      //Remove "nut slot" clearance for the bearing mounting hole nuts
      //A 3mm nut measures 5.41 across flats, 6.19 across points 2.28 tall
	  //Use 5.6 x 3 x 6.3
      translate([16.5,+11-6.3/2,-5.6/2-8]) cube([3,10.3,5.6]);
      translate([16.5,-11+6.3/2-10.3,-5.6/2-8]) cube([3,10.3,5.6]);

      //Smooth the bearing mounting blocks
      translate([2.5,-16.5 ,-(8+4+8)])
        radius(2,8+4+8,"Z",$fn=facetsSmallRadii);
      translate([2.5,+16.5 ,-(8+4+8)])
        rotate(-90,[0,0,1])
          radius(2,8+4+8,"Z",$fn=facetsSmallRadii);
     
      //Remove huge bevel under arm to main bearing block
      //(duplicated below)
      translate([45,-120,2])
        translate([22.6,73,-59.35])
          rotate(22.18,[0,1,0]) rotate(0,[0,0,1]) rotate(90,[1,0,0])
            oval_extrusion(140,35.1,160);

      //These two duplicated below
      translate([0,0,0])
        {
        //Remove huge bevel under arm to main bearing block
        //rotate(21,[0,1,0]) translate([24.8025,-80/2,-(40+8+8)+4.097]) cube([100,80,40]);
        //Remove tag on end of arm to main bearing block
        color([1,0,0,0.4]) translate([8.89-10,-(50)/2,-40.0]) cube([20,50,20]);
        }
      } //end of difference()
    } //end of translate()

  //Arms connecting things
  difference()
    {
    union()
      {
      //Add in massive arm to main bearing block, trimmed down below
      color([0,0,1,0.2]) translate([-45,120,-2]) rotate(-7.3,[0,0,1])
        translate([18-3+10,-20.8+10,-(40+8+8)]) cube([90,28+5-0.75-10,40+8+8]);
       
      //Put the support bosses under the MK5 plate
      rotate(25,[0,0,1])
        {
        //Put Y+ boss under the MK5 plate
        translate([2.85-45.7/2,-27.5-10,-23]) cube([45.7,10,40]);
        //Put Y- boss under the MK5 plate
        translate([2.85-45.7/2,27.5,-23]) cube([45.7,10,40]);
        }
      //Add the outside radius at the back of MK5 plate
      translate([35.,-14.023,-33]) cylinder(r=10,h=50);
                
      //Add in the arm from the right of the MK5 to the
      //back triple bearing support
      translate([35,-14.023,-58])
        rotate(-18.65,[0,0,1])
          translate([-40,0,0])
            cube([50,125,75]);
      //Add in the arm from the left of the MK5 to the
      //front double bearing support
      translate([-5,16,-58]) cube([50,90,75]);
      }  //end of union()
    //Round the MK5 bosses for fun
    rotate(25,[0,0,1])
      translate([2.85-45.7/2,-27.5-10,-23])
        radius(20,(27.5+10)*2,"Y");
    //Remove a chimney so hot air rising from the extruder
    //does not get trapped under the MK5 Base
    //duped below
    rotate(25,[0,0,1])
      translate([17,0,-35.9]) cylinder(r1=1,r2=27.5,h=53,$fn=120);
        
    //Remove the ends of the support under the MK5 base
    rotate(25,[0,0,1])
      translate([2.85-45.7/2,-27.5-0.02,-72.98])
        cube([45.7,27.5*2-0.04,90]);
    //remove a radius at the back of MK5 plate
    translate([-12.14,95.1,-32.9])
      cylinder(r=12,h=50);
    //Some radius goodness
    translate([-8.03,70.2,-23])
      rotate(89,[0,0,1])
        oval_extrusion(64,15,82);
    //remove arm overshoot
    translate([40,131,13])
      rotate(90,[1,0,0])
        rotate(90,[0,1,0])
          oval_extrusion(90,30,100);
    //bevel top
    translate([40,131-58.5,22.3])
      rotate(72,[1,0,0])
        rotate(90,[0,1,0])
          oval_extrusion(90,30,100);
     
    //Remove holes to mount MK5 base plate to arms of Z stage
    rotate(25,[0,0,1])
      {
      //Hole
      translate([+45.85/2,+32.5,-8]) cylinder(r=3/2,h=30,$fn=facets3mmhole);
      //captive nut slot
      translate([22.45,28.3,1.2]) rotate(35,[0,0,1]) cube([5.6,+15.3,3]);
      //Hole
      translate([+45.85/2,-32.5,-8]) cylinder(r=3/2,h=30,$fn=facets3mmhole);
      //captive nut slot
      translate([+45.85/2-5.6/2,-32.5-12.3+6.3/2,1.2]) cube([5.6,12.3,3]);
      //Hole
      translate([-34.5/2,+32.5,-8]) cylinder(r=3/2,h=30,$fn=facets3mmhole);
      //captive nut slot
      translate([-34.5/2-12.3+6.3/2,+32.5-5.6/2,1.2])  cube([12.3,5.6,3]);
      //Hole
      translate([-34.5/2,-32.5,-8]) cylinder(r=3/2,h=30,$fn=facets3mmhole);
      //captive nut slot
      translate([-34.5/2-12.3+6.3/2,-32.5-5.6/2,1.2])  cube([12.3,5.6,3]);
      }
    
    //clean up under extruder
    translate([20,4,-38-2.55])
      rotate(90,[1,0,0])
        rotate(90,[0,1,0])
          oval_extrusion(100,35.1,110);
    //bevel bottom (duplicated above)
    translate([20,73,-62])
      rotate(59.8,[1,0,0])
        rotate(90,[0,1,0])
          oval_extrusion(120,35.1,160);
    //Remove huge bevel under arm to main bearing block
    //(duplicated above)
    translate([22.6,73,-59.35])
      rotate(22.18,[0,1,0])
        rotate(0,[0,0,1])
          rotate(90,[1,0,0])
            oval_extrusion(140,35.1,160);
    //Remove tag on end of arm to main bearing block
    translate([-45,120,-2])
      translate([8.89-10,-50/2,-40.0])
        cube([20,50,20]);
    //Remove Y+ taper on arm to main bearing block
    translate([-45,120,-2])
      rotate(-12+5,[0,0,1])
        translate([70.825,+14,-(40+8+8)/2+0.1])
          oval_extrusion(77.85,10,40+8+8);
    }  // end of difference()

  //add in inner radii for looks and strength  
  rotate(25,[0,0,1])
    { 
    difference()
      {
      union()
        {
        translate([45.7/2+2.85,-27.5-0.02,-23+0.1])
          rotate(90,[0,0,1])
            radius(10,40-0.2,"Z");
        translate([45.7/2+2.85,+27.5+0.02,-23+0.1])
          rotate(180,[0,0,1])
            radius(10,40-0.2,"Z");
        }
      //Remove a chimney so hot air rising from the extruder
      //does not get trapped under the MK5 Base
      //duped above
      translate([17,0,-35.9]) cylinder(r1=1,r2=27.5,h=53,$fn=120);
      }
    }
   
  //Add in lift arm 
  difference()
    {
    union()
      {
      //main mody of lift support
      translate([44,115,-72]) cube([24,52,30]);
      //add lift support upper fillet
      translate([44,116,-51]) rotate(26.5,[1,0,0]) cube([24,20,40]);
      }
    //Remove slot for M8 lift nut
    //translate([44+24/2,157+2,-58]) cube([13+0.6,21,6.6+0.6],center=true);

    //remove "open on the bottom" hex for drive coupler    
    translate([44+24/2,155+2,-66.5]) rotate(30,[0,0,1])
      cylinder(r=(13.4/2)/sin(60),h=24,center=true,$fn=6);
    
    //Remove clearance for M8 lift rod
    translate([44+24/2,155+2,-72.5]) cylinder(r=10.5/2,h=31);
    //Knock off corners for looks
    translate([44,167,-72.5]) rotate(-90,[0,0,1]) radius(5,31,"Z");
    translate([44+24,167,-72.5]) rotate(180,[0,0,1]) radius(5,31,"Z");
    //Knock off lower corner under arm
    translate([44,115,-72]) radius(13.5,24,"X");
    //Give acccess to bearing nut and adjustment head. Durhk.
    translate([+85,120,-2])
      {
      translate([-32+7.97-2.5-8/2,+11,-48])
        rotate(90,[0,0,1])
          rotate(90,[1,0,0])
            cylinder(r=(5.7/2)/sin(60),h=28,center=true,$fn=6);
         
      rotate(45,[0,0,1])
        {
        //Remove back bearing axel bolt head recesses
        translate([-11,13+((30-3.97)/2)+8/2,-48])
          rotate(90,[1,0,0])
            cylinder(r=7.7/2,h=42,center=true);
        }
      }  
    } //end of difference()
  } // end of module Z_Stage()
//=======================================================================================  
module Z_Stage_Bearings()
  {
  color([0,0,1,1])
    {
    //Main support triple bearing sets, +90,-90,45
    translate([+85,120,-2])
      {
      //Bearings
      translate([0,0,-8]) triple_bearing_set();
      translate([0,0,-48]) mirror([0,0,1]) triple_bearing_set();
      }

    //Anti-rotation double bearing set
    translate([-45,120,-2])
      translate([0,0,-8]) double_bearing_set();
    
    //MK5 plate Mounting bolts 
    rotate(25,[0,0,1])
      {
      translate([+45.85/2,+32.5,22.2]) rotate(180,[1,0,0])
        bolt_3mm_socket_head_bolt_with_washer_and_nut(length=22);
      translate([+45.85/2,-32.5,22.2]) rotate(180,[1,0,0])
        bolt_3mm_socket_head_bolt_with_washer_and_nut(length=22);
      translate([-34.5/2,+32.5,22.2]) rotate(180,[1,0,0])
        bolt_3mm_socket_head_bolt_with_washer_and_nut(length=22);
      translate([-34.5/2,-32.5,22.2]) rotate(180,[1,0,0])
        bolt_3mm_socket_head_bolt_with_washer_and_nut(length=22);
      }
    } //end of color()
  }
//=======================================================================================  
module Z_guide_rod_clamp_12mm()
  {
  //Debug mounting hardware
  translate([+10,+10,0])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=16);
  translate([+10,-10,0])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=16);
  translate([-10,+10,0])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=16);
  translate([-10,-10,0])  %bolt_3mm_socket_head_bolt_with_washer_and_nut(length=16);

  //Debug clamping hardware
  //usable capture range is  length-4.22
  translate([-8,0,25])  rotate(90,[1,0,0]) %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=22,center=true, $fn=60);
  translate([+8,0,25])  rotate(90,[1,0,0]) %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=22,center=true, $fn=60);

  difference()
    {
    union()
      {
      //inserts into the top wood panel
      cylinder(r=11,h=5.1);
      //big block for bolts
      translate([0,0,5+(16-3.97-5)/2]) cube([36,36,16-3.97-5],center=true);
      //clamping positive parts
      translate([0,0,9.9]) cylinder(r=10,h=19.1);
      translate([0,0,9.9+19.1/2]) cube([22,22-4.22,19.1],center=true);
      }
    //remove guide rod hole
    translate([0,0,-0.5]) cylinder(r=12.2/2,h=30);
    
    //remove mounting holes
    translate([+10,+10,4.5]) cylinder(r=3/2,h=8,$fn=facets3mmhole);
    translate([+10,-10,4.5]) cylinder(r=3/2,h=8,$fn=facets3mmhole);
    translate([-10,+10,4.5]) cylinder(r=3/2,h=8,$fn=facets3mmhole);
    translate([-10,-10,4.5]) cylinder(r=3/2,h=8,$fn=facets3mmhole);
    
    //printable clearance above nuts
    translate([+10,+10,12.04])   cylinder(r=4,h=5);
    translate([+10,+10,12+5.03]) cylinder(r1=4,r2=1,h=5.3);
    translate([+10,-10,12.04])   cylinder(r=4,h=5);
    translate([+10,-10,12+5.03]) cylinder(r1=4,r2=1,h=5.3);
    translate([-10,+10,12.04])   cylinder(r=4,h=5);
    translate([-10,+10,12+5.03]) cylinder(r1=4,r2=1,h=5.3);
    translate([-10,-10,12.04])   cylinder(r=4,h=5);
    translate([-10,-10,12+5.03]) cylinder(r1=4,r2=1,h=5.3);
    
    //knock the corners off for looks
    translate([+18,+18,4.9]) rotate(-180,[0,0,1]) radius(8,16-3.97-5+0.2,"Z");    
    translate([+18,-18,4.9]) rotate(  90,[0,0,1]) radius(8,16-3.97-5+0.2,"Z");    
    translate([-18,+18,4.9]) rotate( -90,[0,0,1]) radius(8,16-3.97-5+0.2,"Z");    
    translate([-18,-18,4.9]) rotate(   0,[0,0,1]) radius(8,16-3.97-5+0.2,"Z");    

    //remove clamping gap
    translate([0,0,16-3.97+18/2]) cube([22.2,3,18],center=true);
    //radius at bottom of clamping gap
    translate([0,0,16-3.97]) rotate(90,[0,1,0])   
      capsule(length=22.2,radius=3/2,$fn=facets3mmcapsule);

    //Remove holes for clamping hardware
    translate([-8,0,25])  rotate(90,[1,0,0]) cylinder(r=3/2,h=22,center=true,$fn=facets3mmhole);
    translate([+8,0,25])  rotate(90,[1,0,0]) cylinder(r=3/2,h=22,center=true,$fn=facets3mmhole);
    }
  }
//=======================================================================================  
// Digi-Key 403-1037-ND (slightly higher torque)
// Standard MBI motor should work fine too.
module Z_Stepper_Motor()
  {
  //Motor Body
  color([0.2,0.2,0.2,1])
    translate([0,0,-40.4/2])
      linear_extrude(height = 40.4, center = true, convexity = 6, twist = 0)
        difference()
          {
          intersection()
            {
            square([42.67,42.67],center=true);
            circle(r=27,center=true);
            }
          translate([+30.99/2,+30.99/2]) circle(r=3/2,center=true,$fn=facets3mmhole);
          translate([+30.99/2,-30.99/2]) circle(r=3/2,center=true,$fn=facets3mmhole);
          translate([-30.99/2,+30.99/2]) circle(r=3/2,center=true,$fn=facets3mmhole);
          translate([-30.99/2,-30.99/2]) circle(r=3/2,center=true,$fn=facets3mmhole);
          }
  //Mounting Boss
  color([0.9,0.9,0.9,1]) translate([0,0,-0.1]) cylinder(r=22/2,h=2.03+0.1);
  //Shaft
  color([0.7,0.7,0.7,1]) cylinder(r=5/2,h=20.07);
  }
//=======================================================================================  
module Z_Motor_Mount_Bolts()
  {
   
      //debug hardware
      translate([-6.5,-2-31.5,19]) rotate(180,[1,0,0])
        %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=16,center=true);
      translate([+6.5,-2-31.5,19]) rotate(180,[1,0,0])
        %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=16,center=true);

        //debug hardware
     translate([-16.5-14.5,-2-8.8,37.5])  rotate(90,[1,0,0])
       %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=16,center=true, $fn=60);
     translate([+16.5,     -2-8.8,37.5])  rotate(90,[1,0,0])
       %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=16,center=true, $fn=60);
  }
//=======================================================================================  
module Z_Motor_Mount_Drill_Guide_Over()
  {
  translate([0,0,-263])
    difference()
      {
      union()
        {
        translate([43,105,5]) cube([57,34.9,10]);
        translate([85,120,-0.5]) cylinder(r=11,h=5.7);
        }
      translate([85,120,-0.6]) cylinder(r=8,h=15.7);
      translate([85+10,120+10,4.9]) cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
      translate([85+10,120-10,4.9]) cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
      translate([85-10,120+10,4.9]) cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
      translate([85-10,120-10,4.9]) cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
      translate([85-35.5,123.5,4.9]) cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
      translate([85-22.5,123.5,4.9]) cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
      translate([44+24/2,155+2,-283])
        translate([0,0,259.5])
          translate([4,-9,+26])
            rotate(90,[1,0,0])
              cylinder(r=5,h=20.3);
      }
   }
//=======================================================================================  
module Z_Motor_Mount_Drill_Guide_Under()
  {
  translate([0,0,-258])
    mirror([0,0,1])
      difference()
        {
        union()
          {
          translate([15,105,5]) cube([85,34.9,20]);
          translate([15,139,20]) cube([65,7,5]);
          translate([15,145.1,-20]) cube([65,6,45]);
          translate([85,120,-0.5]) cylinder(r=11,h=5.7);
          }
      
        translate([25,154.1,-12.5])
          rotate(90,[1,0,0])
           cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
        translate([72.5,154.1,-12.5])
          rotate(90,[1,0,0])
           cylinder(r=3/2,h=10.2,$fn=facets3mmhole);

        translate([48.5,147+7,-10+13.5]) 
          rotate(90,[0,1,0])
            rotate(90,[1,0,0])
              cylinder(r=33/2,h=12,$fn=180);
      
       translate([48.5-1.49,147+7,-8.25]) 
          rotate(35,[0,1,0])
            rotate(90,[1,0,0])
              translate([-6,-6,0]) 
                cube([12,12,12]);
       
       translate([48.5+1.49,147+7,-8.25]) 
          rotate(55,[0,1,0])
            rotate(90,[1,0,0])
              translate([-6,-6,0]) 
                cube([12,12,12]);
  
        translate([48.5,147+7,-10+13.5+33/4]) 
            rotate(90,[1,0,0])
              translate([-33/2,-16.5/2,0]) 
                cube([33,16.5,12]);

        translate([9,104,4]) cube([36,16,22]);
        translate([0,104,4]) cube([32,27.5,22]);


  
        translate([85,120,-0.6]) cylinder(r=8,h=25.7);
        translate([60,115,15]) oval_extrusion(22,8,25.7);
        translate([58,133,15]) oval_extrusion(22,8,25.7);
        translate([32,120,15]) oval_extrusion(26,23,25.7);
        translate([85+10,120+10,4.9]) cylinder(r=3/2,h=20.2,$fn=facets3mmhole);
        translate([85+10,120-10,4.9]) cylinder(r=3/2,h=20.2,$fn=facets3mmhole);
        translate([85-10,120+10,4.9]) cylinder(r=3/2,h=20.2,$fn=facets3mmhole);
        translate([85-10,120-10,4.9]) cylinder(r=3/2,h=20.2,$fn=facets3mmhole);
        translate([85-35.5,123.5,4.9]) cylinder(r=3/2,h=20.2,$fn=facets3mmhole);
        translate([85-22.5,123.5,4.9]) cylinder(r=3/2,h=20.2,$fn=facets3mmhole);
        translate([44+24/2,155+2,-283])
          translate([0,0,259.5])
            translate([4,-9,+26])
              rotate(90,[1,0,0])
                cylinder(r=5,h=20.3);
        }  //end difference()
  }        
//=======================================================================================  
module Z_Motor_Mount()
  {
  difference()
    {
    translate([0,0,5.5/2-1])
      linear_extrude(height = 5.5+2, center = true, convexity = 6, twist = 0)
        difference()
          {
          intersection()
            {
            //offset a bit to catch the inside bracket
            //offset a bit to catch the front edge of the outside bracket
            translate([-2.5,-1.5]) square([42.67+5,42.67+3],center=true);
            circle(r=27,center=true);
            }
          translate([+30.99/2,+30.99/2]) circle(r=3/2,center=true,$fn=facets3mmhole);
          translate([+30.99/2,-30.99/2]) circle(r=3/2,center=true,$fn=facets3mmhole);
          translate([-30.99/2,+30.99/2]) circle(r=3/2,center=true,$fn=facets3mmhole);
          translate([-30.99/2,-30.99/2]) circle(r=3/2,center=true,$fn=facets3mmhole);
          }
    //opening for mounting Boss
    translate([0,0,-2-0.1]) cylinder(r=22/2+0.1,h=7.5+0.2);
    //Counter-sink inside two holes that are under plywood
    translate([+30.99/2,-30.99/2,4.05]) cylinder(r=7/2,h=3.1,center=true);
    translate([-30.99/2,-30.99/2,4.05]) cylinder(r=7/2,h=3.1,center=true);
    }

  //debug motor mounting hardware
  //holes in the steppers appear to be about 5mm deep
  //translate([-30.99/2,+30.99/2,-7])
  //  cylinder(r=3,h=5);

  translate([-30.99/2,+30.99/2,5.5]) rotate(180,[1,0,0])
    %bolt_3mm_socket_head_bolt(length=12,center=true);
  translate([+30.99/2,+30.99/2,5.5]) rotate(180,[1,0,0])
    %bolt_3mm_socket_head_bolt(length=12,center=true);

  //holes in the steppers appear to be about 5mm deep
  //translate([-30.99/2,-30.99/2,-7])
  //  cylinder(r=3,h=5);
    
  translate([-30.99/2,-30.99/2,5.5-3]) rotate(180,[1,0,0])
    %bolt_3mm_socket_head_bolt(length=8,center=true);
  translate([+30.99/2,-30.99/2,5.5-3]) rotate(180,[1,0,0])
    %bolt_3mm_socket_head_bolt(length=8,center=true);
    
  difference()
    {
    rotate(90,[0,1,0])
      linear_extrude(height = 23, center = true, convexity = 6, twist = 0)
        difference()
          {
          translate([-12.5+2.5+1,  -2-25.5-0.2])      square([22,21],center=true);
          translate([-12.5+2.5+2.3,  -2-25-3-1.2])    square([10,6.5]);
          translate([-12.5+2.5-3.1,-2-41-2.3])        square([16,15]);
          translate([-12.5+2.5+2.4,  -2-25-1-0.2-2])  circle(r=5.5,center=true);
          }
      //Inner mounting holes   
      translate([-6.5,-2-31.5,17]) cylinder(r=3/2, h=10, center=true,$fn=facets3mmhole);
      translate([+6.5,-2-31.5,17]) cylinder(r=3/2, h=10, center=true,$fn=facets3mmhole);
      //debug hardware
      translate([-6.5,-2-31.5,19]) rotate(180,[1,0,0])
        %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=16,center=true);
      translate([+6.5,-2-31.5,19]) rotate(180,[1,0,0])
        %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=16,center=true);
      }
   difference()
     {
     union()
       {
       //rear outer mounting tab
       translate([+42.67/2-10.25,    -2-10+0.2,5.5]) cube([10.25,7,36.5]);
       //Beefy brace to support the motor
       translate([+42.67/2-10.25,  -5,5.4-0.1]) cube([10.25,17,28]);
       //front outer mounting tab
       translate([-42.67/2-15,         -2-10+0.2,0-2]) cube([25.25,7,36.5+5.5+2]);
       //Beefy brace to support the motor
       translate([-24,  -5,5.4-0.1]) cube([10.25,17,28]);
       }
     //Bevel to clear X stage rod clamp bolt head
     translate([-10.2,    -2-10+0.2-0.1,23.5]) rotate(-20,[0,1,0]) cube([10,7.2,20]);
     //Bevel to make bottom not look silly, while letting it print
     translate([-35.52,    -2-10+0.2-0.1,-6]) rotate(-20,[0,1,0]) cube([10,7.2,35]);

     //Bevel Beefy braces
     translate([+42.67/2-10.25-0.1,  -5+17,5.5]) rotate(31.145,[1,0,0]) cube([10.25+0.2,17,32.482]);
     translate([-24.1,  -5+17,5.5]) rotate(31.145,[1,0,0]) cube([10.25+0.2,17,32.482]);

     //Outer mounting tabs holes
     translate([-16.5-14.5,-8,37.5]) rotate(90,[1,0,0]) cylinder(r=3/2, h=10, center=true,$fn=facets3mmhole);
     translate([+16.5,     -8,37.5]) rotate(90,[1,0,0]) cylinder(r=3/2, h=10, center=true,$fn=facets3mmhole);
     //debug hardware
     translate([-16.5-14.5,-2-8.8,37.5])  rotate(90,[1,0,0])
       %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=16,center=true, $fn=60);
     translate([+16.5,     -2-8.8,37.5])  rotate(90,[1,0,0])
       %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=16,center=true, $fn=60);
     }
  }
//=======================================================================================  
module Z_M8_Drive_Screw()
  {
  cylinder(r=8/2,h=250);
  }
//=======================================================================================  
module M8_Nut()
  {
  difference()
    {
    cylinder(r=(13/2)/sin(60),h=6.6,center=true,$fn=6);
    cylinder(r=8/2,h=6.6+0.2,center=true);
    }
  }  
//=======================================================================================  
module M8_Coupler()
  {
  difference()
    {
    cylinder(r=(13/2)/sin(60),h=24,center=true,$fn=6);
    cylinder(r=8/2,h=24+0.2,center=true);
    }
  }  
//=======================================================================================  
module Z_Drive_Screw_Top_Thrust_Bearing_Drill_Guide()
  {
  difference()
    {
    union()
      {
      translate([30,145.1,-35]) cube([70,10,50]);
      translate([30,105,5]) cube([70,34.9,10]);
      translate([30,139.8,10.2]) cube([70,5.4,4.8]);
      translate([85,120,-0.5]) cylinder(r=11,h=5.7);
      }
    translate([29.9,104.9,4.9]) cube([40.1,30.1,10.2]);
    translate([83.1,145,-35.1]) cube([17,10.2,40.1]);
    translate([45,145,-35.1]) cube([20,10.2,40.1]);
    translate([85,120,-0.6]) cylinder(r=8,h=15.7);
  
    translate([85+10,120+10,4.9]) cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
    translate([85+10,120-10,4.9]) cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
    translate([85-10,120+10,4.9]) cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
    translate([85-10,120-10,4.9]) cylinder(r=3/2,h=10.2,$fn=facets3mmhole);

    translate([44+24/2,155+2,-283])
      translate([0,0,259.5])
        {
        translate([-18.5,-1.8,17.5]) rotate(90,[1,0,0])
          cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
        translate([+18.5,-1.8,17.5]) rotate(90,[1,0,0])
          cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
        translate([-18.5,-1.8,-1]) rotate(90,[1,0,0])
          cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
        translate([+18.5,-1.8,-1]) rotate(90,[1,0,0])
          cylinder(r=3/2,h=10.2,$fn=facets3mmhole);
        translate([4,-1.8,+26]) rotate(90,[1,0,0])
          cylinder(r=5,h=20.3,$fn=facets3mmhole);
        }
    }
  }
//=======================================================================================  
// This is for alignment and thrust tension. The threaded rod and entire Z-stage hangs
// from this.
module Z_Drive_Screw_Top_Thrust_Bearing()
  {
  difference()
    {
    translate([0,0,-0.1+10])
      linear_extrude(height = 7.1+20, center = true, convexity = 6, twist = 0)
        difference()
          {
          union()
            {
            circle(r=30/2);
            translate([0,-5-1]) square([30,10+2],center=true);
            translate([0,-7.5-1]) square([45,5+2],center=true);
            }
          circle(r=22/2);
          translate([0,-14.5]) square([36,5],center=true);
          }
    //cut away angle for a hanging bracket
    translate([-46/2,7,3.5]) rotate(31,[1,0,0]) cube([46,20,40]);
    translate([-46/2,7,3.5]) rotate(0,[1,0,0]) cube([46,10,10]);
    //remove mounting
    translate([-18.5,-4.5,17.5]) rotate(90,[1,0,0]) cylinder(r=3/2,h=8,$fn=facets3mmhole);
    translate([+18.5,-4.5,17.5]) rotate(90,[1,0,0]) cylinder(r=3/2,h=8,$fn=facets3mmhole);
    translate([-18.5,-4.5,-1]) rotate(90,[1,0,0]) cylinder(r=3/2,h=8,$fn=facets3mmhole);
    translate([+18.5,-4.5,-1]) rotate(90,[1,0,0]) cylinder(r=3/2,h=8,$fn=facets3mmhole);
    //clearance for bolt head on body
    translate([+4,-4.5,26]) rotate(90,[1,0,0]) cylinder(r=8/2,h=8,$fn=facets3mmhole);
    }

  //Stop/thrust ring below bearing
  translate([0,0,-5])
    linear_extrude(height = 3, center = true, convexity = 6, twist = 0)
      difference()
        {
        union()
          {
          circle(r=30/2);
          translate([0,-5-1]) square([30,10+2],center=true);
          translate([0,-7.5-1]) square([45,5+2],center=true);
          }
        circle(r=18/2);
        translate([0,-14.5]) square([36,5],center=true);
        }
   //debug hardware
   translate([-18.5,-11.0,17.5]) rotate(90,[1,0,0])
     %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=16,center=true);
   translate([+18.5,-11.0,17.5]) rotate(90,[1,0,0])
     %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=16,center=true);
   translate([-18.5,-11.0,-1]) rotate(90,[1,0,0])
     %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=16,center=true);
   translate([+18.5,-11.0,-1]) rotate(90,[1,0,0])
     %bolt_3mm_socket_head_bolt_with_washers_and_nut(length=16,center=true);

  zbearheight=0;
  translate([0,0,zbearheight+7/2+6.6/2]) %M8_Nut();
  translate([0,0,zbearheight]) color([0,0,1,1]) %bearing_608_8mm_x_22mm_x_7mm();
  translate([0,0,zbearheight-7/2-6.6/2]) %M8_Nut();
  }
//=======================================================================================  
module Z_Drive_Screw_Coupler(cross_blade_thick)
  {
  //debug screw head clearance cylinder
  //translate([0,0,zoffset]) %cylinder(r=11.5,h=30);
  difference()
    {
    //top half of main body of coupler
    translate([0,0,21.5-6]) cylinder(r=10,h=38-(21.5-6));

    rotate(45,[0,0,1])
      {
      //remove all but drive cog, assuming cross_blade_thick rubber cross
      translate([+cross_blade_thick-(11+cross_blade_thick)/2,+cross_blade_thick-(11+cross_blade_thick)/2,18])
        cube([11+cross_blade_thick,11+cross_blade_thick,7],center=true);
      translate([-cross_blade_thick+(11+cross_blade_thick)/2,-cross_blade_thick+(11+cross_blade_thick)/2,18])
        cube([11+cross_blade_thick,11+cross_blade_thick,7],center=true);
      //Make it so the inside corner of the rubber can be a little rounded
      translate([+cross_blade_thick,-cross_blade_thick,15.5])
        rotate(-90,[0,0,1]) radius(2,6-0.1,"Z",$fn=facetsSmallRadii);
      translate([-cross_blade_thick,+cross_blade_thick,15.5])
        rotate(+90,[0,0,1]) radius(2,6-0.1,"Z",$fn=facetsSmallRadii);
      }    
    
    //hole for drive screw (8mm threads are slightly less than 8mm)
    translate([0,0,8+16]) cylinder(r=4,h=14.5);
    //Remove slot for upper clamp
    translate([-22/2,-2/2,8+16]) cube([22,2,14.5]);
    //radius in bottom
    translate([-22/2,0,8+16]) rotate(90,[0,1,0]) cylinder(r=2/2,h=22);
    //Remove holes for upper clamping bolts
    translate([+6,5,8+25]) rotate(90,[1,0,0]) cylinder(r=3/2,h=11,$fn=facets3mmhole);
    translate([-6,5,8+25]) rotate(90,[1,0,0]) cylinder(r=3/2,h=11,$fn=facets3mmhole);
    //Remove holes for nuts of upper clamping bolts
    translate([-6,-4.1-6,8+25]) rotate(-90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=6,$fn=6);
    translate([+6,+4.1,8+25]) rotate(-90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=6,$fn=6);
    //Remove holes for heads of upper clamping bolts
    translate([+6,-4.4,8+25]) rotate(+90,[1,0,0]) cylinder(r=(5.7/2),h=6);
    translate([-6,+4.4,8+25]) rotate(-90,[1,0,0]) cylinder(r=(5.7/2),h=6);
   }
  
  //Debug Hardware
  //usable capture range is  length-3.5
  translate([-6,4.4,8+25]) rotate(90,[1,0,0])
    %bolt_3mm_socket_head_bolt_with_nut(length=12);
  translate([+6,-4.4,8+25]) rotate(-90,[1,0,0])
    %bolt_3mm_socket_head_bolt_with_nut(length=12);
  }
//=======================================================================================  
module Z_Motor_Coupler(cross_blade_thick)
  {
  //debug screw head clearance cylinder
  //translate([0,0,zoffset]) %cylinder(r=11.5,h=30);
  difference()
    {
    //bottom half of main body of coupler
    cylinder(r=10,h=14.5+6);

    rotate(45,[0,0,1])
      {
      //remove all but drive cog, assuming cross_blade_thick rubber cross
      translate([+cross_blade_thick-(11+cross_blade_thick)/2,+cross_blade_thick-(11+cross_blade_thick)/2,18])
        cube([11+cross_blade_thick,11+cross_blade_thick,7],center=true);
      translate([-cross_blade_thick+(11+cross_blade_thick)/2,-cross_blade_thick+(11+cross_blade_thick)/2,18])
        cube([11+cross_blade_thick,11+cross_blade_thick,7],center=true);
      //Make it so the inside corner of the rubber can be a little rounded
      translate([+cross_blade_thick,-cross_blade_thick,14.6])
        rotate(-90,[0,0,1]) radius(2,6-0.1,"Z",$fn=facetsSmallRadii);
      translate([-cross_blade_thick,+cross_blade_thick,14.6])
        rotate(+90,[0,0,1]) radius(2,6-0.1,"Z",$fn=facetsSmallRadii);
      }        
    
    //hole for motor shaft
    translate([0,0,-0.5]) cylinder(r=2.5+0.1,h=13);
    //Remove slot for lower clamp
    translate([-22/2,-1.5/2,-0.5]) cube([22,1.5,13]);
   
    //radius in top
    translate([-22/2,0,12.5]) rotate(90,[0,1,0]) cylinder(r=1.5/2,h=22);
    //Remove holes for lower clamping bolts
    translate([+4.5,5,6]) rotate(90,[1,0,0]) cylinder(r=3/2,h=11,$fn=facets3mmhole);
    translate([-4.5,5,6]) rotate(90,[1,0,0]) cylinder(r=3/2,h=11,$fn=facets3mmhole);
    //Remove holes for nuts of lower clamping bolts
    translate([+4.5,-4.1,6]) rotate(+90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=6,$fn=6);
    translate([-4.5,+4.1,6]) rotate(-90,[1,0,0]) cylinder(r=(5.7/2)/sin(60),h=6,$fn=6);
    //Remove holes for heads of lower clamping bolts
    translate([-4.5,-4.4-6,6]) rotate(-90,[1,0,0]) cylinder(r=(5.7/2),h=6);
    translate([+4.5,+4.4,6]) rotate(-90,[1,0,0]) cylinder(r=(5.7/2),h=6);
    }
  
  //Debug Hardware
  //usable capture range is  length-3.5
  translate([+4.5,4.4,6]) rotate(90,[1,0,0])
    %bolt_3mm_socket_head_bolt_with_nut(length=12);
  translate([-4.5,-4.4,6]) rotate(-90,[1,0,0])
    %bolt_3mm_socket_head_bolt_with_nut(length=12);
  }
//=======================================================================================  
module Z_Drive_Coupling_Rubber_Star(cross_blade_thick)
  {
  translate([0,0,18]) cube([20,5,7],center=true);
  translate([0,0,18]) cube([5,20,7],center=true);
  //Make the corners rounderful
  translate([+cross_blade_thick,+cross_blade_thick,18-(7-0.2)/2])
    radius(2,7-0.2,"Z",$fn=facetsSmallRadii);
  translate([+cross_blade_thick,-cross_blade_thick,18-(7-0.2)/2])
    rotate(-90,[0,0,1])
      radius(2,7-0.2,"Z",$fn=facetsSmallRadii);  
  translate([-cross_blade_thick,+cross_blade_thick,18-(7-0.2)/2])
    rotate(90,[0,0,1])
      radius(2,7-0.2,"Z",$fn=facetsSmallRadii);
  translate([-cross_blade_thick,-cross_blade_thick,18-(7-0.2)/2])
    rotate(180,[0,0,1])
      radius(2,7-0.2,"Z",$fn=facetsSmallRadii);  
  }
//=======================================================================================  
module Z_Drive_Screw_Coupler_Assembly()
  {
  cross_blade_thick=5/2;
  color([0,0,1,0.8]) rotate(+45,[0,0,1]) Z_Drive_Screw_Coupler(cross_blade_thick);
  color([1,0,1,0.8]) Z_Drive_Coupling_Rubber_Star(cross_blade_thick);
  color([1,0,0,0.8]) rotate(-45,[0,0,1]) Z_Motor_Coupler(cross_blade_thick);
  }
//=======================================================================================  
// VISUALIZATION SECTION
if(ftrue)
  {
  rotate(-90,[0,0,1]) %CupCakeWood(); 
  }

if(ftrue)
  {
  //12mm x 13" linear guide
  translate([+85,120,-299]) guide_rod_12mm_x_13in();
  translate([-45,120,-299]) guide_rod_12mm_x_13in();
  color([0,1,1,1])
    {
    //Top linear guide rod supports
    translate([+85,120,0]) rotate(-90,[0,0,1]) Z_guide_rod_clamp_12mm();
    translate([-45,120,0]) rotate(+90,[0,0,1]) Z_guide_rod_clamp_12mm();
    //Bottom linear guide rod supports
    translate([+85,120,-263]) rotate(+90,[0,0,1]) Z_guide_rod_clamp_12mm();
    translate([-45,120,-263]) rotate(-90,[0,0,1]) Z_guide_rod_clamp_12mm();
    }
  }


if(ftrue) color([0,1,1,0.5])
  {
  translate([+35,+140,-235.5]) rotate(90,[1,0,0])
    X_Guide_Rod_Clamp_8mm();  
  translate([+35,-140,-235.5]) rotate(-90,[1,0,0])
    X_Guide_Rod_Clamp_8mm();  
  translate([-80,+140,-235.5]) rotate(90,[1,0,0])
    X_Guide_Rod_Clamp_8mm();  
  translate([-80,-140,-235.5]) rotate(-90,[1,0,0])
    X_Guide_Rod_Clamp_8mm();  
  }

  
//Z of 0 to -112
zoffset=0; //upper limit
//zoffset=-112; //lower limit
if(true)
  {
  translate([0,0,zoffset])
    { 
    //Z_Stage_Bearings();
    //You can enable Z_Stage() _OR_ pusher_and_extruder() BUT NOT BOTH
    //OpenSCAD throws the "WARNING: Normalized tree has N elements!"
    //Error
    //Patch is to use render() on the overly complex Z stage
    color([0.75,0,0.75,1])
      //render()
        %Z_Stage();
    //Z_Stage_Verify_From_STL();
    //Z_Stage_Alignment_Pins();
    //rotate(25,[0,0,1]) translate([0,0,17]) render() pusher_and_extruder();
    //rotate(25,[0,0,1]) translate([0,0,17]) MK5_Base_Plate();
    }
  }   
 
if(true)
  {  
  //Z_Drive_Screw_Top_Thrust_Bearing_Drill_Guide();
  //Z_Motor_Mount_Drill_Guide_Over();
  //Z_Motor_Mount_Drill_Guide_Under();
  translate([44+24/2,155+2,-283])
   {
   color([0,1,0,1]) translate([0,0,259.5]) Z_Drive_Screw_Top_Thrust_Bearing();
   //color([1,0,1,1]) rotate(360/12,[0,0,1]) translate([0,0,225+zoffset]) M8_Nut();
   color([0,0,1,1]) rotate(360/12,[0,0,1]) translate([0,0,216.5+zoffset]) M8_Coupler();

   color([1,0,0,0.5]) translate([0,0,32.5-2]) Z_M8_Drive_Screw();
   translate([0,0,8.0-2])  Z_Drive_Screw_Coupler_Assembly($fn=60);
   color([0,1,0,1]) Z_Motor_Mount();
   translate([0,0,-2]) Z_Stepper_Motor();
   }
 }
//=======================================================================================  
// BUILD SECTION 
// I like to use a large value for "$fn". This makes the STL export slow, creating
// large STL files and makeinf skeinforge slow. My theory is that I want the part
// limited by the step and layer reslution of the printer, as opposed to limiting
// the resoultion by how fast my PC is or how long I am willing to wait for
// skeinforge.
// If you do not like that, feel free to make the facets smaller and re-save the STL.
//---------------------------------------------------------------------------------------
  //Scratch for chopping up the arm

  //90x90x100 practical build volume
  //Plate 1 (intersection)
  //Z_Stage();
  //translate([-50,101,-102]) rotate(0,[0,0,1]) %cube([90,90,100]);

  //Alignment pins to align Plate 1 and Plate 2
  //translate([48.25-16.5/2,115,-10]) rotate(90,[0,1,0])capsule(15,3/2,$fn=facets3mmcapsule);
  //translate([48.25-16.5/2,115,-40]) rotate(90,[0,1,0])capsule(15,3/2,$fn=facets3mmcapsule);
  //translate([48.25-16.5/2,105,-12]) rotate(90,[0,1,0])capsule(15,3/2,$fn=facets3mmcapsule);
  //translate([48.25-16.5/2,105,-40]) rotate(90,[0,1,0])capsule(15,3/2,$fn=facets3mmcapsule);

  //Plate 2 (intersection)
  //Z_Stage();
  //translate([+40,101,-102]) rotate(0,[0,0,1]) %cube([90,90,100]);

  //Alignment pins to align Plate 1 and Plate 3
  //translate([3,109.25-16.5/2,-7]) rotate(90,[1,0,0])capsule(15,3/2,$fn=facets3mmcapsule);
  //translate([3,109.25-16.5/2,-25]) rotate(90,[1,0,0])capsule(15,3/2,$fn=facets3mmcapsule);
  //translate([33,109.25-16.5/2,-7]) rotate(90,[1,0,0])capsule(15,3/2,$fn=facets3mmcapsule);
  //translate([33,109.25-16.5/2,-35]) rotate(90,[1,0,0])capsule(15,3/2,$fn=facets3mmcapsule);

  //Alignment pins to align Plate 2 and Plate 3
  //translate([46,109.25-16.5/2,-7]) rotate(90,[1,0,0])capsule(15,3/2,$fn=facets3mmcapsule);
  //translate([46,109.25-16.5/2,-45]) rotate(90,[1,0,0])capsule(15,3/2,$fn=facets3mmcapsule);
  //translate([79,109.25-16.5/2,-7]) rotate(90,[1,0,0])capsule(15,3/2,$fn=facets3mmcapsule);
  //translate([79,109.25-16.5/2,-45]) rotate(90,[1,0,0])capsule(15,3/2,$fn=facets3mmcapsule);
  
  //Plate 3  (difference)
  //Z_Stage();
  //translate([-50,101,-102]) rotate(0,[0,0,1]) %cube([180,90,100]);
  //translate([-50,-48,-50]) rotate(0,[0,0,1]) %cube([180,90,100]);
  
  //Alignment pins to align Plate 3 and Plate 4
  //translate([55,50-16.5/2,+10]) rotate(90,[1,0,0])capsule(15,3/2,$fn=facets3mmcapsule);
  //translate([15,50-16.5/2,+10]) rotate(90,[1,0,0])capsule(15,3/2,$fn=facets3mmcapsule);
  //translate([55,50-16.5/2,-18]) rotate(90,[1,0,0])capsule(15,3/2,$fn=facets3mmcapsule);
  //translate([10,50-16.5/2,-18]) rotate(90,[1,0,0])capsule(15,3/2,$fn=facets3mmcapsule);

  //Plate 4  (intersection)
  //Z_Stage();
  //translate([-50,-48,-50]) rotate(0,[0,0,1]) %cube([180,90,100]);

//---------------------------------------------------------------------------------------
// Z Stage, plate 1
//facetsZP1=24;    //Debug
//facetsZP1=120; // , STL = 2.0MB
facetsZP1=360; // , STL = 3.7MB
if(ftrue)
  {
  //build platform for debug
  color([0.5,0.5,0.5,0.1]) translate([-50,-50,-1.01]) %cube([100,100,1]);

  translate([1,+94,-2])
    rotate(180,[1,0,0])
      render() 
        intersection()
          {
          //90x90x100 practical build volume
          translate([-50,101,-102]) rotate(0,[0,0,1]) cube([90,90,100]);
          difference()
            {
            Z_Stage($fn=facetsZP1);
            Z_Stage_Alignment_Pins($fn=12);
            }
          }

  //Drill guide
  color([0,1,0,0.5])
    translate([-58,-107,283])
      Z_Motor_Mount_Drill_Guide_Under($fn=facetsZP1);
  }
//---------------------------------------------------------------------------------------
// Z Stage, plate 2
//facetsZP2=24;    // Debug
//facetsZP2=120; // Total rendering time: 0 hours,  8 minutes, 29 seconds, STL = 2.1MB
facetsZP2=360; // Total rendering time: 0 hours, 15 minutes, 15 seconds, STL = 3.8MB
if(ftrue)
  {
  //build platform for debug
  color([0.5,0.5,0.5,0.1]) translate([-50,-50,-1.01]) %cube([100,100,1]);

  
  translate([-70,+130,-2])
    rotate(180,[1,0,0])
      render() 
        intersection()
          {
          //90x90x100 practical build volume
          translate([+40,101,-102]) rotate(0,[0,0,1]) cube([90,90,100]);
          difference()
            {
            Z_Stage($fn=facetsZP2);
            Z_Stage_Alignment_Pins($fn=12);
            }
          }
  //Build support under lift arm overhang
  difference()
    {
    for(i=[0:13]) rotate(90,[0,0,1])
      color([0,0,0.75,0.25])
        {
        translate([-3/2+  (i-14)*2.5-1.75,1,0]) cube([3,  26,35]);
        translate([-3/2+  (i-14)*2.5-1.75+3/2,1+26,34.9]) isosceles_triangle(3,26,5.43);
        }
    translate([-2,-4,-0.1]) cylinder(r=3,h=40.2,$fn=facets3mmhole);
    }

  //Build support under adjustment block
  difference()
    {
    for(i=[0:5]) rotate(45,[0,0,1])
      color([0,0,0.75,0.25])
        {
        translate([4,(i-14)*2.5+14.3,0]) cube([  30,3,10]);
        translate([4,(i-14)*2.5+14.3+3/2,9.9]) rotate(90,[0,0,1]) isosceles_triangle(3,30,4.43);
        }
    translate([15,10,-0.1]) cylinder(r=13/2,h=14.5,$fn=facets3mmhole);
    translate([20,11.5,-0.1]) cube([12,12,14.2]);
    translate([1.5,-7,-0.1]) cube([12,12,14.2]);
    }
  }
//---------------------------------------------------------------------------------------
// Z Stage, plate 3
//facetsZP4=24;    // Debug
//facetsZP3=120; // Total rendering time: 0 hours,  7 minutes, 44 seconds, STL = 1.1MB
facetsZP3=360; // Total rendering time: 0 hours, 13 minutes, 31 seconds, STL = 1.2MB
if(ftrue)
  {
  //build platform for debug
  color([0.5,0.5,0.5,0.1]) translate([-50,-50,-1.01]) %cube([100,100,1]);
  
  translate([20,-81,+47.6466])
    rotate(+18.65,[1,0,0])
      rotate(90,[0,1,0])
        render() 
          difference()
            {
            Z_Stage($fn=facetsZP3);
            Z_Stage_Alignment_Pins($fn=12);
            translate([-50,101,-100]) cube([180,90,100]);
            translate([-50,-48, -50]) cube([180,90,100]);
            }
  }  
//---------------------------------------------------------------------------------------
// Z Stage, plate 4
//facetsZP4=24;    // Debug
//facetsZP4=120; // Total rendering time: 0 hours, 7 minutes, 10 seconds, STL = 0.7MB
facetsZP4=360; // Total rendering time: 0 hours, 13 minutes, 7 seconds, STL = 1.0MB
if(ftrue)
  {
  //build platform for debug
  color([0.5,0.5,0.5,0.1]) translate([-50,-50,-1.01]) %cube([100,100,1]);
  
  translate([28,0,17])
    rotate(+25,[0,0,1])
      rotate(180,[0,1,0])
        render() 
          intersection()
            {
            difference()
              {
              Z_Stage($fn=facetsZP4);
              Z_Stage_Alignment_Pins($fn=12);
              }
            translate([-50,-48,-50]) rotate(0,[0,0,1]) cube([180,90,100]);
            }
  }  
//---------------------------------------------------------------------------------------
// Plate 5: Z motor mount and thrust bearing mount
//facetsZmm=24;    // Debug
//facetsZmm=120; // Total rendering time: 0 hours, 1 minutes, 57 seconds, STL = 2.4MB
facetsZmm=360; // Total rendering time: 0 hours, 5 minutes, 15 seconds, STL = 5.9MB
cross_blade_thick=5/2;
if(ftrue)
  {
  //build platform for debug
  color([0.5,0.5,0.5,0.1]) translate([-50,-50,-1.01]) %cube([100,100,1]);

  //Coupler. The "star" is to be used as a pattern, cut a real one out of rubber.
  color([0,0,1,0.8]) translate([-32,+10,38]) rotate(180,[1,0,0]) Z_Drive_Screw_Coupler(cross_blade_thick,$fn=facetsZmm);
  color([1,0.1,0.5,0.8]) translate([+35,-35,-14.5]) rotate(60,[0,0,1]) Z_Drive_Coupling_Rubber_Star(cross_blade_thick,$fn=facetsZmm);
  color([1,0.1,0.5,0.8]) translate([+17,-35,-14.5]) rotate(60,[0,0,1]) Z_Drive_Coupling_Rubber_Star(cross_blade_thick,$fn=facetsZmm);
  color([1,0,0,0.8]) translate([-32,+35,0]) Z_Motor_Coupler(cross_blade_thick,$fn=facetsZmm);
  
  
  color([0.75,0,0.75,1])
    {
    translate([20,20,2])
      {
      Z_Motor_Mount($fn=facetsZmm);
      //Build support under overhang
      for(i=[0:9])
        color([0,0,0.75,0.25])
          {
          translate([-3/2+(i-4.5)*2.5,-39,-2]) cube([3,11,10]);
          translate([+(i-4.5)*2.5,-39+11.25,7.8]) isosceles_triangle(3,11.25,5.43);          
          }
      }
    translate([-20,-20,6.5])
      Z_Drive_Screw_Top_Thrust_Bearing($fn=facetsZmm);
    }
  }
//---------------------------------------------------------------------------------------
// Plate 6: Four of 8mm X rod clamps
//facets8cl=24;    // Debug
//facets8cl=120; // Total rendering time: 0 hours, 1 minutes, 13 seconds, STL = 2.1MB
facets8cl=360; // Total rendering time: 0 hours, 2 minutes, 22 seconds, STL = 3.8MB
if(ftrue)
  {
  //build platform for debug
  color([0.5,0.5,0.5,0.1]) translate([-50,-50,-1.01]) %cube([100,100,1]);

  color([0,1,1,1])
    {
    translate([+23,+23,0]) X_Guide_Rod_Clamp_8mm($fn=facets8cl);
    translate([+23,-23,0]) X_Guide_Rod_Clamp_8mm($fn=facets8cl);
    translate([-23,+23,0]) X_Guide_Rod_Clamp_8mm($fn=facets8cl);
    translate([-23,-23,0]) X_Guide_Rod_Clamp_8mm($fn=facets8cl);
    }
  }
//---------------------------------------------------------------------------------------
// Plate 7: Four of 12mm Z rod clamps
//facets12cl=24;    // Debug
//facets12cl=120; // Total rendering time: 0 hours, 4 minutes, 8 seconds, STL = 6.2MB
facets12cl=360; // Total rendering time: 0 hours, 9 minutes, 9 seconds, STL = 11.7MB
if(ftrue)
  {
  //build platform for debug
  color([0.5,0.5,0.5,0.1]) translate([-50,-50,-1.01]) %cube([100,100,1]);

  color([1,0.5,0,1])
    {
    translate([+23,+23,0])
      {
      Z_guide_rod_clamp_12mm($fn=facets12cl);
      render() 
      rotate(45,[0,0,1]) outer_cylinder_build_support_framework(22,54,5,30,$fn=4);
      }
    translate([+23,-23,0])
      {
      Z_guide_rod_clamp_12mm($fn=facets12cl);
      render() 
      rotate(45,[0,0,1]) outer_cylinder_build_support_framework(22,54,5,30,$fn=4);
      }
    translate([-23,+23,0])
      {
      Z_guide_rod_clamp_12mm($fn=facets12cl);
      render()
      rotate(45,[0,0,1]) outer_cylinder_build_support_framework(22,54,5,30,$fn=4);
      }
    translate([-23,-23,0])
      {
      Z_guide_rod_clamp_12mm($fn=facets12cl);
      render() 
      rotate(45,[0,0,1]) outer_cylinder_build_support_framework(22,54,5,30,$fn=4);
      }
    }
  }
//=======================================================================================  
// Plate 8: Drill guides. You need these to make sure the drive screw
// is lined up with the linear guides. Don't skimp this late in the game.
//facets8dg=24;    // Debug
//facets8dg=120; // , STL = 0.8MB
facets8dg=360; // , STL = 1.7MB
if(ftrue)
  {
  //build platform for debug
  color([0.5,0.5,0.5,0.1]) translate([-50,-50,-1.01]) %cube([100,100,1]);

  color([1,0,0,1])
    rotate(90,[0,0,1])
      translate([-59,135,-248])
        rotate(180,[1,0,0])
      render() 
          Z_Motor_Mount_Drill_Guide_Over($fn=facets8dg);

  color([0,0,1,1])
    translate([-60,+114,15])
      rotate(180,[1,0,0])
      render() 
        Z_Drive_Screw_Top_Thrust_Bearing_Drill_Guide($fn=facets8dg);
  }
//=======================================================================================  
























