//-- Mini-Skybot rear piece
//-- (c) Juan Gonzalez-Gomez (Obijuan) Nov-2010
//-- GPL License

use <futaba_U_union_2.scad>
use <U_piece.scad>


//-- Nut
nut_h = 2.5;
nut_radius = 6.4/2;
nut_drill = 3.1;

//-- U-piece main parameters
w=10;
l = 47;
h=24;
drill=3;
thick=3.5;
bottom_thick=3.5;

//-- Other parameters
servo_with=41;
y1_dd = 30;  //-- y1 drill distance

//-- Ear dimensions
ear_x = servo_with -y1_dd;
ear_y = y1_dd + 2*(nut_radius+4);

//-- drills location
d1_x = ear_x/2 + w/2;
d1_y = -l/2 + (l-y1_dd)/2; 

d2_x = d1_x;
d2_y = d1_y + y1_dd;

//-- ultrasounds
ultrasound_hole = 16.5;


module U_front_skycube() {

  difference() {
	
   union() {
	  
	     //-- Main part: U-piece
	     Futaba_U_union2(thick=thick,bottom_thick=bottom_thick,h=h);
	
	     //-- Ear 1
         translate([d1_x,0,0])
	      cube(size=[ear_x-0.01,ear_y,bottom_thick], center=true);
	
	     //-- Ear 2
	     *translate([ear2_center_x-0.01, ear2_center_y,0])
	       cube(size=[ear_x,ear_y,bottom_thick], center=true);
	
	  }
	
	  //-- Drill 1
	  translate([d1_x, d1_y,-10])
		    cylinder(r=drill/2,h=20,$fn=50);
	
	  //-- Drill 2
	  translate([d2_x, d2_y,-10])
		    cylinder(r=drill/2,h=20,$fn=50);
	
	  //-- Captive nut 1
	  translate([d1_x, d1_y,bottom_thick/2-nut_h])
	    cylinder(r=nut_radius,h=20,$fn=6);
	
	  //-- Captive nut 2
	  translate([d2_x, d2_y,bottom_thick/2-nut_h])
	    cylinder(r=nut_radius,h=20,$fn=6);

  }

}


//-- Render the piece
 //translate([10,0,0])
 // rotate([0,-90,0])

  union() {
    U_front_skycube();

    translate([-10+0.01,0,0])
    U_piece(l=47, w=10, h=h, thick=thick, bottom_thick=bottom_thick);

    //-- Piece for the ultrasounds
    difference() {
      translate([-15-3/2+0.01,0,h/2])
        cube([3,47+thick*2,h+bottom_thick],center=true);

       //-- Big holes for the ultrasounds
       translate([0,-47/4,bottom_thick/2+h/2])
       rotate([0,90,0])
       cylinder(r=ultrasound_hole/2, h=50, center=true);

       translate([0,47/4,bottom_thick/2+h/2])
       rotate([0,90,0])
       cylinder(r=ultrasound_hole/2, h=50, center=true);

       //-- Drills
        translate([0,47/4-8,bottom_thick/2+h/2+9])
        rotate([0,90,0])
        cylinder(r=3/2, h=50, center=true,$fn=50);

        translate([0,47/4+7,bottom_thick/2+h/2-9])
        rotate([0,90,0])
        cylinder(r=3/2, h=50, center=true,$fn=50);

        translate([0,-47/4-8,bottom_thick/2+h/2+9])
        rotate([0,90,0])
        cylinder(r=3/2, h=50, center=true,$fn=50);

        translate([0,-47/4+7,bottom_thick/2+h/2-9])
        rotate([0,90,0])
        cylinder(r=3/2, h=50, center=true,$fn=50);
      
    }
   
  }





