
//-- (c) Juan Gonzalez-Gomez (Obijuan) Nov-2010
//-- GPL License

use <Mini-skybot-batery-support.scad>

nuts=true;

//-- Legs
l_w = 10;  //-- Legs width
l_thick=3.5;
l_l = 33;  //-- Legs interior length

//-- Base
base_length = 38.5;
base_thick=3;
base_w = 35;

//-- Nut
nut_h = 2.5;
nut_radius = 6.4/2;
nut_drill = 3.1;

//-- Drills
drill=3;
xd=5.2;
zd=l_w-4.1;
dd=9.6;


module leg(nuts=true) 
{

  difference() {
    //-- left leg
    cube([l_l,l_thick,l_w]);

    translate([xd,0,zd])
    rotate([90,0,0])
    cylinder(r=drill/2, h=20,$fn=50, center=true);

    translate([xd+dd,0,zd])
    rotate([90,0,0])
    cylinder(r=drill/2, h=20,$fn=50, center=true);

    if (nuts) {
      translate([xd,0,zd])
      rotate([90,0,0])
      rotate([0,0,90])
      cylinder(r=nut_radius, h=nut_h*2,$fn=6, center=true);

      translate([xd+dd,0,zd])
      rotate([90,0,0])
      rotate([0,0,90])
      cylinder(r=nut_radius, h=nut_h*2,$fn=6, center=true);
    }
  }
}

module base() 
{
  l=base_length/sqrt(2);
  difference() {
    translate([0,0,base_w/2])
    cube([base_thick,base_length+2*l_thick,base_w],center=true);
    rotate([45,0,0])
    cube([2*(l_l+10),l,l],center=true);
  }
}

translate([-l_l/2,0,0])
union() {
  translate([0,base_length/2,0])
  leg();

  translate([0,-base_length/2,0])
  mirror([0,1,0]) leg();

  //-- Base
  translate([base_thick/2+l_l,0,0])
  base();
}


