//-- Mini-Skybot rear piece
//-- (c) Juan Gonzalez-Gomez (Obijuan) Nov-2010
//-- GPL License

use <futaba_U_union_2.scad>


//-- Nut
nut_h = 2.5;
nut_radius = 6.4/2;
nut_drill = 3.1;

//-- U-piece main parameters
w=10;
l = 47;
drill=3;
thick=3.5;
bottom_thick=3.5;

//-- Other parameters
servo_with=41;
y1_dd = 30;  //-- y1 drill distance

//-- Ear dimensions
ear_x = servo_with -y1_dd;
ear_y = y1_dd + 2*(nut_radius+4);

//-- drills location
d1_x = ear_x/2 + w/2;
d1_y = -l/2 + (l-y1_dd)/2; 

d2_x = d1_x;
d2_y = d1_y + y1_dd;

//-- rounded part parameters
w2 = sqrt(2)*w/2;
h = w2*(1-sqrt(2)/2);
ht=30;

module rounded_end()
{
  rotate([90,0,0])
  translate([0,-w/2,0])
  difference() {
    cylinder(r=w2,h=thick,$fn=50, center=true);

    translate([0,-h,0])
    cube([2*w2,2*w2,thick], center=true);
  }
}



module U_rear_skycube() {

  difference() {
	
   union() {
	  
	     //-- Main part: U-piece
	     Futaba_U_union2(h=ht-h, l=l, w=w, thick=thick,bottom_thick=bottom_thick);
	
	     //-- Ear 1
         translate([d1_x,0,0])
	      cube(size=[ear_x-0.01,ear_y,bottom_thick], center=true);

        translate([0.01,47/2+thick/2-0.01,ht+thick/2-h-0.01])
        rounded_end();

        translate([0.01,-47/2-thick/2-0.01,ht+thick/2-h-0.01])
        rounded_end();
	
	  }
	
	  //-- Drill 1
	  translate([d1_x, d1_y,-10])
		    cylinder(r=drill/2,h=20,$fn=50);
	
	  //-- Drill 2
	  translate([d2_x, d2_y,-10])
		    cylinder(r=drill/2,h=20,$fn=50);
	
	  //-- Captive nut 1
	  translate([d1_x, d1_y,bottom_thick/2-nut_h])
	    cylinder(r=nut_radius,h=20,$fn=6);
	
	  //-- Captive nut 2
	  translate([d2_x, d2_y,bottom_thick/2-nut_h])
	    cylinder(r=nut_radius,h=20,$fn=6);

  }

}


//-- Render the piece
 translate([20,0,0])
  rotate([0,-90,0])
    U_rear_skycube();

