diameter=13;
thick=3.5;
drill=3.2;

use <futaba_U_union_2.scad>

w=10;
w2=12;
thick_side=3.5;
h=22;
l=29;
drill=3;
nuts=true;
radius=w2+5;

module side() {

//-- Nut
  nut_h = 2.5;
  nut_radius = 6.4/2;
  nut_drill = 3.1;

  //-- Parameters for the Futaba 3003 holes
  
  //-- Distance from one side
  xd=4.1;

  //-- Distance between drills
  dd=9.6;

difference() {
  cube([thick_side,w,h],center=true);

  translate([0,w/2-xd,dd/2])
  rotate([0,90,0])
  cylinder(r=drill/2, h=20, $fn=50, center=true);

  translate([0,w/2-xd,-dd/2])
  rotate([0,90,0])
  cylinder(r=drill/2, h=20, $fn=50, center=true);

  if (nuts==true) {
    translate([-10/2-thick_side/2+nut_h,w/2-xd,dd/2])
    rotate([0,90,0])
    rotate([0,0,90])
    cylinder(r=nut_radius, h=10,center=true,$fn=6);

    translate([-10/2-thick_side/2+nut_h,w/2-xd,-dd/2])
    rotate([0,90,0])
    rotate([0,0,90])
    cylinder(r=nut_radius, h=10,center=true,$fn=6);
  }
}
}

rotate([-90,0,0])
union() {
  //-- One side
  translate([l/2+thick_side/2,0,0])
  side();

  //-- The other side
  translate([-l/2-thick_side/2,0,0])
  mirror() side();

  //-- Middle part
  cube([l+0.01,w,thick],center=true);

  //-- semi-circle with the drill
  translate([0,-w/2,0])
  difference() {
    cylinder(r=radius,center=true,h=thick,$fn=50);

    translate([0,w2,0])
    cube([2*radius,2*w2,thick+1],center=true);
  
    translate([0,-radius+3,0])
    cylinder(r=drill/2,h=20,$fn=50,center=true);
  }
}




