//-- U-piece for joining two servo Futaba 3003 together
//-- This piece has two drills
//-- (c) Juan Gonzalez-Gomez (Obijuan) Nov-2010
//-- GPL License

use <U_piece.scad>



//--------------------------------------------------------
//-- Input parameters:
//--  l: Length
//--  w: Width
//--  h: height
//--  thick
//--  Drills diameter
//---------------------------------------------------------
module Futaba_U_union2(l=47, w=10, h=22, thick=3, drill=3, bottom_thick=3, nuts=true)
{
  //-- Nut
  nut_h = 2.5;
  nut_radius = 6.4/2;
  nut_drill = 3.1;

  //-- Parameters for the Futaba 3003 holes
  //-- Distrance from the base (1st drill)
  //zd=5.2;
  zd=7.2;
  
  //-- Distance from one side
  xd=4.1;

  //-- Distance between drills
  dd=9.6;

  difference() {
    U_piece(l, w, h, thick,bottom_thick);

    translate([w/2-xd,0,thick/2+zd])
      rotate([90,0,0])
        cylinder(h=l*1.5, r=drill/2, center=true, $fn=20);

    translate([w/2-xd,0,thick/2+zd+dd])
      rotate([90,0,0])
        cylinder(h=l*1.5, r=drill/2, center=true, $fn=20);

     if (nuts==true) {
      translate([w/2-xd,0,bottom_thick/2+zd])
      rotate([90,0,0])
      cylinder(r=nut_radius, h=l+2*nut_h,center=true,$fn=6);

		translate([w/2-xd,0,bottom_thick/2+zd+dd])
      rotate([90,0,0])
      cylinder(r=nut_radius, h=l+2*nut_h,center=true,$fn=6);
    }
  }
}

//-- Render the piece
Futaba_U_union2();