
/* 
*************************************************************************
    The -- SWIG IF'YA CAN -- Jar ... a party gag
    Copyright (C) 2011 Lukas Süss

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
************************************************************************* 
*/


/* 
**************************************************************************

Thingiverse Description:


The -- SWIG IF YA CAN -- Jar

The purpouse of a jar's is to be able to drink from it, you thought? 
Not with this one! It makes it hard for amusement.
Serve your victim a drink and have fun.

It was inspired by a jar with
the german dialectic inscription "SAUF WONNST KONNST" 
which translates well to the choosen title.

------------------------------------------------------------------------

I couldnt find the correct english name of this thing, only a huge lot of german synonyms
(vexierkrug, vexiergefäß, lochkrug, halbekrug, scherzkrug, gaudikrug)
If someone knows the correct english term, please comment.
All my guesses (puzzling jar, TRY jar, ..) where obviously wrong.





Thingiverse Instructions:

You should be confident to be able to print watertight objects. (wallthicknesses are tjar & tceram)
In the *.scad file: choose anglemouth >= 45° for supportless printing.
The numbers in the *.stl filename are explained in te *.scad file.
There are some notes for ceramic printing in the code too. (I might try a shapeways print)

If you know the "secret" of such jars or just want to have fun with your friends and
don't care to spoil it for yourself, then just print it without precautions.

If you don't know what this is all about, want to try it and want to be suprised
(1) either Download a final *.stl or
choose Your settings in the "user area" but don't look below it. use F5 for a rough preview 
(do not turn the model) and hide the rendering window before hitting F6. Also don't inspect the generated *.stl
(2) let it print from someone else. You MUST NOT WATCH while printing.
(it's not that much of a thing though)

************************************************************************** */




// USER AREA:
// (A,B,C,D marked parameters are in the *.stl filenames)



npillar = 7; // chosse odd preferably (3,5,7)
// don't use >= 9 pillars unless you want a teamwork jar (joke)
// for djar <= 60 size 5 or even 3 pillars might be more suitable


// approximate jar diameter (the bulges extend outward)
// don't print it too small, so that you can't cheat by taking it in your mouth as a whole!
djar = 50; //<<<<<<<<<<<< A

hjar = djar* 1.20;// aspect ratio
gap  = djar/ (16.0+8); // vertical size of the rectangular holes (relative)

dchannel = 7; // diameter of the drinking channels  <<<<<<<<<< B
// absolute minimum for SW ceramic is 3.5 but probably still won't work


tjar = 2; // actually minimal wallthickness   ( >=3 for ceramic) <<<<<<<<<<<<<<<< C 
tceram = 3; // thickness of connecting walls (> tjar makes sense)
// ceramic print: choose this to make a compromise between 
// homogenous wall thickness & minimimal surface area 
// tceram = (dchannel+ 2*tjar)*0.618;  


lmouth = djar/6; // length of the mouth pieces (relative)
anglemouth = 45; // 60 looks best; set steep (30) for supportless print <<<<<<<<<< D

// RESOLUTION:
vert = 32; // main resolution setting
// vert = 8; // looks stylish!! (<8 buggy)

debug = false; // watch internals & show 1ccm cube
//cube([100,100,100]); // 1cdm cube for size visualisation


offset = (dchannel+tjar/2)/2; // < don't change
// *(-1): pillars outwards (easier to clean);  *(+1): pillars more inward (more liquid volume)
shift = offset*(0.25); 


// END OF END USER AREA





// ################################################################################################################

//AUTOCALCULATED:
rjar=djar/2;
rchannel = dchannel/2;
rpipe = rchannel+tjar; // outer pipe radius
vert0 = vert/2;
vert2 = 2*vert;
eps = 0.01;
angleinlet = 73; // ???? 
theangle = 60; // (< hidden user area)
theradius = 1.5;// (< hidden user area)
//echo(rpipe);
rcenterchannel = djar/2 - tceram/2; //  is that correct





difference()
{
union()
{

  // bottom
  translate([0,0,-rchannel-tjar])
  cylinder(r=rcenterchannel,h=tceram,$fn=vert);
    
  difference() // main jar body
  { 
    // radial outer main hull
    cylinder(r=rjar+shift,h=hjar-2*rpipe-gap,$fn=vert2);
    cylinder(r=rjar-tceram+shift,h=(hjar-rpipe-gap)*1.2,$fn=vert2);
  }

  translate([0,0,hjar-2*rpipe-gap]) // vertical cental torus (no pipe)
  #torus(rcenterchannel+shift,tceram/2);
  //torus(rcenterchannel+shift,rpipe); // ... possible mod

  
  for(i=[0:npillar-1]) // channel-pillars (outer body)
  {
    rotate(360/npillar*i,[0,0,1])
    difference()
    {
      translate([rcenterchannel,0,0])
      cylinder(r=rpipe,h=hjar,$fn=vert);
    }

    // mouthpiece
    rotate(360/npillar*i,[0,0,1])
    translate([rcenterchannel,0,hjar]) rotate(anglemouth,[0,1,0])
    {
      cylinder(r=rpipe,h=rpipe+lmouth,$fn=vert);
      translate([0,0,rpipe+lmouth]) torus(rchannel+tjar/2,tjar/2,vert0);
    }
  }

  translate([0,0,hjar]) // upper outer torus
  torus(rcenterchannel,rpipe);
  translate([0,0,0]) // lower outer torus
  torus(rcenterchannel,rpipe);


  // here lies the mon manifold problem!!
  translate([eps,0,0]) // manifoldisate
  mirror([1,0,0])
  {
    // outer handle part:
    translate([rcenterchannel,0,hjar/2])
    //scale([1.0,1,1]) 
    rotate(90,[1,0,0])
    intersection()
    {
      torus(hjar/2,rpipe);
      translate([(hjar+2*rpipe)/4,0,0])
      cube([(hjar+2*rpipe)/2, hjar+2*rpipe, 2*rpipe],center=true);
    }
  }


}


// subtract ...



  // comment out => F5 works
  
  for(i=[0:npillar-1]) // channel-pillars (inner body)
  {
    rotate(360/npillar*i,[0,0,1])
    difference()
    {
      translate([rcenterchannel,0,0])
      cylinder(r=rchannel,h=hjar,$fn=vert);
    }

    // mouthpiece
    rotate(360/npillar*i,[0,0,1])
    translate([rcenterchannel,0,hjar]) rotate(anglemouth,[0,1,0])
    cylinder(r=rchannel,h=rpipe+lmouth*1.2,$fn=vert);

     // INLETS
    rotate(360/npillar*i,[0,0,1])
    translate([rcenterchannel,0,0]) rotate(-angleinlet,[0,1,0])
    cylinder(r=rchannel,h=rjar*1.25,$fn=vert);

  }

    
    
  translate([0,0,hjar]) // upper inner torus
  torus(rcenterchannel,rchannel);
  translate([0,0,0]) // lower inner torus
  torus(rcenterchannel,rchannel);



  // inner handle part
  translate([eps,0,0]) // manifoldisate 
  mirror([1,0,0])
  {
    // outer handle part:
    translate([rcenterchannel,0,hjar/2])
    //scale([1.0,1,1]) 
    rotate(90,[1,0,0])
    {
      // undocument this block temporarely to get under the renderagility threshold #
      
      difference()
      {
        torus(hjar/2,rchannel); // grasp-channel
        
        translate([-(hjar+2*rpipe)/4-eps,0,0]) // half the grasp torus
        cube([(hjar+2*rpipe)/2, hjar+2*rpipe, 2*rpipe],center=true);
       }
       

      // deliberately undocumented
      rotate(theangle,[0,0,1])
      translate([hjar/2-1.2*rpipe,0,0])
      rotate(90,[0,1,0])
      cylinder(r=theradius,h=1.2*rpipe,$fn=vert); // #
      // doesint show up INTERSECTION use is bad use difference !!!
     }
  }




  // DEBUG
  if(debug) { translate([-100,0,-20]) cube([200,80,200]);}

}

// measurement cube 1ccm
if(debug) {translate([0,0,-20]) cube([10,10,10]);}





module torus(rbig,rsmall,res=vert)
{
  rotate_extrude(convexity=6,$fn=2*res)
  translate([rbig,0,0])
  circle(r=rsmall,$fn=res);
}









/*

Additional Infos: 
------------------------

"sauf wonnst konnst": googling results (german)

http://www.volkskundemuseum.at/index.php?id=247
http://www.volkskundemuseum.at/index.php?id=125:
 
cited: "Die Bezeichnung leitet sich aus dem lateinischen Wort „vexare" ab, was plagen, quälen, necken, irreführen bedeutet, und auf die komplizierte Form der Flüssigkeitsentnahme hinweist."

-----------------------

  TODO:

  > change the shape of the grasp to less overhanging (rectangular?)
  > even mouthpiecenumbers: place grasp between mouthpieces
  
  > make resolution <=8 usable
  > option: make middle torus (upper connectng wall edge) to a pipe?

  possible mods:
  > slant outward?  > spiral?  

-------------------------------

Shapeways ceramic:
min detail 2mm
min wall 3mm
max 9x23x15cm
+-2.5%
multipartfile ok
min clearance 3.5mm

*/



