fn = 32;		//	
cl = 0.5;		//	Clearance

//	Variables for the barrel
bt = 3;		//	Thickness of barrel rig

//	Variables for the dics
dd = 18.2;		//	Disc diameter
dr = dd/2;		//	Disc radius
dt = 2;		//	Disc thickness
dsw = 2.5;		//	Width of slot in disc
dsn = 4;		//	Number of slots in disc
dso = 1.75;		//	Offset from edge of slot
dhd = 5.5;		//	Diameter of hole in center of disc
dhr = dhd/2;	//	Radius of hole in center of disc
dsa = 40;		//	Angle of slot/slice
dsd = 1;		//	Direction of slot/slice

//	Variables for the pin
pl = 40;		//	Pin length
pw = dd-5;		//	Pin width
pft = 3;		//	Pin fin thickness

module gunparts(a)
	{
	if (a==1) { discs(1); }	//	0 produced a plate, 1 produces a test plate

	if (a==2) 
		{ firingpin(); }
	if (a==3)
		{ barreltop(); }
	if (a==4)
		{ barrelbottom(); }
	if (a==5)
		{ barrelcap(); }
	}

module test()
	{
	translate([0,0,0.75]) 
	union() {
		translate([17.5,0,0]) firingpin();
		translate([-15,0,0]) firingpin();
		translate([-20,0,-0.75]) disc();
		}
	barreltop();
	barrelbottom();
	barrelcap();
	}

module printplates(plate=1)
	{
	% square(90,true);
	if (plate==1)
		{
		translate([0,20,3.25]) barreltop();
		translate([0,-20,6.775]) rotate([0,180,0]) barrelbottom();
		}
	if (plate==2)
		{ discs(1); }
	if (plate==3)
		{
		translate([25,0,48-0.75]) rotate([0,-90,0]) barrelcap();
		translate([-15,0,0]) firingpin();
		}
	}

printplates(1);

module barrelcap()
	{
	difference()
		{
		union()
			{
			translate([-42.5+2.5-bt/2,0,1.75]) cube([10+bt,dd+cl+bt*2+cl/2+bt*2,bt+cl+pft+bt+cl*2+bt*2],true);
			
			}
		translate([-42.5+2.5,0,1.75]) cube([11,dd+cl+bt*2+cl/2,bt+cl+pft+bt+cl*2],true);	//	Barrel size
		translate([-40,0,1.25]) cube([30,dd+bt,5],true);							//	Barrel exit
		translate([-48,dd/2+bt,0]) cylinder(50,r=1.25,center=true,$fn=fn/3);
		translate([-48,-dd/2-bt,0]) cylinder(50,r=1.25,center=true,$fn=fn/3);
		translate([-48,0,7]) rotate([90,0,0]) cylinder(50,r=1.25,center=true,$fn=fn/3);
		translate([-48,0,-3]) rotate([90,0,0]) cylinder(50,r=1.25,center=true,$fn=fn/3);
		}
	}

module barreltop()
	{
	difference()
		{
		cube([90,dd+cl+bt*2,bt+cl+pft],true);						//	Barrel top
		translate([16,0,2]) cube([52,dd+bt*2+5,4],true);				//	Cutout for fins to slide
		translate([-5.5,0,2]) rotate([0,0,45]) cube([dd,dd,4],true);			//	Bevel cutout for pin to slide in
		translate([-45,0,bt-cl]) cube([50,dd+0.5,5],true);				//	Barrel cutout for disc
		translate([-36,0,bt-cl-0.5]) cube([50,pw+1,5],true);				//	Barrel cutout for pin
		translate([-20,0,0]) cylinder(dt+cl+3,dr+cl/2,dr+cl,$fn=fn);			//	Cylindrical cutout for disc
		translate([-35,0,2+dt+cl]) cube([30,dd+bt*2+5,4],true);			//	Cutout for disc barrel
		translate([40-cl/4,0,0]) cube([4+cl/2,10+cl/2,15],true);			//	Latch for barrel bottom
		}
	}

module barrelbottom()
	{
	translate([0,0,5.01])
	difference()
		{
		union()
			{
			cube([90,dd+cl+bt*2,bt+cl],true);						//	Barrel bottom
			translate([40-cl/4,0,-3.5]) cube([4,10,9.5],true);				//	Latch for barrel bottom
			translate([40-cl/4,0,-3]) cube([4,dd+cl+bt*2,4-cl],true);		//	Wide sides for latch for barrel bottom
			translate([-32.5-cl/4,0,dt+cl+1-5]) cube([25-cl/2,dd+cl+bt*2,2],true);	//	Barrel stop for 2nd disc
			}
		translate([13.75+bt/2,0,0]) cube([47.5-bt,pw+cl,bt+5],true);		//	Rail cutout
		translate([-20,0,dt+cl-6]) cylinder(10,r=dr+cl,$fn=fn);				//	Cylindrical cutout
		translate([-40,0,bt-cl-0.5-6.5]) cube([50,pw+1,5],true);				//	Barrel cutout for pin/disc
		}
	}


module firingpin()
	{
	difference()
		{
		union()
			{
			intersection()
				{
				cube([pl,pw,1.5],true);								//	Long pin		
				translate([10,31,0]) scale([1,1.25,1]) 					//	Sharp edge to pin
					cylinder(1.5,r=dd*2,center=true);
				}
			translate([12.5+bt/2,0,bt/2+5/2]) cube([15-bt,pw,5],true);				//	Rail
			intersection()
				{
				translate([12.5,0,0.75]) cube([15,dd+bt*2+18,pft],true);		//	Fins
				translate([22,0,0]) cylinder(10,r=20,center=true,$fn=fn);		//	Curve it off
				}
			}
		translate([19,-15,0]) scale([2,1,1]) cylinder(10,r=2,center=true,$fn=16);		//	Holes for rubber band
		translate([19,15,0]) scale([2,1,1]) cylinder(10,r=2,center=true,$fn=16);		//	Holes for rubber band
		}
	}

//	This section is for the discs
module discs(test=0)
	{
	for (i=[-1:1]) 
	{ for (j=[-1:1]) 
		{ translate([dr*3*i,dr*3*j,0]) 
		if (test==1) { disc(i+dsn-1,j); }
		else { disc(4,0); } } 
	} }

module disc(variant=2,directionofrotation=0)
	{
	difference()
		{
		cylinder(dt,r=dr,$fn=fn);
		translate([0,0,-0.5]) cylinder(dt+1,r=dhr,$fn=fn/2);
		cutout(variant,directionofrotation);
		}
	}

module cutout(segments = 2,rotation=0)
	{
	spin = 180/segments;
	linear_extrude(height=dt*3,twist=40*rotation,slices=fn,center=true) 
	union() {
		for (i=[1:segments]) { translate([0,0,0]) rotate([0,0,spin*i*2]) cutout0(spin); }
		}
	}

module cutoutring()
	{ 
	difference() {circle(dr-dso); circle(dr - dso - dsw); } 
	}

module cutout0(spin)
	{ intersection() 
		{ rotate([0,0,90-spin]) intersection() { cutoutring(); square(dr+1); } square(dr+1); } 
	}