//Overall Opener Configuration
base = 22;
length=50;
baseR1=5;
baseR2=5;
thickness=6;
angle = 13.5;

//Hole Configuration
holeBaseWidth=23;
holeBaseLoc=25.5;
holeLength=19.5;
holeR1=2;
holeR2=6;

//KeyRingSlot
slotWidth = 17;
slotHeight = 6;
slotInset=2.5;


//Coin Size and position
coinRadius = 9.5;
coinThickness = 1.75;
coinOverhang = 3;

//set to false if you don't want the makerbot M to appear
UseBadgeTop=true;
UseBadgeBottom=false;



if(UseBadgeTop)
{
	translate([(holeBaseLoc+slotHeight+slotInset)/2,base/2,thickness])
	{
		rotate([0,0,-90])MakerbotM((holeBaseLoc-slotHeight-slotInset)/2,0.5);
		difference()
		{
			cylinder(r=(holeBaseLoc-slotHeight-slotInset)*0.45, h=0.5);
			cylinder(r=(holeBaseLoc-slotHeight-slotInset)*0.45-1.5, h=0.5);
		}
	}	
}

difference()
{
	roundedTrapezoid(length=length, r1=baseR1, r2=baseR2,thick=thickness, baseW=base, angle=angle);

	translate([holeBaseLoc,(base-holeBaseWidth)/2,0]) roundedTrapezoid(thick=thickness, baseW=holeBaseWidth, angle=angle, length=holeLength, r1=holeR1, r2=holeR2);
	translate([slotHeight/2+slotInset,(base-slotWidth+slotHeight)/2,0])cylinder(r=slotHeight/2, h=thickness);
	translate([slotHeight/2+slotInset,(base+slotWidth-slotHeight)/2,0])cylinder(r=slotHeight/2, h=thickness);
	translate([slotInset,(base-slotWidth+slotHeight)/2,0])cube([slotHeight,slotWidth-slotHeight,thickness]);

	translate([holeBaseLoc-coinRadius+coinOverhang,base/2,(thickness-coinThickness)/2])
	{
		translate([0,-coinRadius,0])cube([coinRadius,2*coinRadius,coinThickness]);
		cylinder(r=coinRadius,h=coinThickness);
	}

	if(UseBadgeBottom)
	{
		translate([(holeBaseLoc+slotHeight+slotInset)/2,base/2,0])
		{
			rotate([0,0,-90])MakerbotM((holeBaseLoc-slotHeight-slotInset)/2,0.5);
			difference()
			{
				cylinder(r=(holeBaseLoc-slotHeight-slotInset)*0.45, h=0.5);
				cylinder(r=(holeBaseLoc-slotHeight-slotInset)*0.45-1.5, h=0.5);
			}
		}	
	}
}



module roundedTrapezoid(thick=5, length=19.5, r1=2, r2=9.5, angle=13.5, baseW=23)
{
	x1 = length*sin(angle);
	difference()
	{
		trapezoidSolid(thick = thick, length = length, r1=r1, r2=r2, angle = angle, baseW=baseW);
		translate([length,-1*x1,0])cube([2*r2-length,baseW+2*x1,thick]);
		rotate([0,0,-1*angle])translate([0,-1*(r1+r2),0])cube([length,r1+r2, thick]);
		translate([0,baseW,0]) rotate([0,0,angle])cube([ length,r1+r2, thick]);
	}
}


module trapezoidSolid(thick=5, length=19.5, r1=1, r2=9.5, angle=13.5, baseW=23)
{
	r1oSet = length/cos(angle)-r1*tan((90+angle)/2);// -r1-r1*tan(angle);//-r1/cos(angle);
	sideoSet = r2*tan((90-angle)/2);//  r2*(1- tan(angle));
	sidelen = r1oSet-sideoSet;
	bottomoSet = (length*sin(angle))-r1*tan((90+angle)/2);

	rotate([0,0,-1*angle])
	{
		translate([r1oSet,r1,0])cylinder(h=thick, r=r1);
		translate([sideoSet,r2,0])cylinder(h=thick,r=r2);
		translate([sideoSet,0,0]) cube([sidelen,2*r1,thick]);
	}
	
	translate([0,baseW,0])rotate([0,0,angle])
	{
		translate([0,-2*r1,0])
		{
			translate([r1oSet,r1,0])cylinder(h=thick, r=r1);
			translate([sideoSet,-r2+2*r1,0])cylinder(h=thick,r=r2);
			translate([sideoSet,0,0]) cube([sidelen,2*r1,thick]);
		}
	}
	translate([0,sideoSet,0])cube([length,baseW-2*sideoSet,thick]);
	translate([r2,-bottomoSet,0])cube([length-r2,baseW+2*bottomoSet,thick]);
}

module MakerbotM(height, thickness) 
{
	radius = height/5.5;
	translate([-1.25*radius,1.5*radius,0])
	{
		difference()
		{
			cylinder(r=radius,h = thickness);
			translate([0,-1*radius,0])cube([radius,radius,thickness]);
		}
		
		translate([2.5*radius,0,0])difference()
		{
			cylinder(r=radius,h = thickness);
			translate([-1*radius,-1*radius,0])cube([radius,radius,thickness]);
		}
		translate([-1*radius,0,0])
		{
			translate([0,-3.5*radius,0])cube([radius,3.5*radius,thickness]);
			translate([radius/2,-3.5*radius,0])cylinder(r=radius/2,h=thickness);
		}
		
		translate([0.75*radius,0,0])
		{
			translate([0,-3.5*radius,0])cube([radius,3.5*radius,thickness]);
			translate([radius/2,-3.5*radius,0])cylinder(r=radius/2,h=thickness);
		}
		translate([2.5*radius,0,0])
		{
			translate([0,-3.5*radius,0])cube([radius,3.5*radius,thickness]);
			translate([radius/2,-3.5*radius,0])cylinder(r=radius/2,h=thickness);
		}
		cube([2.5*radius,radius,thickness]);
	}
}