function [h lineLength] = lineL(X, Y)
% function [h lineLength] = lineL(X, Y)
%
% This is a MATLAB function that draws a line with parameters X Y.
% It does the same thing as the built-in MATLAB line function but it
% also returns the length of the line and prints an EAGLE PCB command to 
% a file.  It is meant for use with flatcoilwind.
%
% Version 1.0 Initial Release - Aug 31 2011
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  
%  Copyright 2010, 2011 Matt Moses   
%  mmoses152 at gmail dot com
% 
%  This file is part of flatcoilwind. 
%
%  flatcoilwind is free software: you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation, either version 3 of the License, or
%  (at your option) any later version.
%
%  flatcoilwind is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with flatcoilwind.  If not, see <http://www.gnu.org/licenses/>.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global fileOutputEnable
global fileKicadEnable
global fidOut
global kicadLayer
global kicadWidth

h = line(X,Y);
lineLength = ((X(2)-X(1))^2 + (Y(2)-Y(1))^2)^0.5;

if (fileOutputEnable)
    lineout = sprintf('wire (%0.4f %0.4f) (%0.4f %0.4f);',X(1), Y(1), X(2), Y(2));
    fprintf(fidOut, '%s\n', lineout);
end
if (fileKicadEnable)
		if (kicadLayer == 0)
			lineout = sprintf('DS %0.0f %0.0f %0.0f %0.0f %0.0f 0',10000*X(1), 10000*Y(1), 10000*X(2), 10000*Y(2), kicadWidth);
			fprintf(fidOut, '%s\n', lineout);
		else 
			lineout = sprintf('DS %0.0f %0.0f %0.0f %0.0f %0.0f 15', 10000*X(1), 10000*Y(1), 10000*X(2), 10000*Y(2), kicadWidth);
			fprintf(fidOut, '%s\n', lineout);
		end
	end
end