skull_scale = 1.2;	// My skull files are too small

// I made the slot long enough for a US quarter,
// but wide enough for a US nickle. The fudge
// values are just to make insertion easy and
// to make up for a printer that's not perfectly
// calibrated.

// A quick Google suggests that a diameter of
// 26mm and a thickness of 2.5mm will probably
// allow all Euro coins to fit.

// If you do that, you may want to change the X offset
// on the coin slot. I wanted to avoid having it hit
// the ceiling inside the skull as I thought that may
// cuase stringing as the printer attempted to print
// the part of the ceiling that hits the slot.

slot_diameter = 25;
slot_d_fudge = 1.5;
slot_thickness = 2;
slot_t_fudge = 0.8;


difference() {
	// The skull body

	scale([skull_scale, skull_scale, skull_scale]) {
		import_stl("skull_lid_fixed.stl");
	}

	// The coin slot, translated to look nice
	// and avoid the ceiling inside the skull.

	translate([28, 0, 10]) {
		rotate([0, -60, 0]) {
			cube([slot_diameter + slot_d_fudge,
					slot_thickness + slot_t_fudge,
					slot_diameter + slot_d_fudge], true);
		}
	}
}

