height = 2.5;
box_x = 99;
box_y = 54.5;
internal_x = 94;		// Measured = 92.7
internal_y = 49.5;		// Measured = 48.5
bolt_size = 3.1;
lug_rad = 5;

wall_x = (box_x - internal_x)/2;
wall_y = (box_y - internal_y)/2;
wall_z = 3;

rotate (90) 
difference()
{
union()
{
// Main box
translate([0,0,height/2])						cube([box_x,box_y,height], center=true);

// Bolt Lugs
translate([box_x/2-lug_rad,box_y/2,height/2])		cylinder(height,lug_rad,lug_rad, center=true);
translate([-box_x/2+lug_rad,box_y/2,height/2]) 	cylinder(height,lug_rad,lug_rad, center=true);
translate([box_x/2-lug_rad,-box_y/2,height/2]) 	cylinder(height,lug_rad,lug_rad, center=true);
translate([-box_x/2+lug_rad,-box_y/2,height/2]) 	cylinder(height,lug_rad,lug_rad, center=true);

// Countour curve fills
translate([ box_x/2-2*lug_rad,	box_y/2,height/2])			cube([lug_rad*1.38,lug_rad,height], center=true);
translate([-box_x/2+2*lug_rad,	box_y/2,height/2]) 		cube([lug_rad*1.38,lug_rad,height], center=true);
translate([ box_x/2-2*lug_rad, -box_y/2,height/2]) 		cube([lug_rad*1.38,lug_rad,height], center=true);
translate([-box_x/2+2*lug_rad, -box_y/2,height/2]) 		cube([lug_rad*1.38,lug_rad,height], center=true);

// Buttons
translate([box_x/2-35,box_y/2+10,height]) 		cylinder(5,2.4,2.4, center=true, $fn=16);
translate([box_x/2-35,box_y/2+10,0.5]) 	cylinder(1,3,3, center=true, $fn=32);
translate([box_x/2-45,box_y/2+10,height]) 		cylinder(5,2.4,2.4, center=true, $fn=16);
translate([box_x/2-45,box_y/2+10,0.5]) 	cylinder(1,3,3, center=true, $fn=32);
translate([box_x/2-55,box_y/2+10,height]) 		cylinder(5,2.4,2.4, center=true, $fn=16);
translate([box_x/2-55,box_y/2+10,0.5]) 	cylinder(1,3,3, center=true, $fn=32);
translate([box_x/2-65,box_y/2+10,height]) 		cylinder(5,2.4,2.4, center=true, $fn=16);
translate([box_x/2-65,box_y/2+10,0.5]) 	cylinder(1,3,3, center=true, $fn=32);

}
// Main cavity
//translate([0,0,(height/2)+wall_z]) 				cube([box_x - wall_x*2,box_y - wall_y*2,height], center=true);

// Push button holes
translate([internal_x/2-6,-internal_y/2+4.5,0])		cylinder(height+2,2.5,2.5, $fn=32);
translate([internal_x/2-18.5,-internal_y/2+4.5,0])		cylinder(height+2,2.5,2.5, $fn=32);

// Bolt holes
translate([box_x/2-lug_rad,box_y/2,-1]) 			cylinder(height+2,bolt_size/2,bolt_size/2, $fn=32);
translate([-box_x/2+lug_rad,box_y/2,-1]) 		cylinder(height+2,bolt_size/2,bolt_size/2, $fn=32);
translate([box_x/2-lug_rad,-box_y/2,-1]) 		cylinder(height+2,bolt_size/2,bolt_size/2, $fn=32);
translate([-box_x/2+lug_rad,-box_y/2,-1])		cylinder(height+2,bolt_size/2,bolt_size/2, $fn=32);

// Outside curves
translate([ box_x/2-2.69*lug_rad, box_y/2+5,height/2])		cylinder(height+2,lug_rad,lug_rad, center=true);
translate([-box_x/2+2.69*lug_rad, box_y/2+5,height/2]) 	cylinder(height+2,lug_rad,lug_rad, center=true);
translate([ box_x/2-2.69*lug_rad,-box_y/2-5,height/2]) 	cylinder(height+2,lug_rad,lug_rad, center=true);
translate([-box_x/2+2.69*lug_rad,-box_y/2-5,height/2]) 	cylinder(height+2,lug_rad,lug_rad, center=true);

//USB Cut out (check size)
//translate([box_x/2-1,0,7.5])					cube([(box_x-internal_x)/2+2,8,6], center=true);

// Probe pins
//translate([-box_x/2+1,0,7.25])					cube([(box_x-internal_x)/2+2,46,6], center=true);

// Thru-hole solder points
//translate([-internal_x/2+2.5, 0, 2])			cube([5, internal_y, 3], center=true);

//Slice from the holes to make them easier to print
translate([box_x/2-lug_rad,box_y/2,-1])	 	rotate(315) cube([0.1,lug_rad+1,height+2]);
translate([-box_x/2+lug_rad,box_y/2,-1])	 	rotate(45) cube([0.1,lug_rad+1,height+2]);
translate([box_x/2-lug_rad,-box_y/2,-1])	 	rotate(225) cube([0.1,lug_rad+1,height+2]);
translate([-box_x/2+lug_rad,-box_y/2,-1])	rotate(135) cube([0.1,lug_rad+1,height+2]);

}

