include <genlib.scad>;
include <misumi-25mm.scad>;

// Azteeg X1 Board
hole_dist_w = 90;
hole_dist_l = 43.5;
hole_offset = 12;
center_dist = 51;

hole_mount_offset = -22;
board_h = 20;
support_thickness=5;

$fn=50;

board_mount();

module board_mount() {

difference() {
union() {
	for ( i = [-1,1] ) {

		translate([i*hole_dist_w/2,(i*hole_dist_l/2)+hole_offset,0])hole_support(cone_offset=4);
		translate([i*hole_dist_w/2,(i*-hole_dist_l/2)+hole_offset,0])hole_support(cone_offset=4);

		bone(start=[i*center_dist/2,0,0],end=[i*hole_dist_w/2,(i*hole_dist_l/2)+hole_offset,0],thickness=support_thickness,start_dia=10,end_dia=20,rib=2);
		bone(start=[i*center_dist/2,0,0],end=[i*hole_dist_w/2,(i*-hole_dist_l/2)+hole_offset,0],thickness=support_thickness,start_dia=10,end_dia=20,rib=2);

		bone(start=[i*((center_dist/2)),0,0],end=[0,0,0],thickness=support_thickness,start_dia=20,end_dia=20);

		bone(start=[i*((center_dist/2)),0,0],end=[i*((hole_dist_w/4)-5),hole_mount_offset,0],thickness=support_thickness,start_dia=25,end_dia=25/2);

		bone(start=[i*((center_dist/2)),0,0],end=[i*((hole_dist_w/4)-5),hole_mount_offset,0],thickness=support_thickness*2,start_dia=4,end_dia=25/2);

	}
}
	for ( i = [-1,1] ) {

		translate([i*hole_dist_w/2,(i*hole_dist_l/2)+hole_offset,0])hole_support_hole();
		translate([i*hole_dist_w/2,(i*-hole_dist_l/2)+hole_offset,0])hole_support_hole();

		#translate([i*((hole_dist_w/4)-5),hole_mount_offset,support_thickness])rotate([0,180,0])
		screw_nut(screw_r=m4_screw/2,screw_len=10,head_r=m4_head/2,head_len=10,head_gap=0,nut_r=0,nut_len=2,nut_gap=0);
	}
}
};

module bone(start=[0,0,0],end=[0,0,0],thickness=1,start_dia=5,end_dia=10, rib=0,rib_ratio=3) {
hull() {
	translate(end)cylinder(r=end_dia/2,h=thickness);
	translate(start)cylinder(r=start_dia/2,h=thickness);
}
if (rib>0) {
hull() {
	translate(end)translate([0,0,thickness])cylinder(r=rib,h=rib*rib_ratio);
	translate(start)translate([0,0,thickness])cylinder(r=rib,h=rib*rib_ratio);
}
}
};

module hole_support(cone_offset=2) {
	cylinder(r2=(m2_5_screw+3)/2,r1=(m2_5_screw+3+cone_offset)/2,h=board_h);
};

module hole_support_hole() {
	cylinder(r=m2_5_screw/2,h=board_h);
};